/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.authentication;

import com.google.common.collect.ImmutableSet;
import org.apache.james.jwt.JwtTokenVerifier;
import org.apache.james.webadmin.authentication.JwtFilter;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import spark.HaltException;
import spark.Request;
import spark.Response;

public class JwtFilterTest {
    public static final Matcher<HaltException> STATUS_CODE_MATCHER_401 = new BaseMatcher<HaltException>(){

        public boolean matches(Object o) {
            if (o instanceof HaltException) {
                HaltException haltException = (HaltException)o;
                return haltException.statusCode() == 401;
            }
            return false;
        }

        public void describeTo(Description description) {
        }
    };
    private JwtTokenVerifier jwtTokenVerifier;
    private JwtFilter jwtFilter;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.jwtTokenVerifier = (JwtTokenVerifier)Mockito.mock(JwtTokenVerifier.class);
        this.jwtFilter = new JwtFilter(this.jwtTokenVerifier);
    }

    @Test
    public void handleShouldRejectRequestWithHeaders() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.headers()).thenReturn((Object)ImmutableSet.of());
        this.expectedException.expect(HaltException.class);
        this.expectedException.expect(STATUS_CODE_MATCHER_401);
        this.jwtFilter.handle(request, (Response)Mockito.mock(Response.class));
    }

    @Test
    public void handleShouldRejectRequestWithBearersHeaders() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.headers("Authorization")).thenReturn((Object)"Invalid value");
        this.expectedException.expect(HaltException.class);
        this.expectedException.expect(STATUS_CODE_MATCHER_401);
        this.jwtFilter.handle(request, (Response)Mockito.mock(Response.class));
    }

    @Test
    public void handleShouldRejectRequestWithInvalidBearerHeaders() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.headers("Authorization")).thenReturn((Object)"Bearer value");
        Mockito.when((Object)this.jwtTokenVerifier.verify("value")).thenReturn((Object)false);
        this.expectedException.expect(HaltException.class);
        this.expectedException.expect(STATUS_CODE_MATCHER_401);
        this.jwtFilter.handle(request, (Response)Mockito.mock(Response.class));
    }

    @Test
    public void handleShouldRejectRequestWithoutAdminClaim() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.headers("Authorization")).thenReturn((Object)"Bearer value");
        Mockito.when((Object)this.jwtTokenVerifier.verify("value")).thenReturn((Object)true);
        Mockito.when((Object)this.jwtTokenVerifier.hasAttribute("admin", (Object)true, "value")).thenReturn((Object)false);
        this.expectedException.expect(HaltException.class);
        this.expectedException.expect(STATUS_CODE_MATCHER_401);
        this.jwtFilter.handle(request, (Response)Mockito.mock(Response.class));
    }

    @Test
    public void handleShouldAcceptValidJwt() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.headers("Authorization")).thenReturn((Object)"Bearer value");
        Mockito.when((Object)this.jwtTokenVerifier.verify("value")).thenReturn((Object)true);
        Mockito.when((Object)this.jwtTokenVerifier.hasAttribute("admin", (Object)true, "value")).thenReturn((Object)true);
        this.jwtFilter.handle(request, (Response)Mockito.mock(Response.class));
    }
}

