/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin;

import java.util.function.Function;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.webadmin.FixedPort;
import org.apache.james.webadmin.Port;
import org.apache.james.webadmin.TlsConfiguration;
import org.apache.james.webadmin.WebAdminConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class WebAdminConfigurationTest {
    public static final FixedPort PORT = new FixedPort(80);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void buildShouldThrowWhenNoPortButEnabled() {
        this.expectedException.expect(IllegalStateException.class);
        WebAdminConfiguration.builder().enabled().build();
    }

    @Test
    public void buildShouldWorkWithoutPortWhenDisabled() {
        Assertions.assertThat((Object)WebAdminConfiguration.builder().disabled().build()).extracting(new Function[]{WebAdminConfiguration::isEnabled}).containsExactly(new Object[]{false});
    }

    @Test
    public void buildShouldFailOnNoEnable() {
        this.expectedException.expect(IllegalStateException.class);
        WebAdminConfiguration.builder().port((Port)PORT).build();
    }

    @Test
    public void builderShouldBuildWithRightPort() {
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().port((Port)PORT).build()).extracting(new Function[]{WebAdminConfiguration::getPort}).containsExactly(new Object[]{PORT});
    }

    @Test
    public void builderShouldBuildWithEnable() {
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().port((Port)PORT).build()).extracting(new Function[]{WebAdminConfiguration::isEnabled}).containsExactly(new Object[]{true});
    }

    @Test
    public void builderShouldAcceptHttps() {
        TlsConfiguration tlsConfiguration = TlsConfiguration.builder().selfSigned("abcd", "efgh").build();
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().tls(tlsConfiguration).port((Port)PORT).build()).extracting(new Function[]{WebAdminConfiguration::getTlsConfiguration}).containsExactly(new Object[]{tlsConfiguration});
    }

    @Test
    public void builderShouldReturnTlsEnableWhenTlsConfiguration() {
        TlsConfiguration tlsConfiguration = TlsConfiguration.builder().selfSigned("abcd", "efgh").build();
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().tls(tlsConfiguration).port((Port)PORT).build()).extracting(new Function[]{WebAdminConfiguration::getTlsConfiguration}).containsExactly(new Object[]{tlsConfiguration});
    }

    @Test
    public void builderShouldReturnTlsDisableWhenNoTlsConfiguration() {
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().port((Port)PORT).build()).extracting(new Function[]{WebAdminConfiguration::isTlsEnabled}).containsExactly(new Object[]{false});
    }

    @Test
    public void builderShouldCORSEnabled() {
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().port((Port)PORT).CORSenabled().build()).extracting(new Function[]{WebAdminConfiguration::isEnableCORS}).containsExactly(new Object[]{true});
    }

    @Test
    public void builderShouldAcceptAllOriginsByDefault() {
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().port((Port)PORT).CORSenabled().build()).extracting(new Function[]{WebAdminConfiguration::getUrlCORSOrigin}).containsExactly(new Object[]{"*"});
    }

    @Test
    public void builderShouldCORSDisabled() {
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().port((Port)PORT).CORSdisabled().build()).extracting(new Function[]{WebAdminConfiguration::isEnableCORS}).containsExactly(new Object[]{false});
    }

    @Test
    public void builderShouldCORSWithOrigin() {
        String origin = "linagora.com";
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().port((Port)PORT).CORSenabled().urlCORSOrigin(origin).build()).extracting(new Function[]{WebAdminConfiguration::getUrlCORSOrigin}).containsExactly(new Object[]{origin});
    }

    @Test
    public void shouldMatchBeanContract() {
        EqualsVerifier.forClass(WebAdminConfiguration.class).verify();
    }
}

