/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.webadmin.TlsConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TlsConfigurationTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void buildShouldThrowWhenNotEnabled() {
        this.expectedException.expect(IllegalStateException.class);
        TlsConfiguration.builder().build();
    }

    @Test
    public void buildShouldThrowWhenEnableWithoutKeystore() {
        this.expectedException.expect(IllegalStateException.class);
        TlsConfiguration.builder().build();
    }

    @Test
    public void selfSignedShouldThrowOnNullKeyStorePath() {
        this.expectedException.expect(NullPointerException.class);
        TlsConfiguration.builder().selfSigned(null, "abc");
    }

    @Test
    public void selfSignedShouldThrowOnNullKeyStorePassword() {
        this.expectedException.expect(NullPointerException.class);
        TlsConfiguration.builder().selfSigned("abc", null);
    }

    @Test
    public void buildShouldWorkOnSelfSignedHttps() {
        Assertions.assertThat((Object)TlsConfiguration.builder().selfSigned("abcd", "efgh").build()).isEqualTo((Object)new TlsConfiguration("abcd", "efgh", null, null));
    }

    @Test
    public void buildShouldWorkOnTrustedHttps() {
        Assertions.assertThat((Object)TlsConfiguration.builder().raw("a", "b", "c", "d").build()).isEqualTo((Object)new TlsConfiguration("a", "b", "c", "d"));
    }

    @Test
    public void shouldRespectBeanContract() {
        EqualsVerifier.forClass(TlsConfiguration.class).verify();
    }
}

