/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.webadmin.FixedPort;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class FixedPortTest {
    @Test
    public void toIntShouldThrowOnNegativePort() {
        Assertions.assertThatThrownBy(() -> new FixedPort(-1)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void toIntShouldThrowOnNullPort() {
        Assertions.assertThatThrownBy(() -> new FixedPort(0)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void toIntShouldThrowOnTooBigNumbers() {
        Assertions.assertThatThrownBy(() -> new FixedPort(65536)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void toIntShouldReturnedDesiredPort() {
        int expectedPort = 452;
        Assertions.assertThat((int)new FixedPort(expectedPort).toInt()).isEqualTo(expectedPort);
    }

    @Test
    public void shouldMatchBeanContract() {
        EqualsVerifier.forClass(FixedPort.class).verify();
    }
}

