/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.james.json.DTOConverter;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.cassandra.mail.task.SolveMessageInconsistenciesService;
import org.apache.james.mailbox.cassandra.mail.task.SolveMessageInconsistenciesTaskAdditionalInformationDTO;
import org.apache.james.task.Hostname;
import org.apache.james.task.MemoryTaskManager;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.SolveMessageInconsistenciesRequestToTask;
import org.apache.james.webadmin.routes.TasksRoutes;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import reactor.core.publisher.Mono;
import spark.ResponseTransformer;
import spark.Service;

public class SolveMessageInconsistenciesRequestToTaskTest {
    static final String BASE_PATH = "/messages";
    private WebAdminServer webAdminServer;
    private SolveMessageInconsistenciesService service;
    private MemoryTaskManager taskManager;

    @BeforeEach
    void setUp() {
        JsonTransformer jsonTransformer = new JsonTransformer(new JsonTransformerModule[0]);
        this.taskManager = new MemoryTaskManager(new Hostname("foo"));
        this.service = (SolveMessageInconsistenciesService)Mockito.mock(SolveMessageInconsistenciesService.class);
        Mockito.when((Object)this.service.fixMessageInconsistencies((SolveMessageInconsistenciesService.Context)ArgumentMatchers.any(), (SolveMessageInconsistenciesService.RunningOptions)ArgumentMatchers.any())).thenReturn((Object)Mono.just((Object)Task.Result.COMPLETED));
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new TasksRoutes((TaskManager)this.taskManager, jsonTransformer, DTOConverter.of((DTOModule[])new DTOModule[]{SolveMessageInconsistenciesTaskAdditionalInformationDTO.module()})), new JMAPRoutes(this.service, (TaskManager)this.taskManager)}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath(BASE_PATH).build();
    }

    @AfterEach
    void afterEach() {
        this.webAdminServer.destroy();
        this.taskManager.stop();
    }

    @Test
    void actionRequestParameterShouldBeCompulsory() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().post()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"'action' query parameter is compulsory. Supported values are [SolveInconsistencies]"), new Object[0]);
    }

    @Test
    void postShouldFailUponEmptyAction() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{""}).post()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"'action' query parameter cannot be empty or blank. Supported values are [SolveInconsistencies]"), new Object[0]);
    }

    @Test
    void postShouldFailUponInvalidAction() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"invalid"}).post()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"Invalid value supplied for query parameter 'action': invalid. Supported values are [SolveInconsistencies]"), new Object[0]);
    }

    @Test
    void postShouldFailWhenMessagesPerSecondIsNotAnInt() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"SolveInconsistencies"}).queryParam("messagesPerSecond", new Object[]{"abc"}).post()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"Illegal value supplied for query parameter 'messagesPerSecond', expecting a strictly positive optional integer"), new Object[0]);
    }

    @Test
    void postShouldFailWhenMessagesPerSecondIsNegative() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"SolveInconsistencies"}).queryParam("messagesPerSecond", new Object[]{"-1"}).post()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"'messagesPerSecond' must be strictly positive"), new Object[0]);
    }

    @Test
    void postShouldFailWhenMessagesPerSecondIsZero() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"SolveInconsistencies"}).queryParam("messagesPerSecond", new Object[]{"0"}).post()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"'messagesPerSecond' must be strictly positive"), new Object[0]);
    }

    @Test
    void postShouldCreateANewTask() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"SolveInconsistencies"}).post()).then()).statusCode(201)).body("taskId", Matchers.notNullValue(), new Object[0]);
    }

    @Test
    void postShouldCreateANewTaskWhenConcurrencyParametersSpecified() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("messagesPerSecond", new Object[]{"1"}).queryParam("action", new Object[]{"SolveInconsistencies"}).post()).then()).statusCode(201)).body("taskId", Matchers.notNullValue(), new Object[0]);
    }

    @Test
    void runningOptionsShouldBePartOfTaskDetails() {
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{"SolveInconsistencies"}).queryParam("messagesPerSecond", new Object[]{"20"}).post()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"solve-message-inconsistencies"), new Object[0])).body("additionalInformation.runningOptions.messagesPerSecond", Matchers.is((Object)20), new Object[0]);
    }

    private final class JMAPRoutes
    implements Routes {
        private final SolveMessageInconsistenciesService service;
        private final TaskManager taskManager;

        private JMAPRoutes(SolveMessageInconsistenciesService service, TaskManager taskManager) {
            this.service = service;
            this.taskManager = taskManager;
        }

        public String getBasePath() {
            return SolveMessageInconsistenciesRequestToTaskTest.BASE_PATH;
        }

        public void define(Service service) {
            service.post(SolveMessageInconsistenciesRequestToTaskTest.BASE_PATH, TaskFromRequestRegistry.builder().registrations(new TaskFromRequestRegistry.TaskRegistration[]{new SolveMessageInconsistenciesRequestToTask(this.service)}).buildAsRoute(this.taskManager), (ResponseTransformer)new JsonTransformer(new JsonTransformerModule[0]));
        }
    }
}

