/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.james.json.DTOConverter;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.cassandra.mail.task.SolveMailboxInconsistenciesService;
import org.apache.james.mailbox.cassandra.mail.task.SolveMessageInconsistenciesTaskAdditionalInformationDTO;
import org.apache.james.task.Hostname;
import org.apache.james.task.MemoryTaskManager;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.SolveMailboxInconsistenciesRequestToTask;
import org.apache.james.webadmin.routes.TasksRoutes;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import reactor.core.publisher.Mono;
import spark.ResponseTransformer;
import spark.Service;

public class SolveMailboxInconsistenciesRequestToTaskTest {
    static final String BASE_PATH = "/mailboxes";
    private WebAdminServer webAdminServer;
    private SolveMailboxInconsistenciesService service;
    private MemoryTaskManager taskManager;

    @BeforeEach
    void setUp() {
        JsonTransformer jsonTransformer = new JsonTransformer(new JsonTransformerModule[0]);
        this.taskManager = new MemoryTaskManager(new Hostname("foo"));
        this.service = (SolveMailboxInconsistenciesService)Mockito.mock(SolveMailboxInconsistenciesService.class);
        Mockito.when((Object)this.service.fixMailboxInconsistencies((SolveMailboxInconsistenciesService.Context)ArgumentMatchers.any())).thenReturn((Object)Mono.just((Object)Task.Result.COMPLETED));
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new TasksRoutes((TaskManager)this.taskManager, jsonTransformer, DTOConverter.of((DTOModule[])new DTOModule[]{SolveMessageInconsistenciesTaskAdditionalInformationDTO.module()})), new JMAPRoutes(this.service, (TaskManager)this.taskManager)}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath(BASE_PATH).build();
    }

    @AfterEach
    void afterEach() {
        this.webAdminServer.destroy();
        this.taskManager.stop();
    }

    @Test
    void actionRequestParameterShouldBeCompulsory() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().post()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"'action' query parameter is compulsory. Supported values are [SolveInconsistencies]"), new Object[0]);
    }

    @Test
    void postShouldFailUponEmptyTask() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{""}).post()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"'action' query parameter cannot be empty or blank. Supported values are [SolveInconsistencies]"), new Object[0]);
    }

    @Test
    void postShouldFailUponInvalidAction() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"invalid"}).post()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"Invalid value supplied for query parameter 'action': invalid. Supported values are [SolveInconsistencies]"), new Object[0]);
    }

    @Test
    void postShouldFailWhenIKnowWhatImDoingHeaderIsMissing() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"SolveInconsistencies"}).post()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"Due to concurrency risks, a `I-KNOW-WHAT-I-M-DOING` header should be positioned to `ALL-SERVICES-ARE-OFFLINE` in order to prevent accidental calls. Check the documentation for details."), new Object[0]);
    }

    @Test
    void postShouldFailWhenIKnowWhatImDoingHeaderIsInvalid() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"SolveInconsistencies"}).header("I-KNOW-WHAT-I-M-DOING", (Object)"invalid", new Object[0]).post()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"Due to concurrency risks, a `I-KNOW-WHAT-I-M-DOING` header should be positioned to `ALL-SERVICES-ARE-OFFLINE` in order to prevent accidental calls. Check the documentation for details."), new Object[0]);
    }

    @Test
    void postShouldFailWhenIKnowWhatImDoingHeaderIsEmpty() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"SolveInconsistencies"}).header("I-KNOW-WHAT-I-M-DOING", (Object)"", new Object[0]).post()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"Due to concurrency risks, a `I-KNOW-WHAT-I-M-DOING` header should be positioned to `ALL-SERVICES-ARE-OFFLINE` in order to prevent accidental calls. Check the documentation for details."), new Object[0]);
    }

    @Test
    void postShouldCreateANewTask() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"SolveInconsistencies"}).header("I-KNOW-WHAT-I-M-DOING", (Object)"ALL-SERVICES-ARE-OFFLINE", new Object[0]).post()).then()).statusCode(201)).body("taskId", Matchers.notNullValue(), new Object[0]);
    }

    private final class JMAPRoutes
    implements Routes {
        private final SolveMailboxInconsistenciesService service;
        private final TaskManager taskManager;

        private JMAPRoutes(SolveMailboxInconsistenciesService service, TaskManager taskManager) {
            this.service = service;
            this.taskManager = taskManager;
        }

        public String getBasePath() {
            return SolveMailboxInconsistenciesRequestToTaskTest.BASE_PATH;
        }

        public void define(Service service) {
            service.post(SolveMailboxInconsistenciesRequestToTaskTest.BASE_PATH, TaskFromRequestRegistry.builder().registrations(new TaskFromRequestRegistry.TaskRegistration[]{new SolveMailboxInconsistenciesRequestToTask(this.service)}).buildAsRoute(this.taskManager), (ResponseTransformer)new JsonTransformer(new JsonTransformerModule[0]));
        }
    }
}

