/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import java.util.Optional;
import org.apache.james.mailbox.cassandra.mail.task.RecomputeMailboxCountersService;
import org.apache.james.webadmin.routes.RecomputeMailboxCountersRequestToTask;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RecomputeMailboxCountersRequestToTaskTest {
    RecomputeMailboxCountersRequestToTaskTest() {
    }

    @Test
    void parseOptionsShouldReturnRecheckWhenEmpty() {
        Assertions.assertThat((Object)RecomputeMailboxCountersRequestToTask.parseOptions(Optional.empty())).isEqualTo((Object)RecomputeMailboxCountersService.Options.recheckMessageProjection());
    }

    @Test
    void parseOptionsShouldReturnRecheckWhenFalse() {
        Assertions.assertThat((Object)RecomputeMailboxCountersRequestToTask.parseOptions(Optional.of("false"))).isEqualTo((Object)RecomputeMailboxCountersService.Options.recheckMessageProjection());
    }

    @Test
    void parseOptionsShouldNotBeSensitiveToCase() {
        Assertions.assertThat((Object)RecomputeMailboxCountersRequestToTask.parseOptions(Optional.of("False"))).isEqualTo((Object)RecomputeMailboxCountersService.Options.recheckMessageProjection());
    }

    @Test
    void parseOptionsShouldReturnTrueWhenTrust() {
        Assertions.assertThat((Object)RecomputeMailboxCountersRequestToTask.parseOptions(Optional.of("true"))).isEqualTo((Object)RecomputeMailboxCountersService.Options.trustMessageProjection());
    }

    @Test
    void parseOptionsShouldFailWhenEmpty() {
        Assertions.assertThatThrownBy(() -> RecomputeMailboxCountersRequestToTask.parseOptions(Optional.of(""))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void parseOptionsShouldFailWhenNotAValidBoolean() {
        Assertions.assertThatThrownBy(() -> RecomputeMailboxCountersRequestToTask.parseOptions(Optional.of("zz"))).isInstanceOf(IllegalArgumentException.class);
    }
}

