/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.datastax.driver.core.Session;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.backends.cassandra.utils.CassandraUtils;
import org.apache.james.core.Domain;
import org.apache.james.json.DTOConverter;
import org.apache.james.json.DTOModule;
import org.apache.james.rrt.cassandra.CassandraMappingsSourcesDAO;
import org.apache.james.rrt.cassandra.CassandraRRTModule;
import org.apache.james.rrt.cassandra.CassandraRecipientRewriteTableDAO;
import org.apache.james.rrt.cassandra.migration.MappingsSourcesMigration;
import org.apache.james.rrt.cassandra.migration.MappingsSourcesMigrationTaskAdditionalInformationDTO;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.task.Hostname;
import org.apache.james.task.MemoryTaskManager;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskType;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.CassandraMappingsRoutes;
import org.apache.james.webadmin.routes.TasksRoutes;
import org.apache.james.webadmin.service.CassandraMappingsService;
import org.apache.james.webadmin.service.CassandraMappingsSolveInconsistenciesTask;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class CassandraMappingsRoutesTest {
    private static final String MAPPINGS_ACTION = "SolveInconsistencies";
    private static final MappingSource SOURCE_1 = MappingSource.fromUser((String)"bob", (Domain)Domain.LOCALHOST);
    private static final MappingSource SOURCE_2 = MappingSource.fromUser((String)"alice", (Domain)Domain.LOCALHOST);
    private static final Mapping MAPPING = Mapping.alias((String)"bob-alias@domain");
    private WebAdminServer webAdminServer;
    private MappingsSourcesMigration mappingsSourcesMigration;
    private CassandraRecipientRewriteTableDAO cassandraRecipientRewriteTableDAO;
    private CassandraMappingsSourcesDAO cassandraMappingsSourcesDAO;
    private MemoryTaskManager taskManager;
    @RegisterExtension
    static CassandraClusterExtension cassandraCluster = new CassandraClusterExtension(CassandraRRTModule.MODULE);

    CassandraMappingsRoutesTest() {
    }

    @BeforeEach
    void setUp(CassandraCluster cassandra) {
        this.cassandraRecipientRewriteTableDAO = new CassandraRecipientRewriteTableDAO((Session)cassandra.getConf(), CassandraUtils.WITH_DEFAULT_CONFIGURATION);
        this.cassandraMappingsSourcesDAO = new CassandraMappingsSourcesDAO((Session)cassandra.getConf());
        this.mappingsSourcesMigration = new MappingsSourcesMigration(this.cassandraRecipientRewriteTableDAO, this.cassandraMappingsSourcesDAO);
        CassandraMappingsService cassandraMappingsService = new CassandraMappingsService(this.mappingsSourcesMigration, this.cassandraMappingsSourcesDAO);
        JsonTransformer jsonTransformer = new JsonTransformer(new JsonTransformerModule[0]);
        this.taskManager = new MemoryTaskManager(new Hostname("foo"));
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new CassandraMappingsRoutes(cassandraMappingsService, (TaskManager)this.taskManager, jsonTransformer), new TasksRoutes((TaskManager)this.taskManager, jsonTransformer, DTOConverter.of((DTOModule[])new DTOModule[]{MappingsSourcesMigrationTaskAdditionalInformationDTO.module((TaskType)CassandraMappingsSolveInconsistenciesTask.TYPE)}))}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath("cassandra/mappings").build();
    }

    @AfterEach
    void tearDown() {
        this.webAdminServer.destroy();
        this.taskManager.stop();
    }

    @Test
    void postMappingsActionWithSolvedInconsistenciesQueryParamShouldCreateATask() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{MAPPINGS_ACTION}).when().post()).then()).statusCode(201)).header("Location", Matchers.is((Matcher)Matchers.notNullValue()))).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void postMappingsActionWithSolvedInconsistenciesQueryParamShouldHaveSuccessfulCompletedTask() {
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{MAPPINGS_ACTION}).post()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("additionalInformation.successfulMappingsCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.errorMappingsCount", Matchers.is((Object)0), new Object[0])).body("type", Matchers.is((Object)CassandraMappingsSolveInconsistenciesTask.TYPE.asString()), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void postMappingsActionShouldRejectInvalidActions() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"invalid-action"}).when().post()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"Invalid value supplied for query parameter 'action': invalid-action. Supported values are [SolveInconsistencies]"), new Object[0]);
    }

    @Test
    void postMappingsActionShouldRequireAction() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().post()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"'action' query parameter is compulsory. Supported values are [SolveInconsistencies]"), new Object[0]);
    }

    @Test
    void postMappingsActionShouldResolveRRTInconsistencies() {
        this.cassandraRecipientRewriteTableDAO.addMapping(SOURCE_1, MAPPING).block();
        this.cassandraRecipientRewriteTableDAO.addMapping(SOURCE_2, MAPPING).block();
        this.cassandraMappingsSourcesDAO.addMapping(MAPPING, SOURCE_1).block();
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{MAPPINGS_ACTION}).post()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("additionalInformation.successfulMappingsCount", Matchers.is((Object)2), new Object[0])).body("additionalInformation.errorMappingsCount", Matchers.is((Object)0), new Object[0]);
        Assertions.assertThat((List)((List)this.cassandraMappingsSourcesDAO.retrieveSources(MAPPING).collectList().block())).containsOnly((Object[])new MappingSource[]{SOURCE_1, SOURCE_2});
    }

    @Test
    void postMappingsActionShouldResolveMappingsSourcesInconsistencies() {
        this.cassandraRecipientRewriteTableDAO.addMapping(SOURCE_1, MAPPING).block();
        this.cassandraMappingsSourcesDAO.addMapping(MAPPING, SOURCE_1).block();
        this.cassandraMappingsSourcesDAO.addMapping(MAPPING, SOURCE_2).block();
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{MAPPINGS_ACTION}).post()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("additionalInformation.successfulMappingsCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.errorMappingsCount", Matchers.is((Object)0), new Object[0]);
        Assertions.assertThat((List)((List)this.cassandraMappingsSourcesDAO.retrieveSources(MAPPING).collectList().block())).containsOnly((Object[])new MappingSource[]{SOURCE_1});
    }
}

