/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.streams;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class JamesCollectors {
    public static <D> Collector<D, ?, Map<Integer, List<D>>> chunker(int chunkSize) {
        Preconditions.checkArgument((chunkSize > 0 ? 1 : 0) != 0, (Object)"ChunkSize should be strictly positive");
        AtomicInteger counter = new AtomicInteger(-1);
        return Collectors.groupingBy(x -> counter.incrementAndGet() / chunkSize);
    }
}

