/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class CompletableFutureUtil {
    @SafeVarargs
    public static <T> CompletableFuture<Stream<T>> allOfArray(CompletableFuture<T> ... futures) {
        return CompletableFutureUtil.allOf(Stream.of(futures));
    }

    public static <T> CompletableFuture<Stream<T>> allOf(Stream<CompletableFuture<T>> futureStream) {
        return ((Stream)futureStream.map(future -> future.thenApply(Stream::of)).parallel()).reduce((future1, future2) -> future1.thenCompose(stream1 -> future2.thenCompose(stream2 -> {
            Stream concatStream = Stream.concat(stream1, stream2);
            return CompletableFuture.completedFuture(concatStream);
        }))).orElse(CompletableFuture.completedFuture(Stream.of(new Object[0])));
    }

    public static <T> CompletableFuture<Stream<T>> performOnAll(CompletableFuture<Stream<T>> futurStream, Function<T, CompletableFuture<Void>> action) {
        return CompletableFutureUtil.thenComposeOnAll(futurStream, value -> CompletableFutureUtil.keepValue(() -> (CompletableFuture)action.apply(value), value));
    }

    public static <T, U> CompletableFuture<Stream<U>> thenComposeOnAll(CompletableFuture<Stream<T>> futurStream, Function<T, CompletableFuture<U>> action) {
        return futurStream.thenCompose(stream -> CompletableFutureUtil.allOf(stream.map(action)));
    }

    public static <T, U> CompletableFuture<Stream<U>> map(CompletableFuture<Stream<T>> futurStream, Function<T, U> action) {
        return futurStream.thenApply(stream -> stream.map(action));
    }

    public static <T, U> CompletableFuture<Optional<T>> reduce(BinaryOperator<T> binaryOperator, CompletableFuture<Stream<T>> futureStream) {
        return futureStream.thenApply(stream -> stream.reduce(binaryOperator));
    }

    public static <T> CompletableFuture<T> keepValue(Supplier<CompletableFuture<Void>> supplier, T value) {
        return supplier.get().thenApply(any -> value);
    }

    public static <T> Function<Boolean, CompletableFuture<Boolean>> composeIfTrue(Supplier<CompletableFuture<T>> composeOperation) {
        return b -> {
            if (b.booleanValue()) {
                return ((CompletableFuture)composeOperation.get()).thenApply(any -> b);
            }
            return CompletableFuture.completedFuture(b);
        };
    }
}

