/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.streams;

import com.google.common.base.Strings;
import java.util.List;
import java.util.concurrent.Future;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.shaded.com.github.dockerjava.api.command.InspectContainerResponse;

public class SwarmGenericContainer
implements TestRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwarmGenericContainer.class);
    private static final String DOCKER_CONTAINER = "DOCKER_CONTAINER";
    private static final String NO_DOCKER_ENVIRONMENT = "Could not find a valid Docker environment.";
    private static final String SKIPPING_TEST_CAUTION = "Skipping all docker tests as no Docker environment was found";
    private GenericContainer container;

    public SwarmGenericContainer(String dockerImageName) {
        try {
            this.container = new GenericContainer(dockerImageName);
        }
        catch (IllegalStateException e) {
            this.logAndCheckSkipTest(e);
        }
    }

    public SwarmGenericContainer(ImageFromDockerfile imageFromDockerfile) {
        try {
            this.container = new GenericContainer((Future)imageFromDockerfile);
        }
        catch (IllegalStateException e) {
            this.logAndCheckSkipTest(e);
        }
    }

    private void logAndCheckSkipTest(IllegalStateException e) {
        LOGGER.error("Cannot initial a docker container because: " + e);
        if (e.getMessage().startsWith(NO_DOCKER_ENVIRONMENT)) {
            Assume.assumeTrue((String)SKIPPING_TEST_CAUTION, (boolean)false);
        }
    }

    public SwarmGenericContainer withAffinityToContainer() {
        String containerEnv = System.getenv(DOCKER_CONTAINER);
        if (Strings.isNullOrEmpty((String)containerEnv)) {
            LOGGER.warn("'DOCKER_CONTAINER' environment variable not found, dockering without affinity");
            return this;
        }
        List envVariables = this.container.getEnv();
        envVariables.add("affinity:container==" + this.container);
        this.container.setEnv(envVariables);
        return this;
    }

    public SwarmGenericContainer withEnv(String key, String value) {
        this.container.addEnv(key, value);
        return this;
    }

    public void start() {
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }

    public String getContainerIpAddress() {
        return this.container.getContainerIpAddress();
    }

    public Integer getMappedPort(int originalPort) {
        return this.container.getMappedPort(originalPort);
    }

    public String getIp() {
        return this.getContainerInfo().getNetworkSettings().getIpAddress();
    }

    public InspectContainerResponse getContainerInfo() {
        return this.container.getContainerInfo();
    }

    public Statement apply(Statement statement, Description description) {
        return this.container.apply(statement, description);
    }
}

