/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.streams;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.james.util.streams.JamesCollectors;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JamesCollectorsTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void chunkerShouldAcceptEmptyStrem() {
        Stream<Integer> emptyStream = Stream.of(new Integer[0]);
        Assertions.assertThat((Map)((Map)emptyStream.collect(JamesCollectors.chunker((int)10)))).isEmpty();
    }

    @Test
    public void chunkerShouldThrowOnZeroChunkSize() {
        this.expectedException.expect(IllegalArgumentException.class);
        JamesCollectors.chunker((int)0);
    }

    @Test
    public void chunkerShouldThrowOnNegativeChunkSize() {
        this.expectedException.expect(IllegalArgumentException.class);
        JamesCollectors.chunker((int)-1);
    }

    @Test
    public void chunkerShouldChunkMonoValueStreams() {
        Stream<Integer> monoValueStream = Stream.of(Integer.valueOf(1));
        List values = (List)((Map)monoValueStream.collect(JamesCollectors.chunker((int)10))).values().stream().map(ImmutableList::copyOf).collect(Guavate.toImmutableList());
        Assertions.assertThat((List)values).isEqualTo((Object)ImmutableList.of((Object)ImmutableList.of((Object)1)));
    }

    @Test
    public void chunkerShouldChunkStreamsSmallerThanChunkSize() {
        Stream<Integer> stream = Stream.of(1, 2);
        List values = (List)((Map)stream.collect(JamesCollectors.chunker((int)3))).values().stream().map(ImmutableList::copyOf).collect(Guavate.toImmutableList());
        Assertions.assertThat((List)values).isEqualTo((Object)ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2)));
    }

    @Test
    public void chunkerShouldChunkStreamsAsBigAsChunkSize() {
        Stream<Integer> stream = Stream.of(1, 2, 3);
        List values = (List)((Map)stream.collect(JamesCollectors.chunker((int)3))).values().stream().map(ImmutableList::copyOf).collect(Guavate.toImmutableList());
        Assertions.assertThat((List)values).isEqualTo((Object)ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2, (Object)3)));
    }

    @Test
    public void chunkerShouldChunkStreamsBiggerThanChunkSize() {
        Stream<Integer> stream = Stream.of(1, 2, 3, 4);
        List values = (List)((Map)stream.collect(JamesCollectors.chunker((int)3))).values().stream().map(ImmutableList::copyOf).collect(Guavate.toImmutableList());
        Assertions.assertThat((List)values).isEqualTo((Object)ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2, (Object)3), (Object)ImmutableList.of((Object)4)));
    }

    @Test
    public void chunkerShouldChunkInSeveralBuckets() {
        Stream<Integer> stream = Stream.of(1, 2, 3, 4, 5, 6, 7);
        List values = (List)((Map)stream.collect(JamesCollectors.chunker((int)3))).values().stream().map(ImmutableList::copyOf).collect(Guavate.toImmutableList());
        Assertions.assertThat((List)values).isEqualTo((Object)ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2, (Object)3), (Object)ImmutableList.of((Object)4, (Object)5, (Object)6), (Object)ImmutableList.of((Object)7)));
    }
}

