/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.streams;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.james.util.streams.Iterators;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class IteratorsTest {
    @Test
    public void toStreamShouldReturnEmptyStreamWhenEmptyIterator() {
        UnmodifiableIterator emptyIterator = ImmutableList.of().iterator();
        Stream actual = Iterators.toStream((Iterator)emptyIterator);
        Assertions.assertThat((long)actual.count()).isEqualTo(0L);
    }

    @Test
    public void toStreamShouldReturnSameContent() {
        UnmodifiableIterator iterator = ImmutableList.of((Object)"a", (Object)"b", (Object)"c").iterator();
        Stream actual = Iterators.toStream((Iterator)iterator);
        Assertions.assertThat(actual.collect(Collectors.toList())).containsExactly((Object[])new String[]{"a", "b", "c"});
    }
}

