/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.streams;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.junit.Test;

public class ImmutableCollectorsTest {
    @Test
    public void immutableListCollectorShouldReturnEmptyImmutableListWhenEmptyStream() {
        String[] data = new String[]{};
        List actual = (List)Arrays.stream(data).collect(Guavate.toImmutableList());
        Assertions.assertThat((List)actual).isInstanceOf(ImmutableList.class);
        Assertions.assertThat((List)actual).isEmpty();
    }

    @Test
    public void immutableListCollectorShouldReturnImmutableListWhenOneElementStream() {
        String[] data = new String[]{"a"};
        List actual = (List)Arrays.stream(data).collect(Guavate.toImmutableList());
        Assertions.assertThat((List)actual).isInstanceOf(ImmutableList.class);
        Assertions.assertThat((List)actual).containsExactly((Object[])new String[]{"a"});
    }

    @Test
    public void immutableListCollectorShouldReturnImmutableListWhen3ElementsStream() {
        String[] data = new String[]{"a", "b", "c"};
        List actual = (List)Arrays.stream(data).collect(Guavate.toImmutableList());
        Assertions.assertThat((List)actual).isInstanceOf(ImmutableList.class);
        Assertions.assertThat((List)actual).containsExactly((Object[])new String[]{"a", "b", "c"});
    }

    @Test
    public void immutableSetCollectorShouldReturnEmptyImmutableSetWhenEmptyStream() {
        String[] data = new String[]{};
        Set actual = (Set)Arrays.stream(data).collect(Guavate.toImmutableSet());
        Assertions.assertThat((Iterable)actual).isInstanceOf(ImmutableSet.class);
        Assertions.assertThat((Iterable)actual).isEmpty();
    }

    @Test
    public void immutableSetCollectorShouldReturnImmutableSetWhenOneElementStream() {
        String[] data = new String[]{"a"};
        Set actual = (Set)Arrays.stream(data).collect(Guavate.toImmutableSet());
        Assertions.assertThat((Iterable)actual).isInstanceOf(ImmutableSet.class);
        Assertions.assertThat((Iterable)actual).containsExactly((Object[])new String[]{"a"});
    }

    @Test
    public void immutableSetCollectorShouldReturnImmutableSetWhen3ElementsStream() {
        String[] data = new String[]{"a", "b", "c"};
        Set actual = (Set)Arrays.stream(data).collect(Guavate.toImmutableSet());
        Assertions.assertThat((Iterable)actual).isInstanceOf(ImmutableSet.class);
        Assertions.assertThat((Iterable)actual).containsExactly((Object[])new String[]{"a", "b", "c"});
    }

    @Test
    public void immutableMapCollectorShouldReturnEmptyImmutableMapWhenEmptyStream() {
        String[] data = new String[]{};
        Map actual = (Map)Arrays.stream(data).collect(Guavate.toImmutableMap(x -> x.toUpperCase(Locale.US), String::length));
        Assertions.assertThat((Map)actual).isInstanceOf(ImmutableMap.class);
        Assertions.assertThat((Map)actual).isEmpty();
    }

    @Test
    public void immutableMapCollectorShouldReturnAppliedImmutableMapWhenOneElementStream() {
        String[] data = new String[]{"a"};
        Map actual = (Map)Arrays.stream(data).collect(Guavate.toImmutableMap(x -> x.toUpperCase(Locale.US), String::length));
        Assertions.assertThat((Map)actual).isInstanceOf(ImmutableMap.class);
        Assertions.assertThat((Map)actual).containsExactly(new MapEntry[]{MapEntry.entry((Object)"A", (Object)1)});
    }

    @Test
    public void immutableMapCollectorShouldReturnAppliedImmutableMapWhen3ElementsStream() {
        String[] data = new String[]{"a", "bb", "ccc"};
        Map actual = (Map)Arrays.stream(data).collect(Guavate.toImmutableMap(x -> x.toUpperCase(Locale.US), String::length));
        Assertions.assertThat((Map)actual).isInstanceOf(ImmutableMap.class);
        Assertions.assertThat((Map)actual).containsExactly(new MapEntry[]{MapEntry.entry((Object)"A", (Object)1), MapEntry.entry((Object)"BB", (Object)2), MapEntry.entry((Object)"CCC", (Object)3)});
    }
}

