/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.james.util.ValuePatch;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ValuePatchTest {
    public static final int REPLACEMENT_VALUE = 24;
    public static final Optional<Integer> REPLACEMENT = Optional.of(24);
    public static final int VALUE = 12;
    public static final Optional<Integer> OPTIONAL_OF_VALUE = Optional.of(12);

    @Test
    public void keepShouldProduceKeptValues() {
        Assertions.assertThat((boolean)ValuePatch.keep().isKept()).isTrue();
    }

    @Test
    public void keepShouldThrowOnGet() {
        Assertions.assertThatThrownBy(() -> {
            Integer cfr_ignored_0 = (Integer)ValuePatch.keep().get();
        }).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    public void keepShouldNotBeModified() {
        Assertions.assertThat((boolean)ValuePatch.keep().isModified()).isFalse();
    }

    @Test
    public void keepShouldNotBeRemoved() {
        Assertions.assertThat((boolean)ValuePatch.keep().isRemoved()).isFalse();
    }

    @Test
    public void removeShouldNotBeKept() {
        Assertions.assertThat((boolean)ValuePatch.remove().isKept()).isFalse();
    }

    @Test
    public void removeShouldBeRemoved() {
        Assertions.assertThat((boolean)ValuePatch.remove().isRemoved()).isTrue();
    }

    @Test
    public void removedShouldNotBeModified() {
        Assertions.assertThat((boolean)ValuePatch.remove().isModified()).isFalse();
    }

    @Test
    public void removeShouldThrowOnGet() {
        Assertions.assertThatThrownBy(() -> {
            Integer cfr_ignored_0 = (Integer)ValuePatch.remove().get();
        }).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    public void ofNullableShouldBeEquivalentToRemoveWhenNullParameter() {
        Assertions.assertThat((Object)ValuePatch.ofNullable(null)).isEqualTo((Object)ValuePatch.remove());
    }

    @Test
    public void ofNullableShouldBeEquivalentToModifyWhenNonNullParameter() {
        Assertions.assertThat((Object)ValuePatch.ofNullable((Object)12)).isEqualTo((Object)ValuePatch.modifyTo((Object)12));
    }

    @Test
    public void modifyToShouldNotBeKept() {
        Assertions.assertThat((boolean)ValuePatch.modifyTo((Object)12).isKept()).isFalse();
    }

    @Test
    public void modifyToShouldNotBeRemoved() {
        Assertions.assertThat((boolean)ValuePatch.modifyTo((Object)12).isRemoved()).isFalse();
    }

    @Test
    public void modifyToShouldBeModified() {
        Assertions.assertThat((boolean)ValuePatch.modifyTo((Object)12).isModified()).isTrue();
    }

    @Test
    public void modifyToShouldThrowOnNullValue() {
        Assertions.assertThatThrownBy(() -> ValuePatch.modifyTo(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void modifyToShouldBeRetrievedByGet() {
        Assertions.assertThat((Integer)((Integer)ValuePatch.modifyTo((Object)12).get())).isEqualTo(12);
    }

    @Test
    public void ofOptionalShouldThrowOnNullValue() {
        Assertions.assertThatThrownBy(() -> ValuePatch.ofOptional(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void ofOptionalShouldBeEquivalentToModifyToWhenPresent() {
        Assertions.assertThat((Object)ValuePatch.ofOptional(OPTIONAL_OF_VALUE)).isEqualTo((Object)ValuePatch.modifyTo((Object)12));
    }

    @Test
    public void ofOptionalShouldBeEquivalentToRemoveWhenEmpty() {
        Assertions.assertThat((Object)ValuePatch.ofOptional(Optional.empty())).isEqualTo((Object)ValuePatch.remove());
    }

    @Test
    public void notKeptOrElseShouldReturnElseWhenKept() {
        Assertions.assertThat((Optional)ValuePatch.keep().notKeptOrElse(REPLACEMENT)).isEqualTo(REPLACEMENT);
    }

    @Test
    public void notKeptOrElseShouldReturnEmptyWhenRemoved() {
        Assertions.assertThat((Optional)ValuePatch.remove().notKeptOrElse(REPLACEMENT)).isEqualTo(Optional.empty());
    }

    @Test
    public void notKeptOrElseShouldReturnOptionalWhenModified() {
        Assertions.assertThat((Optional)ValuePatch.modifyTo((Object)12).notKeptOrElse(REPLACEMENT)).isEqualTo(OPTIONAL_OF_VALUE);
    }

    @Test
    public void toOptionalShouldReturnElseWhenKept() {
        Assertions.assertThat((Optional)ValuePatch.keep().toOptional()).isEqualTo(Optional.empty());
    }

    @Test
    public void toOptionalShouldReturnEmptyWhenRemoved() {
        Assertions.assertThat((Optional)ValuePatch.remove().toOptional()).isEqualTo(Optional.empty());
    }

    @Test
    public void toOptionalShouldReturnOptionalWhenModified() {
        Assertions.assertThat((Optional)ValuePatch.modifyTo((Object)12).toOptional()).isEqualTo(OPTIONAL_OF_VALUE);
    }

    @Test
    public void getOrElseShouldReturnReplacementWhenKept() {
        Assertions.assertThat((Integer)((Integer)ValuePatch.keep().getOrElse((Object)24))).isEqualTo(24);
    }

    @Test
    public void getOrElseShouldReturnReplacementWhenRemoved() {
        Assertions.assertThat((Integer)((Integer)ValuePatch.remove().getOrElse((Object)24))).isEqualTo(24);
    }

    @Test
    public void getOrElseShouldReturnValueWhenPresent() {
        Assertions.assertThat((Integer)((Integer)ValuePatch.modifyTo((Object)12).getOrElse((Object)24))).isEqualTo(12);
    }

    @Test
    public void getOrElseShouldReturnNullWhenKeptAndNullSpecified() {
        Assertions.assertThat((Integer)((Integer)ValuePatch.keep().getOrElse(null))).isNull();
    }

    @Test
    public void getOrElseShouldReturnNullWhenRemovedAndNullSpecified() {
        Assertions.assertThat((Integer)((Integer)ValuePatch.remove().getOrElse(null))).isNull();
    }

    @Test
    public void getOrElseShouldReturnValueWhenPresentAndNullSpecified() {
        Assertions.assertThat((Integer)((Integer)ValuePatch.modifyTo((Object)12).getOrElse(null))).isEqualTo(12);
    }

    @Test
    public void mapNotKeptToValueShouldPreserveKept() {
        Assertions.assertThat((Optional)ValuePatch.keep().mapNotKeptToOptional(optional -> optional.map(i -> i + 1).orElse(24))).isEmpty();
    }

    @Test
    public void mapNotKeptToValueShouldTransformOf() {
        Assertions.assertThat((Optional)ValuePatch.modifyTo((Object)12).mapNotKeptToOptional(optional -> optional.map(i -> i + 1).orElse(24))).contains((Object)13);
    }

    @Test
    public void mapNotKeptToValueShouldTransformRemoved() {
        Assertions.assertThat((Optional)ValuePatch.remove().mapNotKeptToOptional(optional -> optional.map(i -> i + 1).orElse(24))).contains((Object)24);
    }

    @Test
    public void mapNotKeptToValueShouldThrowWhenNull() {
        Assertions.assertThatThrownBy(() -> ValuePatch.modifyTo((Object)12).mapNotKeptToOptional(any -> null).isPresent()).isInstanceOf(NullPointerException.class);
    }
}

