/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.github.steveash.guavate.Guavate;
import java.util.List;
import java.util.Optional;
import org.apache.james.util.OptionalConverter;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OptionalConverterTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void toStreamShouldConvertEmptyOptionalToEmptyStream() {
        Assertions.assertThat((List)((List)OptionalConverter.toStream(Optional.empty()).collect(Guavate.toImmutableList()))).isEmpty();
    }

    @Test
    public void toStreamShouldConvertFullOptionalToStream() {
        long value = 18L;
        Assertions.assertThat((List)((List)OptionalConverter.toStream(Optional.of(value)).collect(Guavate.toImmutableList()))).containsExactly((Object[])new Long[]{value});
    }

    @Test
    public void fromGuavaShouldThrowWhenGuavaIsNull() {
        this.expectedException.expect(NullPointerException.class);
        OptionalConverter.fromGuava(null);
    }

    @Test
    public void fromGuavaShouldReturnEmptyWhenGuavaIsEmpty() {
        Optional fromGuava = OptionalConverter.fromGuava((com.google.common.base.Optional)com.google.common.base.Optional.absent());
        Assertions.assertThat((Optional)fromGuava).isEmpty();
    }

    @Test
    public void fromGuavaShouldReturnNonEmptyWhenGuavaIsNonEmpty() {
        String value = "my string";
        Optional fromGuava = OptionalConverter.fromGuava((com.google.common.base.Optional)com.google.common.base.Optional.of((Object)value));
        Assertions.assertThat((Optional)fromGuava).contains((Object)value);
    }

    @Test
    public void toGuavaShouldThrowWhenGuavaIsNull() {
        this.expectedException.expect(NullPointerException.class);
        OptionalConverter.toGuava(null);
    }

    @Test
    public void toGuavaShouldReturnEmptyWhenGuavaIsEmpty() {
        com.google.common.base.Optional toGuava = OptionalConverter.toGuava(Optional.empty());
        Assertions.assertThat((boolean)toGuava.isPresent()).isFalse();
    }

    @Test
    public void toGuavaShouldReturnNonEmptyWhenGuavaIsNonEmpty() {
        String value = "my string";
        com.google.common.base.Optional toGuava = OptionalConverter.toGuava(Optional.of(value));
        Assertions.assertThat((String)((String)toGuava.get())).isEqualTo((Object)value);
    }
}

