/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.util.Host;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HostTest {
    private static final int DEFAULT_PORT = 154;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void parseConfStringShouldParseConfWithIpAndPort() {
        int expectedPort = 44;
        String expectedIp = "142.145.254.111";
        String ipAndPort = expectedIp + ":" + 44;
        Host actual = Host.parseConfString((String)ipAndPort);
        Assertions.assertThat((Object)actual).isEqualTo((Object)new Host(expectedIp, expectedPort));
    }

    @Test
    public void parseConfStringShouldParseConfWithHostanmeAndPort() {
        int expectedPort = 44;
        String host = "host";
        Host actual = Host.parseConfString((String)(host + ":" + expectedPort));
        Assertions.assertThat((Object)actual).isEqualTo((Object)new Host(host, expectedPort));
    }

    @Test
    public void parseConfStringShouldParseConfWithHostOnlyWhenDefaultPortIsProvided() {
        String ipAndPort = "142.145.254.111";
        String expectedIp = "142.145.254.111";
        Host actual = Host.parseConfString((String)ipAndPort, (int)154);
        Assertions.assertThat((Object)actual).isEqualTo((Object)new Host(expectedIp, 154));
    }

    @Test
    public void parseConfStringShouldFailWhenConfigIsAnEmptyString() {
        this.expectedException.expect(IllegalArgumentException.class);
        String ipAndPort = "";
        Host.parseConfString((String)ipAndPort);
    }

    @Test
    public void parseConfStringShouldFailWhenOnlyHostnameAndNoDefaultPort() {
        this.expectedException.expect(IllegalArgumentException.class);
        String hostname = "hostnameOnly";
        Host.parseConfString((String)hostname);
    }

    @Test
    public void parseConfStringShouldFailWhenNegativePort() {
        this.expectedException.expect(IllegalArgumentException.class);
        Host.parseConfString((String)"host:-1");
    }

    @Test
    public void parseConfStringShouldFailWhenZeroPort() {
        this.expectedException.expect(IllegalArgumentException.class);
        Host.parseConfString((String)"host:0");
    }

    @Test
    public void parseConfStringShouldFailWhenTooHighPort() {
        this.expectedException.expect(IllegalArgumentException.class);
        Host.parseConfString((String)"host:65536");
    }

    @Test
    public void parseConfStringShouldFailWhenConfigIsANullString() {
        this.expectedException.expect(NullPointerException.class);
        String ipAndPort = null;
        Host.parseConfString(ipAndPort);
    }

    @Test
    public void parseConfStringShouldFailWhenConfigIsInvalid() {
        this.expectedException.expect(IllegalArgumentException.class);
        String ipAndPort = "10.10.10.10:42:43";
        Host.parseConfString((String)ipAndPort);
    }

    @Test
    public void parseHostsShouldParseEmptyString() {
        Assertions.assertThat((List)Host.parseHosts((String)"")).isEmpty();
    }

    @Test
    public void parseHostsShouldParseMonoHost() {
        Assertions.assertThat((List)Host.parseHosts((String)"localhost:9200")).containsOnly((Object[])new Host[]{new Host("localhost", 9200)});
    }

    @Test
    public void parseHostsShouldParseMultiHosts() {
        Assertions.assertThat((List)Host.parseHosts((String)"localhost:9200,server:9155")).containsOnly((Object[])new Host[]{new Host("localhost", 9200), new Host("server", 9155)});
    }

    @Test
    public void parseHostsShouldNotFailOnMultiComma() {
        Assertions.assertThat((List)Host.parseHosts((String)"localhost:9200,,server:9155")).containsOnly((Object[])new Host[]{new Host("localhost", 9200), new Host("server", 9155)});
    }

    @Test
    public void parseHostsShouldFailOnInvalidHost() {
        this.expectedException.expect(NumberFormatException.class);
        Host.parseHosts((String)"localhost:invalid,,server:9155");
    }

    @Test
    public void parseHostsShouldSwallowDuplicates() {
        Assertions.assertThat((List)Host.parseHosts((String)"localhost:9200,localhost:9200")).containsOnly((Object[])new Host[]{new Host("localhost", 9200)});
    }

    @Test
    public void parseHostsShouldNotSwallowSameAddressDifferentPort() {
        Assertions.assertThat((List)Host.parseHosts((String)"localhost:9200,localhost:9155")).containsOnly((Object[])new Host[]{new Host("localhost", 9200), new Host("localhost", 9155)});
    }

    @Test
    public void parseHostsShouldNotSwallowSamePortDifferentAddress() {
        Assertions.assertThat((List)Host.parseHosts((String)"localhost:9200,abcd:9200")).containsOnly((Object[])new Host[]{new Host("localhost", 9200), new Host("abcd", 9200)});
    }

    @Test
    public void parseHostsShouldHandleDefaultPort() {
        int defaultPort = 155;
        Assertions.assertThat((List)Host.parseHosts((String)"localhost:9200,abcd", (int)defaultPort)).containsOnly((Object[])new Host[]{new Host("localhost", 9200), new Host("abcd", 155)});
    }

    @Test
    public void parseHostsShouldThrowOnAbsentPortWhenNoDefaultPort() {
        this.expectedException.expect(IllegalArgumentException.class);
        Host.parseHosts((String)"localhost:9200,abcd");
    }

    @Test
    public void hostShouldRespectBeanContract() {
        EqualsVerifier.forClass(Host.class).verify();
    }
}

