/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.github.steveash.guavate.Guavate;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.james.util.CompletableFutureUtil;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class CompletableFutureUtilTest {
    @Test
    public void allOfShouldUnboxEmptyStream() {
        Assertions.assertThat((List)((List)((Stream)CompletableFutureUtil.allOf(Stream.empty()).join()).collect(Guavate.toImmutableList()))).isEmpty();
    }

    @Test
    public void allOfShouldUnboxStream() {
        long value1 = 18L;
        long value2 = 19L;
        long value3 = 20L;
        Assertions.assertThat((List)((List)((Stream)CompletableFutureUtil.allOf(Stream.of(CompletableFuture.completedFuture(value1), CompletableFuture.completedFuture(value2), CompletableFuture.completedFuture(value3))).join()).collect(Guavate.toImmutableList()))).containsOnly((Object[])new Long[]{value1, value2, value3});
    }

    @Test
    public void allOfShouldPreserveOrder() {
        long value1 = 18L;
        long value2 = 19L;
        long value3 = 20L;
        long value4 = 21L;
        long value5 = 22L;
        long value6 = 23L;
        long value7 = 24L;
        long value8 = 25L;
        long value9 = 26L;
        long value10 = 27L;
        Assertions.assertThat((List)((List)((Stream)CompletableFutureUtil.allOf(Stream.of(CompletableFuture.completedFuture(value1), CompletableFuture.completedFuture(value2), CompletableFuture.completedFuture(value3), CompletableFuture.completedFuture(value4), CompletableFuture.completedFuture(value5), CompletableFuture.completedFuture(value6), CompletableFuture.completedFuture(value7), CompletableFuture.completedFuture(value8), CompletableFuture.completedFuture(value9), CompletableFuture.completedFuture(value10))).join()).collect(Guavate.toImmutableList()))).containsExactly((Object[])new Long[]{value1, value2, value3, value4, value5, value6, value7, value8, value9, value10});
    }

    @Test
    public void allOfArrayShouldPreserveOrder() {
        long value1 = 18L;
        long value2 = 19L;
        long value3 = 20L;
        long value4 = 21L;
        long value5 = 22L;
        long value6 = 23L;
        long value7 = 24L;
        long value8 = 25L;
        long value9 = 26L;
        long value10 = 27L;
        Assertions.assertThat((List)((List)((Stream)CompletableFutureUtil.allOfArray((CompletableFuture[])new CompletableFuture[]{CompletableFuture.completedFuture(value1), CompletableFuture.completedFuture(value2), CompletableFuture.completedFuture(value3), CompletableFuture.completedFuture(value4), CompletableFuture.completedFuture(value5), CompletableFuture.completedFuture(value6), CompletableFuture.completedFuture(value7), CompletableFuture.completedFuture(value8), CompletableFuture.completedFuture(value9), CompletableFuture.completedFuture(value10)}).join()).collect(Guavate.toImmutableList()))).containsExactly((Object[])new Long[]{value1, value2, value3, value4, value5, value6, value7, value8, value9, value10});
    }

    @Test
    public void allOfArrayShouldUnboxNoArgs() {
        Assertions.assertThat((List)((List)((Stream)CompletableFutureUtil.allOfArray((CompletableFuture[])new CompletableFuture[0]).join()).collect(Guavate.toImmutableList()))).isEmpty();
    }

    @Test
    public void allOfArrayShouldUnboxArray() {
        long value1 = 18L;
        long value2 = 19L;
        long value3 = 20L;
        Assertions.assertThat((List)((List)((Stream)CompletableFutureUtil.allOfArray((CompletableFuture[])new CompletableFuture[]{CompletableFuture.completedFuture(value1), CompletableFuture.completedFuture(value2), CompletableFuture.completedFuture(value3)}).join()).collect(Guavate.toImmutableList()))).containsOnly((Object[])new Long[]{value1, value2, value3});
    }

    @Test
    public void allOfShouldWorkOnVeryLargeStream() {
        CompletableFutureUtil.allOf(IntStream.range(0, 100000).boxed().map(CompletableFuture::completedFuture)).join();
    }

    @Test
    public void mapShouldMapOnStreamInsideACompletableFuturOfStream() {
        CompletableFuture<Stream<Integer>> futurOfInteger = CompletableFuture.completedFuture(Stream.of(1, 2, 3));
        Assertions.assertThat((List)((List)((Stream)CompletableFutureUtil.map(futurOfInteger, integer -> integer * 2).join()).collect(Guavate.toImmutableList()))).containsExactly((Object[])new Integer[]{2, 4, 6});
    }

    @Test
    public void mapShouldReturnEmptyStreamWhenGivenAnEmptyStream() {
        CompletableFuture<Stream<Integer>> futurOfInteger = CompletableFuture.completedFuture(Stream.of(new Integer[0]));
        Assertions.assertThat((List)((List)((Stream)CompletableFutureUtil.map(futurOfInteger, integer -> integer * 2).join()).collect(Guavate.toImmutableList()))).isEmpty();
    }

    @Test
    public void thenComposeOnAllShouldMapOnStreamInsideACompletableFuturOfStreamAndTransformTheResultingStreamOfCompletableFutureIntoACompletableOfStreamAndFlatIt() {
        CompletableFuture<Stream<Integer>> futurOfInteger = CompletableFuture.completedFuture(Stream.of(1, 2, 3));
        Assertions.assertThat((List)((List)((Stream)CompletableFutureUtil.thenComposeOnAll(futurOfInteger, integer -> CompletableFuture.completedFuture(integer * 2)).join()).collect(Guavate.toImmutableList()))).containsExactly((Object[])new Integer[]{2, 4, 6});
    }

    @Test
    public void thenComposeOnAllOnEmptyStreamShouldReturnAnEmptyStream() {
        CompletableFuture<Stream<Integer>> futurOfInteger = CompletableFuture.completedFuture(Stream.of(new Integer[0]));
        Assertions.assertThat((List)((List)((Stream)CompletableFutureUtil.thenComposeOnAll(futurOfInteger, integer -> CompletableFuture.completedFuture(integer * 2)).join()).collect(Guavate.toImmutableList()))).isEmpty();
    }

    @Test
    public void keepValueShouldCompleteWhenTheGivenCompletableFutureEnd() {
        AtomicInteger numOfFutureExecution = new AtomicInteger(0);
        Supplier<CompletableFuture> future = () -> CompletableFuture.runAsync(numOfFutureExecution::incrementAndGet);
        Assertions.assertThat((Integer)((Integer)CompletableFutureUtil.keepValue(future, (Object)42).join())).isEqualTo(42);
        Assertions.assertThat((int)numOfFutureExecution.get()).isEqualTo(1);
    }

    @Test
    public void keepValueShouldReturnNullWithNullValue() {
        Supplier<CompletableFuture> future = () -> CompletableFuture.completedFuture(null);
        Assertions.assertThat(CompletableFutureUtil.keepValue(future, null).join()).isNull();
    }

    @Test
    public void composeIfTrueShouldReturnTrueWhenTrue() {
        Assertions.assertThat((Boolean)((Boolean)((CompletableFuture)CompletableFutureUtil.composeIfTrue(() -> CompletableFuture.completedFuture(null)).apply(true)).join())).isTrue();
    }

    @Test
    public void composeIfTrueShouldReturnFalseWhenFalse() {
        Assertions.assertThat((Boolean)((Boolean)((CompletableFuture)CompletableFutureUtil.composeIfTrue(() -> CompletableFuture.completedFuture(null)).apply(false)).join())).isFalse();
    }

    @Test
    public void composeIfTrueShouldComposeWhenTrue() {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        ((CompletableFuture)CompletableFutureUtil.composeIfTrue(() -> {
            atomicInteger.incrementAndGet();
            return CompletableFuture.completedFuture(null);
        }).apply(true)).join();
        Assertions.assertThat((int)atomicInteger.get()).isEqualTo(1);
    }

    @Test
    public void composeIfTrueShouldNotComposeWhenFalse() {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        ((CompletableFuture)CompletableFutureUtil.composeIfTrue(() -> {
            atomicInteger.incrementAndGet();
            return CompletableFuture.completedFuture(null);
        }).apply(false)).join();
        Assertions.assertThat((int)atomicInteger.get()).isEqualTo(0);
    }

    @Test
    public void reduceShouldReturnEmptyWhenNoValue() {
        Assertions.assertThat((Optional)((Optional)CompletableFutureUtil.reduce((i, j) -> i + j, (CompletableFuture)CompletableFutureUtil.allOfArray((CompletableFuture[])new CompletableFuture[0])).join())).isEmpty();
    }

    @Test
    public void reduceShouldWork() {
        Assertions.assertThat((Optional)((Optional)CompletableFutureUtil.reduce((i, j) -> i + j, (CompletableFuture)CompletableFutureUtil.allOfArray((CompletableFuture[])new CompletableFuture[]{CompletableFuture.completedFuture(1L), CompletableFuture.completedFuture(2L), CompletableFuture.completedFuture(3L)})).join())).contains((Object)6L);
    }
}

