/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vut.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.james.vut.api.VirtualUserTable;
import org.apache.james.vut.lib.VirtualUserTableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockVirtualUserTableManagementImpl
implements VirtualUserTable {
    HashMap store = new HashMap();

    public boolean addAddressMapping(String user, String domain, String address) {
        return this.addRawMapping(user, domain, address);
    }

    public boolean addErrorMapping(String user, String domain, String error) {
        return this.addRawMapping(user, domain, "error:" + error);
    }

    public boolean addMapping(String user, String domain, String mapping) {
        if (mapping.startsWith("error:")) {
            return this.addErrorMapping(user, domain, mapping.substring("error:".length()));
        }
        if (mapping.startsWith("regex:")) {
            return this.addErrorMapping(user, domain, mapping.substring("regex:".length()));
        }
        return this.addAddressMapping(user, domain, mapping);
    }

    public boolean addRegexMapping(String user, String domain, String regex) {
        return this.addRawMapping(user, domain, "regex:" + regex);
    }

    public Map getAllMappings() {
        if (this.store.size() > 0) {
            return this.store;
        }
        return null;
    }

    public Collection getUserDomainMappings(String user, String domain) {
        String mapping = (String)this.store.get(user + "@" + domain);
        if (mapping != null) {
            return VirtualUserTableUtil.mappingToCollection((String)mapping);
        }
        return null;
    }

    public boolean removeAddressMapping(String user, String domain, String address) {
        return this.removeRawMapping(user, domain, address);
    }

    public boolean removeErrorMapping(String user, String domain, String error) {
        return this.removeRawMapping(user, domain, "error:" + error);
    }

    public boolean removeMapping(String user, String domain, String mapping) {
        if (mapping.startsWith("error:")) {
            return this.removeErrorMapping(user, domain, mapping.substring("error:".length()));
        }
        if (mapping.startsWith("regex:")) {
            return this.removeErrorMapping(user, domain, mapping.substring("regex:".length()));
        }
        return this.removeAddressMapping(user, domain, mapping);
    }

    public boolean removeRegexMapping(String user, String domain, String regex) {
        return this.removeRawMapping(user, domain, "regex:" + regex);
    }

    public Collection<String> getMappings(String user, String domain) throws VirtualUserTable.ErrorMappingException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private boolean addRawMapping(String user, String domain, String mapping) {
        String key = user + "@" + domain;
        String mappings = (String)this.store.get(key);
        if (mappings != null) {
            ArrayList map = VirtualUserTableUtil.mappingToCollection((String)mappings);
            if (map.contains(mapping)) {
                return false;
            }
            map.add(mapping);
            this.store.put(key, VirtualUserTableUtil.CollectionToMapping((Collection)map));
            return true;
        }
        this.store.put(key, mapping);
        return true;
    }

    private boolean removeRawMapping(String user, String domain, String mapping) {
        ArrayList map;
        String key = user + "@" + domain;
        String mappings = (String)this.store.get(key);
        if (mappings != null && (map = VirtualUserTableUtil.mappingToCollection((String)mappings)).remove(mapping)) {
            this.store.put(key, VirtualUserTableUtil.CollectionToMapping((Collection)map));
            return true;
        }
        return false;
    }

    public boolean addAliasDomainMapping(String aliasDomain, String realDomain) {
        return this.addRawMapping(null, aliasDomain, "domain:" + realDomain);
    }

    public boolean removeAliasDomainMapping(String aliasDomain, String realDomain) {
        return this.removeRawMapping(null, aliasDomain, "domain:" + realDomain);
    }
}

