/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersStore;
import org.apache.james.user.lib.MockUsersRepository;
import org.apache.james.user.lib.MockUsersStore;
import org.apache.james.user.lib.UserManagement;

public class UserManagementTest
extends TestCase {
    private MockUsersRepository m_mockUsersRepository;
    private UserManagement m_userManagement;

    protected void setUp() throws Exception {
        this.m_mockUsersRepository = new MockUsersRepository();
        this.m_userManagement = new UserManagement();
        this.m_userManagement.setUsersRepository((UsersRepository)this.m_mockUsersRepository);
        this.m_userManagement.setUsersStore((UsersStore)new MockUsersStore((UsersRepository)this.m_mockUsersRepository));
    }

    public void testUserCount() {
        UserManagementTest.assertEquals((String)"no user yet", (long)0L, (long)this.m_userManagement.countUsers(null));
        this.m_mockUsersRepository.addUser("testCount1", "testCount");
        UserManagementTest.assertEquals((String)"1 user", (long)1L, (long)this.m_userManagement.countUsers(null));
        this.m_mockUsersRepository.addUser("testCount2", "testCount");
        UserManagementTest.assertEquals((String)"2 users", (long)2L, (long)this.m_userManagement.countUsers(null));
        this.m_mockUsersRepository.removeUser("testCount1");
        UserManagementTest.assertEquals((String)"1 user", (long)1L, (long)this.m_userManagement.countUsers(null));
    }

    public void testDefaultRepositoryIsLocalUsers() {
        this.m_userManagement.addUser("testCount1", "testCount", null);
        this.m_userManagement.addUser("testCount2", "testCount", "LocalUsers");
        UserManagementTest.assertEquals((String)"2 users", (long)2L, (long)this.m_userManagement.countUsers(null));
        UserManagementTest.assertEquals((String)"2 users", (long)2L, (long)this.m_userManagement.countUsers("LocalUsers"));
    }

    public void testNonExistingRepository() {
        try {
            this.m_userManagement.addUser("testCount1", "testCount", "NonExisting");
            UserManagementTest.fail((String)"retrieved non-existing repository");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddUserAndVerify() {
        UserManagementTest.assertTrue((String)"user added", (boolean)this.m_mockUsersRepository.addUser("testCount1", "testCount"));
        UserManagementTest.assertFalse((String)"user not there", (boolean)this.m_userManagement.verifyExists("testNotAdded", null));
        UserManagementTest.assertTrue((String)"user is there", (boolean)this.m_userManagement.verifyExists("testCount1", null));
        this.m_mockUsersRepository.removeUser("testCount1");
        UserManagementTest.assertFalse((String)"user not there", (boolean)this.m_userManagement.verifyExists("testCount1", null));
    }

    public void testDelUser() {
        UserManagementTest.assertTrue((String)"user added", (boolean)this.m_mockUsersRepository.addUser("testDel", "test"));
        UserManagementTest.assertFalse((String)"user not there", (boolean)this.m_userManagement.verifyExists("testNotDeletable", null));
        UserManagementTest.assertTrue((String)"user is there", (boolean)this.m_userManagement.verifyExists("testDel", null));
        this.m_mockUsersRepository.removeUser("testDel");
        UserManagementTest.assertFalse((String)"user no longer there", (boolean)this.m_userManagement.verifyExists("testDel", null));
    }

    public void testListUsers() {
        String[] usersArray = new String[]{"ccc", "aaa", "dddd", "bbbbb"};
        List<String> users = Arrays.asList(usersArray);
        for (int i = 0; i < users.size(); ++i) {
            String user = users.get(i);
            UserManagementTest.assertTrue((String)"user added", (boolean)this.m_mockUsersRepository.addUser(user, "test"));
        }
        String[] userNames = this.m_userManagement.listAllUsers(null);
        UserManagementTest.assertEquals((String)"user count", (int)users.size(), (int)userNames.length);
        for (int i = 0; i < userNames.length; ++i) {
            String user = userNames[i];
            if (users.contains(user)) continue;
            UserManagementTest.fail((String)"user not listed");
        }
    }

    public void testSetPassword() {
        UserManagementTest.assertTrue((String)"user added", (boolean)this.m_userManagement.addUser("testPwdUser", "pwd1", null));
        UserManagementTest.assertTrue((String)"initial password", (boolean)this.m_mockUsersRepository.test("testPwdUser", "pwd1"));
        UserManagementTest.assertTrue((String)"changed to empty password", (boolean)this.m_userManagement.setPassword("testPwdUser", "", null));
        UserManagementTest.assertTrue((String)"password changed to empty", (boolean)this.m_mockUsersRepository.test("testPwdUser", ""));
        UserManagementTest.assertTrue((String)"changed password", (boolean)this.m_userManagement.setPassword("testPwdUser", "pwd2", null));
        UserManagementTest.assertTrue((String)"password not changed to pwd2", (boolean)this.m_mockUsersRepository.test("testPwdUser", "pwd2"));
        UserManagementTest.assertTrue((String)"changed password", (boolean)this.m_userManagement.setPassword("testPwdUser", "pWD2", null));
        UserManagementTest.assertFalse((String)"password no longer pwd2", (boolean)this.m_mockUsersRepository.test("testPwdUser", "pwd2"));
        UserManagementTest.assertTrue((String)"password changed to pWD2", (boolean)this.m_mockUsersRepository.test("testPwdUser", "pWD2"));
    }

    public void testListRepositories() {
        List userRepositoryNames = this.m_userManagement.getUserRepositoryNames();
        UserManagementTest.assertTrue((String)"default is there", (boolean)userRepositoryNames.contains("LocalUsers"));
    }
}

