/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.james.lifecycle.LifecycleUtil;
import org.apache.james.user.api.User;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.lib.DefaultJamesUser;
import org.apache.james.user.lib.MockUsersRepository;

public class MockUsersRepositoryTest
extends TestCase {
    protected UsersRepository usersRepository;

    protected UsersRepository getUsersRepository() throws Exception {
        MockUsersRepository repos = new MockUsersRepository();
        repos.setLog((Log)new SimpleLog("MockLog"));
        repos.configure((HierarchicalConfiguration)new DefaultConfigurationBuilder());
        return repos;
    }

    public void testUsersRepositoryEmpty() {
        MockUsersRepositoryTest.assertEquals((String)"users repository not empty", (int)0, (int)this.usersRepository.countUsers());
        MockUsersRepositoryTest.assertFalse((String)"users repository not empty", (boolean)this.usersRepository.list().hasNext());
    }

    public void testAddUserOnce() {
        boolean res = this.usersRepository.addUser("username", "password");
        MockUsersRepositoryTest.assertTrue((String)"User not added", (boolean)res);
        res = this.usersRepository.addUser("username", "password2");
        MockUsersRepositoryTest.assertFalse((String)"User added twice!", (boolean)res);
        try {
            this.usersRepository.addUser("username2", (Object)"password2");
            MockUsersRepositoryTest.assertTrue((boolean)this.usersRepository.contains("username2"));
            DefaultJamesUser u = new DefaultJamesUser("username3", "SHA", "password3");
            this.usersRepository.addUser((User)u);
            MockUsersRepositoryTest.assertTrue((boolean)this.usersRepository.contains("username3"));
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            this.usersRepository.addUser("username2", new Object());
            MockUsersRepositoryTest.fail((String)"adduser should throw an exception if a non string is passed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testUserAddedIsFound() {
        boolean res = this.usersRepository.addUser("username", "password");
        MockUsersRepositoryTest.assertTrue((String)"User not added", (boolean)res);
        User user = this.usersRepository.getUserByName("username");
        MockUsersRepositoryTest.assertNotNull((Object)user);
        MockUsersRepositoryTest.assertEquals((String)"username does not match", (String)user.getUserName(), (String)"username");
        MockUsersRepositoryTest.assertTrue((String)"user not contained in the repository", (boolean)this.usersRepository.contains("username"));
        try {
            MockUsersRepositoryTest.assertTrue((String)"case insensitive user not found in the repository", (boolean)this.usersRepository.containsCaseInsensitive("userName"));
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        User u = this.usersRepository.getUserByName("uSERNAMe");
        MockUsersRepositoryTest.assertNull((String)"found the user searching for a different case!", (Object)u);
        String realname = this.usersRepository.getRealName("uSERNAMe");
        MockUsersRepositoryTest.assertNull((String)"name is not null", (Object)realname);
    }

    public void testUserListing() {
        ArrayList<String> keys = new ArrayList<String>(3);
        keys.add("username1");
        keys.add("username2");
        keys.add("username3");
        for (String username : keys) {
            boolean res = this.usersRepository.addUser(username, username);
            MockUsersRepositoryTest.assertTrue((String)("User " + username + " not added"), (boolean)res);
        }
        MockUsersRepositoryTest.assertEquals((String)"Wrong number of users found", (int)keys.size(), (int)this.usersRepository.countUsers());
        ArrayList check = new ArrayList(keys);
        Iterator i = this.usersRepository.list();
        while (i.hasNext()) {
            String username = (String)i.next();
            if (this.getPasswordsEnabled()) {
                MockUsersRepositoryTest.assertTrue((boolean)this.usersRepository.test(username, username));
                User u = this.usersRepository.getUserByName(username);
                u.setPassword("newpass");
                MockUsersRepositoryTest.assertTrue((boolean)this.usersRepository.updateUser(u));
            }
            MockUsersRepositoryTest.assertTrue((boolean)check.contains(username));
            check.remove(username);
        }
        MockUsersRepositoryTest.assertEquals((String)"Some user has not be found", (int)0, (int)check.size());
    }

    public void testUserPassword() {
        MockUsersRepositoryTest.assertTrue((String)"user not added", (boolean)this.usersRepository.addUser("username", "password"));
        MockUsersRepositoryTest.assertEquals((String)"didn't accept the correct password ", (boolean)this.usersRepository.test("username", "password"), (boolean)this.getPasswordsEnabled());
        MockUsersRepositoryTest.assertFalse((String)"accepted the wrong password #1", (boolean)this.usersRepository.test("username", "password2"));
        MockUsersRepositoryTest.assertFalse((String)"accepted the wrong password #2", (boolean)this.usersRepository.test("username2", "password"));
        MockUsersRepositoryTest.assertFalse((String)"accepted the wrong password #3", (boolean)this.usersRepository.test("username", "Password"));
        MockUsersRepositoryTest.assertFalse((String)"accepted the wrong password #4", (boolean)this.usersRepository.test("username", "passwords"));
        MockUsersRepositoryTest.assertFalse((String)"accepted the wrong password #5", (boolean)this.usersRepository.test("userName", "password"));
    }

    protected boolean getPasswordsEnabled() {
        return true;
    }

    public void testUserAddRemoveCycle() {
        MockUsersRepositoryTest.assertFalse((String)"accepted login when no user existed", (boolean)this.usersRepository.test("username", "password"));
        try {
            this.usersRepository.removeUser("username");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MockUsersRepositoryTest.assertTrue((String)"user not added", (boolean)this.usersRepository.addUser("username", "password"));
        MockUsersRepositoryTest.assertEquals((String)"didn't accept the correct password", (boolean)this.usersRepository.test("username", "password"), (boolean)this.getPasswordsEnabled());
        User user = this.usersRepository.getUserByName("username");
        user.setPassword("newpass");
        try {
            MockUsersRepositoryTest.assertTrue((String)"user not updated", (boolean)this.usersRepository.updateUser(user));
            MockUsersRepositoryTest.assertEquals((String)"new password accepted", (boolean)this.usersRepository.test("username", "newpass"), (boolean)this.getPasswordsEnabled());
            MockUsersRepositoryTest.assertFalse((String)"old password rejected", (boolean)this.usersRepository.test("username", "password"));
        }
        catch (UnsupportedOperationException e) {
            MockUsersRepositoryTest.assertFalse((boolean)this.getPasswordsEnabled());
        }
        try {
            this.usersRepository.removeUser("username");
        }
        catch (Exception e) {
            e.printStackTrace();
            MockUsersRepositoryTest.fail((String)"removing the user failed!");
        }
        MockUsersRepositoryTest.assertFalse((String)"user not existing", (boolean)this.usersRepository.contains("username"));
        MockUsersRepositoryTest.assertFalse((String)"new password rejected", (boolean)this.usersRepository.test("username", "newpass"));
        MockUsersRepositoryTest.assertFalse((String)"updated a non existing user: should fail!", (boolean)this.usersRepository.updateUser(user));
    }

    public void testCaseInsensitivesMethods() {
        MockUsersRepositoryTest.assertTrue((String)"User not added", (boolean)this.usersRepository.addUser("userName", "password"));
        try {
            MockUsersRepositoryTest.assertTrue((boolean)this.usersRepository.containsCaseInsensitive("usERname"));
            MockUsersRepositoryTest.assertNotNull((Object)this.usersRepository.getUserByNameCaseInsensitive("userNAMe"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        MockUsersRepositoryTest.assertEquals((boolean)this.usersRepository.addUser("USERNAME", "password"), (boolean)this.getAllowMultipleUsersWithDifferentCases());
    }

    protected boolean getCheckCase() {
        return true;
    }

    protected boolean getAllowMultipleUsersWithDifferentCases() {
        return this.getCheckCase();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.usersRepository = this.getUsersRepository();
    }

    protected void tearDown() throws Exception {
        this.disposeUsersRepository();
        super.tearDown();
    }

    protected void disposeUsersRepository() {
        if (this.usersRepository != null) {
            LifecycleUtil.dispose((Object)this.usersRepository);
        }
    }
}

