/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib;

import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.james.user.api.User;
import org.apache.james.user.lib.AbstractJamesUsersRepository;
import org.apache.james.user.lib.DefaultJamesUser;
import org.apache.james.user.lib.DefaultUser;
import org.apache.james.user.lib.util.DigestUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockUsersRepository
extends AbstractJamesUsersRepository {
    private final HashMap<String, User> m_users = new HashMap();
    private boolean m_forceUseJamesUser = false;

    public void setForceUseJamesUser() {
        this.m_forceUseJamesUser = true;
    }

    public boolean addUser(User user) {
        String key;
        if (this.m_forceUseJamesUser && user instanceof DefaultUser) {
            DefaultUser aUser = (DefaultUser)user;
            user = new DefaultJamesUser(aUser.getUserName(), aUser.getHashedPassword(), aUser.getHashAlgorithm());
        }
        if (this.m_users.containsKey(key = user.getUserName())) {
            return false;
        }
        this.m_users.put(key, user);
        return true;
    }

    public void addUser(String name, Object attributes) {
        if (!(attributes instanceof String)) {
            throw new IllegalArgumentException();
        }
        try {
            String passwordHash = DigestUtil.digestString((String)((String)attributes), (String)"SHA");
            Object user = this.m_forceUseJamesUser ? new DefaultJamesUser(name, passwordHash, "SHA") : new DefaultUser(name, passwordHash, "SHA");
            this.addUser((User)user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean addUser(String username, String password) {
        if (this.m_users.containsKey(username)) {
            return false;
        }
        try {
            String passwordHash = DigestUtil.digestString((String)password, (String)"SHA");
            Object user = this.m_forceUseJamesUser ? new DefaultJamesUser(username, passwordHash, "SHA") : new DefaultUser(username, passwordHash, "SHA");
            return this.addUser((User)user);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Object getAttributes(String name) {
        return null;
    }

    public User getUserByName(String name) {
        if (this.ignoreCase) {
            return this.getUserByNameCaseInsensitive(name);
        }
        return this.m_users.get(name);
    }

    public User getUserByNameCaseInsensitive(String name) {
        return this.m_users.get(name.toLowerCase(Locale.US));
    }

    public String getRealName(String name) {
        if (this.ignoreCase) {
            return this.m_users.get(name.toLowerCase(Locale.US)) != null ? this.m_users.get(name.toLowerCase(Locale.US)).getUserName() : null;
        }
        return this.m_users.get(name) != null ? name : null;
    }

    public boolean updateUser(User user) {
        if (this.m_users.containsKey(user.getUserName())) {
            this.m_users.put(user.getUserName(), user);
            return true;
        }
        return false;
    }

    public void removeUser(String name) {
        this.m_users.remove(name);
    }

    public boolean contains(String name) {
        if (this.ignoreCase) {
            return this.containsCaseInsensitive(name);
        }
        return this.m_users.containsKey(name);
    }

    public boolean containsCaseInsensitive(String name) {
        throw new UnsupportedOperationException("mock");
    }

    public boolean test(String name, Object attributes) {
        throw new UnsupportedOperationException("mock");
    }

    public boolean test(String name, String password) {
        User user = this.getUserByName(name);
        if (user == null) {
            return false;
        }
        return user.verifyPassword(password);
    }

    public int countUsers() {
        return this.m_users.size();
    }

    protected List<String> listUserNames() {
        Iterator<User> users = this.m_users.values().iterator();
        LinkedList<String> userNames = new LinkedList<String>();
        while (users.hasNext()) {
            User user = users.next();
            userNames.add(user.getUserName());
        }
        return userNames;
    }

    public Iterator<String> list() {
        return this.listUserNames().iterator();
    }

    protected void doAddUser(User user) {
    }

    protected void doUpdateUser(User user) {
    }
}

