/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.core.MailAddress;
import org.apache.james.rate.limiter.api.AcceptableRate$;
import org.apache.james.rate.limiter.api.RateExceeded$;
import org.apache.james.rate.limiter.api.RateLimiter;
import org.apache.james.rate.limiter.api.RateLimiterFactory;
import org.apache.james.rate.limiter.api.RateLimitingResult;
import org.apache.james.rate.limiter.api.Rules;
import org.apache.james.transport.mailets.Count$;
import org.apache.james.transport.mailets.DurationParsingUtil$;
import org.apache.james.transport.mailets.EntityType;
import org.apache.james.transport.mailets.KeyPrefix;
import org.apache.james.transport.mailets.KeyPrefix$;
import org.apache.james.transport.mailets.PerSenderRateLimiter;
import org.apache.james.transport.mailets.PrecisionParsingUtil$;
import org.apache.james.transport.mailets.RecipientsType$;
import org.apache.james.transport.mailets.Size$;
import org.apache.james.transport.mailets.TotalSize$;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\re\u0001B\u000e\u001d\u0001\u001dB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\u0006w\u0001!\t\u0001\u0010\u0005\n\u0013\u0002\u0001\r\u00111A\u0005\n)C\u0011B\u0014\u0001A\u0002\u0003\u0007I\u0011B(\t\u0013a\u0003\u0001\u0019!A!B\u0013Y\u0005\"C-\u0001\u0001\u0004\u0005\r\u0011\"\u0003K\u0011%Q\u0006\u00011AA\u0002\u0013%1\fC\u0005^\u0001\u0001\u0007\t\u0011)Q\u0005\u0017\"Ia\f\u0001a\u0001\u0002\u0004%IA\u0013\u0005\n?\u0002\u0001\r\u00111A\u0005\n\u0001D\u0011B\u0019\u0001A\u0002\u0003\u0005\u000b\u0015B&\t\u0013\r\u0004\u0001\u0019!a\u0001\n\u0013Q\u0005\"\u00033\u0001\u0001\u0004\u0005\r\u0011\"\u0003f\u0011%9\u0007\u00011A\u0001B\u0003&1\nC\u0005i\u0001\u0001\u0007\t\u0019!C\u0005S\"IQ\u000f\u0001a\u0001\u0002\u0004%IA\u001e\u0005\nq\u0002\u0001\r\u0011!Q!\n)D\u0011\"\u001f\u0001A\u0002\u0003\u0007I\u0011\u0002>\t\u0017\u0005\r\u0001\u00011AA\u0002\u0013%\u0011Q\u0001\u0005\u000b\u0003\u0013\u0001\u0001\u0019!A!B\u0013Y\bbBA\u0006\u0001\u0011\u0005\u0013Q\u0002\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!a\u0011\u0001\t\u0003\n)\u0005C\u0004\u0002T\u0001!I!!\u0016\t\u000f\u0005%\u0004\u0001\"\u0003\u0002l\t\u0011\u0002+\u001a:TK:$WM\u001d*bi\u0016d\u0015.\\5u\u0015\tib$A\u0004nC&dW\r^:\u000b\u0005}\u0001\u0013!\u0003;sC:\u001c\bo\u001c:u\u0015\t\t#%A\u0003kC6,7O\u0003\u0002$I\u00051\u0011\r]1dQ\u0016T\u0011!J\u0001\u0004_J<7\u0001A\n\u0003\u0001!\u0002\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\t\t\f7/\u001a\u0006\u0003[\t\na!\\1jY\u0016$\u0018BA\u0018+\u000559UM\\3sS\u000el\u0015-\u001b7fi\u0006\u0011\"/\u0019;f\u0019&l\u0017\u000e^3s\r\u0006\u001cGo\u001c:z!\t\u0011\u0014(D\u00014\u0015\t!T'A\u0002ba&T!AN\u001c\u0002\u000f1LW.\u001b;fe*\u0011\u0001\bI\u0001\u0005e\u0006$X-\u0003\u0002;g\t\u0011\"+\u0019;f\u0019&l\u0017\u000e^3s\r\u0006\u001cGo\u001c:z\u0003\u0019a\u0014N\\5u}Q\u0011Qh\u0010\t\u0003}\u0001i\u0011\u0001\b\u0005\u0006a\t\u0001\r!\r\u0015\u0003\u0005\u0005\u0003\"AQ$\u000e\u0003\rS!\u0001R#\u0002\r%t'.Z2u\u0015\u00051\u0015!\u00026bm\u0006D\u0018B\u0001%D\u0005\u0019IeN[3di\u0006\u00012m\\;oiJ\u000bG/\u001a'j[&$XM]\u000b\u0002\u0017B\u0011a\bT\u0005\u0003\u001br\u0011A\u0003U3s'\u0016tG-\u001a:SCR,G*[7ji\u0016\u0014\u0018\u0001F2pk:$(+\u0019;f\u0019&l\u0017\u000e^3s?\u0012*\u0017\u000f\u0006\u0002Q-B\u0011\u0011\u000bV\u0007\u0002%*\t1+A\u0003tG\u0006d\u0017-\u0003\u0002V%\n!QK\\5u\u0011\u001d9F!!AA\u0002-\u000b1\u0001\u001f\u00132\u0003E\u0019w.\u001e8u%\u0006$X\rT5nSR,'\u000fI\u0001\u0016e\u0016\u001c\u0017\u000e]5f]R\u001c(+\u0019;f\u0019&l\u0017\u000e^3s\u0003e\u0011XmY5qS\u0016tGo\u001d*bi\u0016d\u0015.\\5uKJ|F%Z9\u0015\u0005Ac\u0006bB,\b\u0003\u0003\u0005\raS\u0001\u0017e\u0016\u001c\u0017\u000e]5f]R\u001c(+\u0019;f\u0019&l\u0017\u000e^3sA\u0005y1/\u001b>f%\u0006$X\rT5nSR,'/A\ntSj,'+\u0019;f\u0019&l\u0017\u000e^3s?\u0012*\u0017\u000f\u0006\u0002QC\"9qKCA\u0001\u0002\u0004Y\u0015\u0001E:ju\u0016\u0014\u0016\r^3MS6LG/\u001a:!\u0003Q!x\u000e^1m'&TXMU1uK2KW.\u001b;fe\u0006ABo\u001c;bYNK'0\u001a*bi\u0016d\u0015.\\5uKJ|F%Z9\u0015\u0005A3\u0007bB,\u000e\u0003\u0003\u0005\raS\u0001\u0016i>$\u0018\r\\*ju\u0016\u0014\u0016\r^3MS6LG/\u001a:!\u0003E)\u0007pY3fI\u0016$\u0007K]8dKN\u001cxN]\u000b\u0002UB\u00111N\u001d\b\u0003YB\u0004\"!\u001c*\u000e\u00039T!a\u001c\u0014\u0002\rq\u0012xn\u001c;?\u0013\t\t(+\u0001\u0004Qe\u0016$WMZ\u0005\u0003gR\u0014aa\u0015;sS:<'BA9S\u0003U)\u0007pY3fI\u0016$\u0007K]8dKN\u001cxN]0%KF$\"\u0001U<\t\u000f]\u0003\u0012\u0011!a\u0001U\u0006\u0011R\r_2fK\u0012,G\r\u0015:pG\u0016\u001c8o\u001c:!\u0003%YW-\u001f)sK\u001aL\u00070F\u0001|!\r\tFP`\u0005\u0003{J\u0013aa\u00149uS>t\u0007C\u0001 \u0000\u0013\r\t\t\u0001\b\u0002\n\u0017\u0016L\bK]3gSb\fQb[3z!J,g-\u001b=`I\u0015\fHc\u0001)\u0002\b!9qkEA\u0001\u0002\u0004Y\u0018AC6fsB\u0013XMZ5yA\u0005!\u0011N\\5u)\u0005\u0001\u0016!\u00049beN,G)\u001e:bi&|g\u000e\u0006\u0002\u0002\u0014A!\u0011QCA\u0010\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011\u0001\u0002;j[\u0016T!!!\b\u0002\t)\fg/Y\u0005\u0005\u0003C\t9B\u0001\u0005EkJ\fG/[8oQ\r1\u0012Q\u0005\t\u0005\u0003O\tI$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003-\tgN\\8uCRLwN\\:\u000b\t\u0005=\u0012\u0011G\u0001\u0007G>lWn\u001c8\u000b\t\u0005M\u0012QG\u0001\u0007O>|w\r\\3\u000b\u0005\u0005]\u0012aA2p[&!\u00111HA\u0015\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgnZ\u0001\u000fa\u0006\u00148/\u001a)sK\u000eL7/[8o)\t\t\t\u0005\u0005\u0003Ry\u0006M\u0011aB:feZL7-\u001a\u000b\u0004!\u0006\u001d\u0003bBA%1\u0001\u0007\u00111J\u0001\u0005[\u0006LG\u000e\u0005\u0003\u0002N\u0005=S\"\u0001\u0017\n\u0007\u0005ECF\u0001\u0003NC&d\u0017\u0001E1qa2L(+\u0019;f\u0019&l\u0017\u000e^3s)\u0015\u0001\u0016qKA-\u0011\u001d\tI%\u0007a\u0001\u0003\u0017Bq!a\u0017\u001a\u0001\u0004\ti&\u0001\u0004tK:$WM\u001d\t\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111\r\u0011\u0002\t\r|'/Z\u0005\u0005\u0003O\n\tGA\u0006NC&d\u0017\t\u001a3sKN\u001c\u0018!E2sK\u0006$XMU1uK2KW.\u001b;feRY1*!\u001c\u0002p\u0005e\u00141PA@\u0011\u0015\u0001$\u00041\u00012\u0011\u001d\t\tH\u0007a\u0001\u0003g\n!\"\u001a8uSRLH+\u001f9f!\rq\u0014QO\u0005\u0004\u0003ob\"AC#oi&$\u0018\u0010V=qK\")\u0011P\u0007a\u0001w\"9\u0011Q\u0010\u000eA\u0002\u0005M\u0011\u0001\u00033ve\u0006$\u0018n\u001c8\t\u000f\u0005\u0005%\u00041\u0001\u0002B\u0005I\u0001O]3dSNLwN\u001c")
public class PerSenderRateLimit
extends GenericMailet {
    private final RateLimiterFactory rateLimiterFactory;
    private PerSenderRateLimiter countRateLimiter;
    private PerSenderRateLimiter recipientsRateLimiter;
    private PerSenderRateLimiter sizeRateLimiter;
    private PerSenderRateLimiter totalSizeRateLimiter;
    private String exceededProcessor;
    private Option<KeyPrefix> keyPrefix;

    private PerSenderRateLimiter countRateLimiter() {
        return this.countRateLimiter;
    }

    private void countRateLimiter_$eq(PerSenderRateLimiter x$1) {
        this.countRateLimiter = x$1;
    }

    private PerSenderRateLimiter recipientsRateLimiter() {
        return this.recipientsRateLimiter;
    }

    private void recipientsRateLimiter_$eq(PerSenderRateLimiter x$1) {
        this.recipientsRateLimiter = x$1;
    }

    private PerSenderRateLimiter sizeRateLimiter() {
        return this.sizeRateLimiter;
    }

    private void sizeRateLimiter_$eq(PerSenderRateLimiter x$1) {
        this.sizeRateLimiter = x$1;
    }

    private PerSenderRateLimiter totalSizeRateLimiter() {
        return this.totalSizeRateLimiter;
    }

    private void totalSizeRateLimiter_$eq(PerSenderRateLimiter x$1) {
        this.totalSizeRateLimiter = x$1;
    }

    private String exceededProcessor() {
        return this.exceededProcessor;
    }

    private void exceededProcessor_$eq(String x$1) {
        this.exceededProcessor = x$1;
    }

    private Option<KeyPrefix> keyPrefix() {
        return this.keyPrefix;
    }

    private void keyPrefix_$eq(Option<KeyPrefix> x$1) {
        this.keyPrefix = x$1;
    }

    public void init() {
        java.time.Duration duration = this.parseDuration();
        Option<java.time.Duration> precision = this.parsePrecision();
        this.keyPrefix_$eq((Option<KeyPrefix>)Option$.MODULE$.apply((Object)this.getInitParameter("keyPrefix")).map((Function1)KeyPrefix$.MODULE$));
        this.exceededProcessor_$eq(this.getInitParameter("exceededProcessor", "error"));
        this.countRateLimiter_$eq(this.perSenderRateLimiter$1(Count$.MODULE$, duration, precision));
        this.recipientsRateLimiter_$eq(this.perSenderRateLimiter$1(RecipientsType$.MODULE$, duration, precision));
        this.sizeRateLimiter_$eq(this.perSenderRateLimiter$1(Size$.MODULE$, duration, precision));
        this.totalSizeRateLimiter_$eq(this.perSenderRateLimiter$1(TotalSize$.MODULE$, duration, precision));
    }

    @VisibleForTesting
    public java.time.Duration parseDuration() {
        return DurationParsingUtil$.MODULE$.parseDuration(this.getMailetConfig());
    }

    public Option<java.time.Duration> parsePrecision() {
        return PrecisionParsingUtil$.MODULE$.parsePrecision(this.getMailetConfig());
    }

    public void service(Mail mail) {
        mail.getMaybeSender().asOptional().ifPresent(sender -> this.applyRateLimiter(mail, (MailAddress)sender));
    }

    private void applyRateLimiter(Mail mail, MailAddress sender) {
        Duration x$1;
        AcceptableRate$ pivot = AcceptableRate$.MODULE$;
        SMono qual$1 = SFlux$.MODULE$.merge((Seq)new .colon.colon(this.countRateLimiter().rateLimit(sender, mail), (List)new .colon.colon(this.recipientsRateLimiter().rateLimit(sender, mail), (List)new .colon.colon(this.sizeRateLimiter().rateLimit(sender, mail), (List)new .colon.colon(this.totalSizeRateLimiter().rateLimit(sender, mail), (List)Nil$.MODULE$)))), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3()).fold((Object)pivot, (Function2 & Serializable)(a, b) -> a.merge((RateLimitingResult)b));
        RateLimitingResult result = (RateLimitingResult)qual$1.block(x$1 = qual$1.block$default$1());
        if (result.equals(RateExceeded$.MODULE$)) {
            mail.setState(this.exceededProcessor());
            return;
        }
    }

    private PerSenderRateLimiter createRateLimiter(RateLimiterFactory rateLimiterFactory, EntityType entityType, Option<KeyPrefix> keyPrefix, java.time.Duration duration, Option<java.time.Duration> precision) {
        return new PerSenderRateLimiter((Option<RateLimiter>)entityType.extractRules(duration, this.getMailetConfig()).map((Function1 & Serializable)x$7 -> rateLimiterFactory.withSpecification((Rules)x$7, precision)), keyPrefix, entityType);
    }

    private final PerSenderRateLimiter perSenderRateLimiter$1(EntityType entityType, java.time.Duration duration$1, Option precision$1) {
        return this.createRateLimiter(this.rateLimiterFactory, entityType, this.keyPrefix(), duration$1, (Option<java.time.Duration>)precision$1);
    }

    @Inject
    public PerSenderRateLimit(RateLimiterFactory rateLimiterFactory) {
        this.rateLimiterFactory = rateLimiterFactory;
    }
}

