/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rate.limiter.redis;

import com.google.common.base.Preconditions;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import io.lettuce.core.RedisURI;
import java.io.Serializable;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.rate.limiter.redis.RedisRateLimiterConfiguration;
import org.apache.james.rate.limiter.redis.RedisUris$;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class RedisRateLimiterConfiguration$
implements Serializable {
    public static final RedisRateLimiterConfiguration$ MODULE$ = new RedisRateLimiterConfiguration$();
    private static final boolean CLUSTER_ENABLED_DEFAULT = false;

    public boolean CLUSTER_ENABLED_DEFAULT() {
        return CLUSTER_ENABLED_DEFAULT;
    }

    public RedisRateLimiterConfiguration from(Configuration config) {
        return this.from(config.getString("redisURL"), config.getBoolean("cluster.enabled", this.CLUSTER_ENABLED_DEFAULT()));
    }

    public RedisRateLimiterConfiguration from(String redisUri, boolean isCluster) {
        Preconditions.checkArgument((redisUri != null && !redisUri.isBlank() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)BoxesRunTime.boxToBoolean((boolean)isCluster));
        return new RedisRateLimiterConfiguration(RedisUris$.MODULE$.from(redisUri), isCluster);
    }

    public RedisRateLimiterConfiguration apply(List<RedisURI> redisURI, boolean isCluster) {
        return new RedisRateLimiterConfiguration(redisURI, isCluster);
    }

    public Option<Tuple2<Refined<List<RedisURI>, boolean.Not<collection.Empty>>, Object>> unapply(RedisRateLimiterConfiguration x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)new Refined(x$0.redisURI()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isCluster())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RedisRateLimiterConfiguration$.class);
    }

    private RedisRateLimiterConfiguration$() {
    }
}

