/*
 * Decompiled with CFR 0.152.
 */
package de.jkeylockmanager.manager.implementation.lockstripe;

import de.jkeylockmanager.contract.Contract;
import de.jkeylockmanager.manager.KeyLockManager;
import de.jkeylockmanager.manager.LockCallback;
import de.jkeylockmanager.manager.ReturnValueLockCallback;
import de.jkeylockmanager.manager.implementation.lockstripe.CountingLock;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public final class StripedKeyLockManager
implements KeyLockManager {
    private static final int DEFAULT_NUMBER_OF_STRIPES = 16;
    private final ConcurrentHashMap<Object, CountingLock> key2lock = new ConcurrentHashMap();
    private final CountingLock[] stripes;
    private final long lockTimeout;
    private final TimeUnit lockTimeoutUnit;

    public StripedKeyLockManager(long lockTimeout, TimeUnit lockTimeoutUnit) {
        this(lockTimeout, lockTimeoutUnit, 16);
    }

    public StripedKeyLockManager(long lockTimeout, TimeUnit lockTimeoutUnit, int numberOfStripes) {
        Contract.isNotNull((Object)lockTimeoutUnit, "lockTimeoutUnit != null");
        Contract.isTrue(lockTimeout > 0L, "lockTimeout > 0");
        Contract.isTrue(numberOfStripes > 0, "numberOfStripes > 0");
        this.lockTimeout = lockTimeout;
        this.lockTimeoutUnit = lockTimeoutUnit;
        this.stripes = new CountingLock[numberOfStripes];
        Arrays.setAll(this.stripes, i -> new CountingLock(lockTimeout, lockTimeoutUnit));
    }

    @Override
    public final void executeLocked(Object key, LockCallback callback) {
        Contract.isNotNull(key, "key != null");
        Contract.isNotNull(callback, "callback != null");
        this.executeLockedInternal(key, () -> {
            callback.doInLock();
            return null;
        });
    }

    @Override
    public final <R> R executeLocked(Object key, ReturnValueLockCallback<R> callback) {
        Contract.isNotNull(key, "key != null");
        Contract.isNotNull(callback, "callback != null");
        return this.executeLockedInternal(key, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R executeLockedInternal(Object key, ReturnValueLockCallback<R> callback) {
        assert (key != null) : "contract broken: key != null";
        assert (callback != null) : "contract broken: callback != null";
        CountingLock lock = this.getKeyLock(key);
        try {
            R r;
            lock.tryLock();
            try {
                r = callback.doInLock();
                lock.unlock();
            }
            catch (Throwable throwable) {
                lock.unlock();
                throw throwable;
            }
            return r;
        }
        finally {
            this.freeKeyLock(key, lock);
        }
    }

    private void freeKeyLock(Object key, CountingLock lock) {
        assert (key != null) : "contract broken: key != null";
        assert (lock != null) : "contract broken: lock != null";
        this.getStripedLock(key).tryLock();
        try {
            lock.decrementUses();
            if (!lock.isUsed()) {
                this.key2lock.remove(key);
            }
        }
        finally {
            this.getStripedLock(key).unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountingLock getKeyLock(Object key) {
        assert (key != null) : "contract broken: key != null";
        this.getStripedLock(key).tryLock();
        try {
            CountingLock result;
            CountingLock previousLock = this.key2lock.get(key);
            if (previousLock == null) {
                result = new CountingLock(this.lockTimeout, this.lockTimeoutUnit);
                this.key2lock.put(key, result);
            } else {
                result = previousLock;
            }
            result.incrementUses();
            CountingLock countingLock = result;
            return countingLock;
        }
        finally {
            this.getStripedLock(key).unlock();
        }
    }

    private CountingLock getStripedLock(Object key) {
        assert (key != null) : "contract broken: key != null";
        return this.stripes[Math.abs(key.hashCode() % this.stripes.length)];
    }

    int activeKeyLocksCount() {
        return this.key2lock.size();
    }

    int waitingThreadsCount() {
        int result = 0;
        for (CountingLock lock : this.key2lock.values()) {
            result += lock.getQueueLength();
        }
        return result;
    }
}

