/*
 * Decompiled with CFR 0.152.
 */
package es.moki.ratelimitj.redis.request;

import es.moki.ratelimitj.core.limiter.request.ReactiveRequestRateLimiter;
import es.moki.ratelimitj.core.limiter.request.RequestLimitRule;
import es.moki.ratelimitj.core.limiter.request.RequestLimitRulesSupplier;
import es.moki.ratelimitj.core.limiter.request.RequestRateLimiter;
import es.moki.ratelimitj.core.time.SystemTimeSupplier;
import es.moki.ratelimitj.core.time.TimeSupplier;
import es.moki.ratelimitj.redis.request.RedisScriptLoader;
import es.moki.ratelimitj.redis.request.SerializedRequestLimitRulesSupplier;
import io.lettuce.core.RedisNoScriptException;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.reactive.RedisKeyReactiveCommands;
import io.lettuce.core.api.reactive.RedisScriptingReactiveCommands;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

@ParametersAreNonnullByDefault
@ThreadSafe
public class RedisSlidingWindowRequestRateLimiter
implements RequestRateLimiter,
ReactiveRequestRateLimiter {
    private static final Logger LOG = LoggerFactory.getLogger(RedisSlidingWindowRequestRateLimiter.class);
    private static final Duration BLOCK_TIMEOUT = Duration.of(5L, ChronoUnit.SECONDS);
    private final RedisScriptingReactiveCommands<String, String> redisScriptingReactiveCommands;
    private final RedisKeyReactiveCommands<String, String> redisKeyCommands;
    private final RedisScriptLoader scriptLoader;
    private final RequestLimitRulesSupplier<String> requestLimitRulesSupplier;
    private final TimeSupplier timeSupplier;

    public RedisSlidingWindowRequestRateLimiter(RedisScriptingReactiveCommands<String, String> redisScriptingReactiveCommands, RedisKeyReactiveCommands<String, String> redisKeyCommands, RequestLimitRule rule) {
        this(redisScriptingReactiveCommands, redisKeyCommands, Collections.singleton(rule));
    }

    public RedisSlidingWindowRequestRateLimiter(RedisScriptingReactiveCommands<String, String> redisScriptingReactiveCommands, RedisKeyReactiveCommands<String, String> redisKeyCommands, Set<RequestLimitRule> rules) {
        this(redisScriptingReactiveCommands, redisKeyCommands, rules, new SystemTimeSupplier());
    }

    public RedisSlidingWindowRequestRateLimiter(RedisScriptingReactiveCommands<String, String> redisScriptingReactiveCommands, RedisKeyReactiveCommands<String, String> redisKeyCommands, Set<RequestLimitRule> rules, TimeSupplier timeSupplier) {
        Objects.requireNonNull(rules, "rules can not be null");
        Objects.requireNonNull(timeSupplier, "time supplier can not be null");
        Objects.requireNonNull(redisScriptingReactiveCommands, "redisScriptingReactiveCommands can not be null");
        Objects.requireNonNull(redisKeyCommands, "redisKeyCommands can not be null");
        this.redisScriptingReactiveCommands = redisScriptingReactiveCommands;
        this.redisKeyCommands = redisKeyCommands;
        this.scriptLoader = new RedisScriptLoader(redisScriptingReactiveCommands, "sliding-window-ratelimit.lua");
        this.requestLimitRulesSupplier = new SerializedRequestLimitRulesSupplier(rules);
        this.timeSupplier = timeSupplier;
    }

    private static boolean startWithNoScriptError(Throwable throwable) {
        return throwable instanceof RedisNoScriptException;
    }

    @Override
    public boolean overLimitWhenIncremented(String key) {
        return this.overLimitWhenIncremented(key, 1);
    }

    @Override
    public boolean overLimitWhenIncremented(String key, int weight) {
        return this.throwOnTimeout(this.eqOrGeLimitReactive(key, weight, true));
    }

    @Override
    public boolean geLimitWhenIncremented(String key) {
        return this.geLimitWhenIncremented(key, 1);
    }

    @Override
    public boolean geLimitWhenIncremented(String key, int weight) {
        return this.throwOnTimeout(this.eqOrGeLimitReactive(key, weight, false));
    }

    @Override
    public boolean resetLimit(String key) {
        return this.throwOnTimeout(this.resetLimitReactive(key));
    }

    @Override
    public Mono<Boolean> overLimitWhenIncrementedReactive(String key) {
        return this.overLimitWhenIncrementedReactive(key, 1);
    }

    @Override
    public Mono<Boolean> overLimitWhenIncrementedReactive(String key, int weight) {
        return this.eqOrGeLimitReactive(key, weight, true);
    }

    @Override
    public Mono<Boolean> geLimitWhenIncrementedReactive(String key) {
        return this.geLimitWhenIncrementedReactive(key, 1);
    }

    @Override
    public Mono<Boolean> geLimitWhenIncrementedReactive(String key, int weight) {
        return this.eqOrGeLimitReactive(key, weight, false);
    }

    @Override
    public Mono<Boolean> resetLimitReactive(String key) {
        return this.redisKeyCommands.del((String[])new String[]{key}).map(count -> count > 0L);
    }

    private Mono<Boolean> eqOrGeLimitReactive(String key, int weight, boolean strictlyGreater) {
        Objects.requireNonNull(key);
        String rulesJson = this.requestLimitRulesSupplier.getRules(key);
        return Mono.zip(this.timeSupplier.getReactive(), this.scriptLoader.storedScript()).flatMapMany(tuple -> {
            Long time = (Long)tuple.getT1();
            RedisScriptLoader.StoredScript script = (RedisScriptLoader.StoredScript)tuple.getT2();
            return this.redisScriptingReactiveCommands.evalsha(script.getSha(), ScriptOutputType.VALUE, (K[])new String[]{key}, (V[])new String[]{rulesJson, time.toString(), Integer.toString(weight), this.toStringOneZero(strictlyGreater)}).doOnError(RedisSlidingWindowRequestRateLimiter::startWithNoScriptError, e -> script.dispose());
        }).retryWhen((Retry)Retry.max((long)1L).filter(RedisSlidingWindowRequestRateLimiter::startWithNoScriptError)).single().map("1"::equals).doOnSuccess(over -> {
            if (over.booleanValue()) {
                LOG.debug("Requests matched by key '{}' incremented by weight {} are greater than {}the limit", key, weight, strictlyGreater ? "" : "or equal to ");
            }
        });
    }

    private String toStringOneZero(boolean strictlyGreater) {
        return strictlyGreater ? "1" : "0";
    }

    private boolean throwOnTimeout(Mono<Boolean> mono) {
        Boolean result = (Boolean)mono.block(BLOCK_TIMEOUT);
        if (result == null) {
            throw new RuntimeException("waited " + BLOCK_TIMEOUT + "before timing out");
        }
        return result;
    }
}

