/*
 * Decompiled with CFR 0.152.
 */
package es.moki.ratelimitj.redis.request;

import io.lettuce.core.api.reactive.RedisScriptingReactiveCommands;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedisScriptLoader {
    private static final Logger LOG = LoggerFactory.getLogger(RedisScriptLoader.class);
    private final RedisScriptingReactiveCommands<String, String> redisScriptingCommands;
    private final String scriptUri;
    private final AtomicReference<Flux<String>> storedScript;

    public RedisScriptLoader(RedisScriptingReactiveCommands<String, String> redisScriptingCommands, String scriptUri) {
        this(redisScriptingCommands, scriptUri, false);
    }

    public RedisScriptLoader(RedisScriptingReactiveCommands<String, String> redisScriptingCommands, String scriptUri, boolean eagerLoad) {
        Objects.requireNonNull(redisScriptingCommands);
        this.redisScriptingCommands = redisScriptingCommands;
        this.scriptUri = Objects.requireNonNull(scriptUri);
        this.storedScript = new AtomicReference<Flux<String>>(this.loadScript());
        if (eagerLoad) {
            this.storedScript.get().doOnComplete(() -> LOG.info("Redis Script eager load complete")).blockFirst(Duration.ofSeconds(10L));
        }
    }

    Mono<StoredScript> storedScript() {
        return Mono.defer(() -> {
            Flux<String> source = this.storedScript.get();
            return source.next().map(sha -> new StoredScript((String)sha, source));
        });
    }

    private Flux<String> loadScript() {
        return Flux.defer(() -> {
            String script;
            try {
                script = this.readScriptFile();
            }
            catch (IOException e) {
                return Flux.error((Throwable)new RuntimeException("Unable to load Redis LUA script file", e));
            }
            return this.redisScriptingCommands.scriptLoad(script);
        }).replay(1).autoConnect(1);
    }

    private String readScriptFile() throws IOException {
        URL url = RedisScriptLoader.class.getClassLoader().getResource(this.scriptUri);
        if (url == null) {
            throw new IllegalArgumentException("script '" + this.scriptUri + "' not found");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    class StoredScript {
        private final String sha;
        private final Flux<String> expected;

        StoredScript(String sha, Flux<String> expected) {
            this.sha = sha;
            this.expected = expected;
        }

        public String getSha() {
            return this.sha;
        }

        public void dispose() {
            RedisScriptLoader.this.storedScript.weakCompareAndSet(this.expected, RedisScriptLoader.this.loadScript());
        }
    }
}

