/*
 * Decompiled with CFR 0.152.
 */
package es.moki.ratelimitj.redis.request;

import es.moki.ratelimitj.core.limiter.request.AbstractRequestRateLimiterFactory;
import es.moki.ratelimitj.core.limiter.request.ReactiveRequestRateLimiter;
import es.moki.ratelimitj.core.limiter.request.RequestLimitRule;
import es.moki.ratelimitj.core.limiter.request.RequestRateLimiter;
import es.moki.ratelimitj.redis.request.RedisSlidingWindowRequestRateLimiter;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import java.util.Objects;
import java.util.Set;

public class RedisClusterRateLimiterFactory
extends AbstractRequestRateLimiterFactory<RedisSlidingWindowRequestRateLimiter> {
    private final RedisClusterClient client;
    private StatefulRedisClusterConnection<String, String> connection;

    public RedisClusterRateLimiterFactory(RedisClusterClient client) {
        this.client = Objects.requireNonNull(client);
    }

    @Override
    public RequestRateLimiter getInstance(Set<RequestLimitRule> rules) {
        return (RequestRateLimiter)this.lookupInstance(rules);
    }

    @Override
    public ReactiveRequestRateLimiter getInstanceReactive(Set<RequestLimitRule> rules) {
        return (ReactiveRequestRateLimiter)this.lookupInstance(rules);
    }

    @Override
    protected RedisSlidingWindowRequestRateLimiter create(Set<RequestLimitRule> rules) {
        this.getConnection().reactive();
        return new RedisSlidingWindowRequestRateLimiter(this.getConnection().reactive(), this.getConnection().reactive(), rules);
    }

    @Override
    public void close() {
        this.client.shutdown();
    }

    private StatefulRedisClusterConnection<String, String> getConnection() {
        if (this.connection == null) {
            this.connection = this.client.connect();
        }
        return this.connection;
    }
}

