/*
 * Decompiled with CFR 0.152.
 */
package es.moki.ratelimitj.inmemory.concurrent;

import es.moki.ratelimitj.core.limiter.concurrent.Baton;
import es.moki.ratelimitj.core.limiter.concurrent.ConcurrentLimitRule;
import es.moki.ratelimitj.core.limiter.concurrent.ConcurrentRequestLimiter;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;

public class InMemoryConcurrentRequestRateLimiter
implements ConcurrentRequestLimiter {
    private final ExpiringMap<String, Semaphore> expiringKeyMap;
    private final ConcurrentLimitRule rule;

    public InMemoryConcurrentRequestRateLimiter(ConcurrentLimitRule rule) {
        this.rule = rule;
        this.expiringKeyMap = ExpiringMap.builder().expiration(rule.getTimeoutMillis(), TimeUnit.MILLISECONDS).expirationPolicy(ExpirationPolicy.ACCESSED).build();
    }

    @Override
    public Baton acquire(String key) {
        return this.acquire(key, 1);
    }

    @Override
    public Baton acquire(String key, int weight) {
        Semaphore semaphore = this.expiringKeyMap.computeIfAbsent(key, s -> new Semaphore(this.rule.getConcurrentLimit(), false));
        if (semaphore.tryAcquire(weight)) {
            return new InMemoryBaton(semaphore, weight);
        }
        return new InMemoryBaton(weight);
    }

    private static class InMemoryBaton
    implements Baton {
        private final Semaphore semaphore;
        private final int weight;
        private boolean acquired;

        InMemoryBaton(Semaphore semaphore, int weight) {
            this.semaphore = semaphore;
            this.weight = weight;
            this.acquired = true;
        }

        InMemoryBaton(int weight) {
            this.semaphore = null;
            this.weight = weight;
        }

        @Override
        public void release() {
            if (this.semaphore == null) {
                throw new IllegalStateException();
            }
            this.semaphore.release(this.weight);
        }

        @Override
        public boolean hasAcquired() {
            return this.acquired;
        }

        @Override
        public <T> Optional<T> get(Supplier<T> action) {
            if (!this.acquired) {
                return Optional.empty();
            }
            try {
                Optional<T> optional = Optional.of(action.get());
                return optional;
            }
            finally {
                this.release();
                this.acquired = false;
            }
        }

        @Override
        public void doAction(Runnable action) {
            if (!this.acquired) {
                return;
            }
            try {
                action.run();
            }
            finally {
                this.release();
                this.acquired = false;
            }
        }
    }
}

