/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.memory;

import java.time.Clock;
import org.apache.james.queue.api.DelayedManageableMailQueueContract;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.Mails;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.api.RawMailQueueItemDecoratorFactory;
import org.apache.james.queue.memory.MemoryMailQueueFactory;
import org.apache.mailet.Mail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MemoryCacheableMailQueueTest
implements DelayedManageableMailQueueContract {
    private MemoryMailQueueFactory.MemoryCacheableMailQueue mailQueue;

    @BeforeEach
    public void setUp() {
        this.mailQueue = new MemoryMailQueueFactory.MemoryCacheableMailQueue(MailQueueName.of((String)"test"), (MailQueueItemDecoratorFactory)new RawMailQueueItemDecoratorFactory(), Clock.systemUTC());
    }

    @AfterEach
    public void tearDown() {
        this.mailQueue.close();
    }

    public MailQueue getMailQueue() {
        return this.mailQueue;
    }

    @Test
    public void getLastMailShouldReturnNullWhenNoMail() throws Exception {
        Assertions.assertThat((Object)this.mailQueue.getLastMail()).isNull();
    }

    @Test
    public void getLastMailShouldReturnSingleMail() throws Exception {
        this.mailQueue.enQueue((Mail)Mails.defaultMail().name("name").build());
        Assertions.assertThat((String)this.mailQueue.getLastMail().getName()).isEqualTo("name");
    }

    @Test
    public void getLastMailShouldReturnLastEnqueuedMail() throws Exception {
        this.mailQueue.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.mailQueue.enQueue((Mail)Mails.defaultMail().name("name2").build());
        Assertions.assertThat((String)this.mailQueue.getLastMail().getName()).isEqualTo("name2");
    }

    @Test
    public void getLastMailShouldNotAlterMailQueueState() throws Exception {
        this.mailQueue.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.mailQueue.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.mailQueue.getLastMail();
        Assertions.assertThat((String)this.mailQueue.getLastMail().getName()).isEqualTo("name2");
    }

    public ManageableMailQueue getManageableMailQueue() {
        return this.mailQueue;
    }
}

