/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.library;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.library.AbstractMailQueueFactory;
import org.apache.james.queue.library.MailQueueManagement;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class AbstractMailQueueFactoryTest {
    private static final MailQueueName QUEUE_1 = MailQueueName.of((String)"queue1");
    private static final MailQueueName QUEUE_2 = MailQueueName.of((String)"queue2");
    private static final MailQueueName QUEUE_3 = MailQueueName.of((String)"queue3");
    private AbstractMailQueueFactory<?> abstractMailQueueFactory;
    private MBeanServer mBeanServer;

    @BeforeEach
    void setUp() {
        this.mBeanServer = (MBeanServer)Mockito.mock(MBeanServer.class);
        this.abstractMailQueueFactory = new AbstractMailQueueFactory<ManageableMailQueue>(){

            protected ManageableMailQueue createCacheableMailQueue(MailQueueName name) {
                return (ManageableMailQueue)Mockito.mock(ManageableMailQueue.class);
            }
        };
        this.abstractMailQueueFactory.setMbeanServer(this.mBeanServer);
    }

    @Test
    void destroyShouldRegisterManageableQueues() throws Exception {
        this.abstractMailQueueFactory.createQueue(QUEUE_1);
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).registerMBean(ArgumentMatchers.any(MailQueueManagement.class), (ObjectName)ArgumentMatchers.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=" + QUEUE_1.asString())));
    }

    @Test
    void destroyShouldUnregisterAllRegisterQueue() throws Exception {
        this.abstractMailQueueFactory.createQueue(QUEUE_1);
        this.abstractMailQueueFactory.createQueue(QUEUE_2);
        this.abstractMailQueueFactory.createQueue(QUEUE_3);
        this.abstractMailQueueFactory.destroy();
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)ArgumentMatchers.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=" + QUEUE_1.asString())));
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)ArgumentMatchers.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=" + QUEUE_2.asString())));
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)ArgumentMatchers.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=" + QUEUE_3.asString())));
    }

    @Test
    void unregisterMBeanShouldWork() throws Exception {
        this.abstractMailQueueFactory.createQueue(QUEUE_1);
        this.abstractMailQueueFactory.unregisterMBean("org.apache.james:type=component,name=queue,queue=" + QUEUE_1.asString());
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)ArgumentMatchers.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=" + QUEUE_1.asString())));
    }

    @Test
    void destroyShouldNotBeStoppedByExceptions() throws Exception {
        this.abstractMailQueueFactory.createQueue(QUEUE_1);
        this.abstractMailQueueFactory.createQueue(QUEUE_2);
        this.abstractMailQueueFactory.createQueue(QUEUE_3);
        ((MBeanServer)Mockito.doThrow(InstanceNotFoundException.class).doNothing().when((Object)this.mBeanServer)).unregisterMBean(new ObjectName("org.apache.james:type=component,name=queue,queue=" + QUEUE_1.asString()));
        this.abstractMailQueueFactory.destroy();
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)ArgumentMatchers.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=" + QUEUE_1.asString())));
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)ArgumentMatchers.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=" + QUEUE_2.asString())));
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)ArgumentMatchers.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=" + QUEUE_3.asString())));
    }
}

