/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.jms;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.NoopGaugeRegistry;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueFactoryContract;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.api.ManageableMailQueueFactoryContract;
import org.apache.james.queue.api.RawMailQueueItemDecoratorFactory;
import org.apache.james.queue.jms.BrokerExtension;
import org.apache.james.queue.jms.JMSMailQueueFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={BrokerExtension.class})
public class JMSCacheableMailQueueFactoryTest
implements MailQueueFactoryContract<ManageableMailQueue>,
ManageableMailQueueFactoryContract {
    private JMSMailQueueFactory mailQueueFactory;

    @BeforeEach
    void setUp(BrokerService broker) {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost?create=false");
        RawMailQueueItemDecoratorFactory mailQueueItemDecoratorFactory = new RawMailQueueItemDecoratorFactory();
        RecordingMetricFactory metricFactory = new RecordingMetricFactory();
        NoopGaugeRegistry gaugeRegistry = new NoopGaugeRegistry();
        this.mailQueueFactory = new JMSMailQueueFactory((ConnectionFactory)connectionFactory, (MailQueueItemDecoratorFactory)mailQueueItemDecoratorFactory, (MetricFactory)metricFactory, (GaugeRegistry)gaugeRegistry);
        this.mailQueueFactory.setUseJMX(false);
    }

    @AfterEach
    void tearDown() {
        this.mailQueueFactory.destroy();
    }

    public MailQueueFactory<ManageableMailQueue> getMailQueueFactory() {
        return this.mailQueueFactory;
    }
}

