/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.jms;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.plugin.StatisticsBrokerPlugin;
import org.apache.commons.text.RandomStringGenerator;
import org.apache.james.queue.api.MailQueueName;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class BrokerExtension
implements ParameterResolver,
BeforeAllCallback,
AfterAllCallback {
    public static final String STATISTICS = "Statistics";
    private final BrokerService broker = new BrokerService();

    public static MailQueueName generateRandomQueueName(BrokerService broker) {
        String queueName = new RandomStringGenerator.Builder().withinRange(97, 122).build().generate(10);
        BrokerExtension.enablePrioritySupport(broker, queueName);
        return MailQueueName.of((String)queueName);
    }

    private static void enablePrioritySupport(BrokerService aBroker, String queueName) {
        PolicyMap pMap = new PolicyMap();
        PolicyEntry entry = new PolicyEntry();
        entry.setPrioritizedMessages(true);
        entry.setQueue(queueName);
        pMap.setPolicyEntries((List)ImmutableList.of((Object)entry));
        aBroker.setDestinationPolicy(pMap);
    }

    public BrokerExtension() throws Exception {
        this.broker.setPersistent(false);
        this.broker.setUseJmx(false);
        this.broker.addConnector("tcp://127.0.0.1:61616");
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        if (context.getTags().contains(STATISTICS)) {
            this.enableStatistics(this.broker);
        }
        this.broker.start();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.broker.stop();
    }

    private void enableStatistics(BrokerService broker) {
        broker.setPlugins(new BrokerPlugin[]{new StatisticsBrokerPlugin()});
        broker.setEnableStatistics(true);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == BrokerService.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.broker;
    }
}

