/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.library;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.library.AbstractMailQueueFactory;
import org.apache.james.queue.library.MailQueueManagement;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class AbstractMailQueueFactoryTest {
    private static final String QUEUE_1 = "queue1";
    private static final String QUEUE_2 = "queue2";
    private static final String QUEUE_3 = "queue3";
    private AbstractMailQueueFactory<?> abstractMailQueueFactory;
    private MBeanServer mBeanServer;

    @Before
    public void setUp() {
        this.mBeanServer = (MBeanServer)Mockito.mock(MBeanServer.class);
        this.abstractMailQueueFactory = new AbstractMailQueueFactory<ManageableMailQueue>(){

            protected ManageableMailQueue createMailQueue(String name) {
                return (ManageableMailQueue)Mockito.mock(ManageableMailQueue.class);
            }
        };
        this.abstractMailQueueFactory.setMbeanServer(this.mBeanServer);
    }

    @Test
    public void destroyShouldRegisterManageableQueues() throws Exception {
        this.abstractMailQueueFactory.createQueue(QUEUE_1);
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).registerMBean(ArgumentMatchers.any(MailQueueManagement.class), (ObjectName)ArgumentMatchers.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=queue1")));
    }

    @Test
    public void destroyShouldUnregisterAllRegisterQueue() throws Exception {
        this.abstractMailQueueFactory.createQueue(QUEUE_1);
        this.abstractMailQueueFactory.createQueue(QUEUE_2);
        this.abstractMailQueueFactory.createQueue(QUEUE_3);
        this.abstractMailQueueFactory.destroy();
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)ArgumentMatchers.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=queue1")));
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)ArgumentMatchers.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=queue2")));
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)ArgumentMatchers.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=queue3")));
    }

    @Test
    public void unregisterMBeanShouldWork() throws Exception {
        this.abstractMailQueueFactory.createQueue(QUEUE_1);
        this.abstractMailQueueFactory.unregisterMBean("org.apache.james:type=component,name=queue,queue=queue1");
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)ArgumentMatchers.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=queue1")));
    }

    @Test
    public void destroyShouldNotBeStoppedByExceptions() throws Exception {
        this.abstractMailQueueFactory.createQueue(QUEUE_1);
        this.abstractMailQueueFactory.createQueue(QUEUE_2);
        this.abstractMailQueueFactory.createQueue(QUEUE_3);
        ((MBeanServer)Mockito.doThrow(InstanceNotFoundException.class).doNothing().when((Object)this.mBeanServer)).unregisterMBean(new ObjectName("org.apache.james:type=component,name=queue,queue=queue1"));
        this.abstractMailQueueFactory.destroy();
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)ArgumentMatchers.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=queue1")));
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)ArgumentMatchers.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=queue2")));
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)ArgumentMatchers.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=queue3")));
    }
}

