/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.jms;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.api.DelayedManageableMailQueueContract;
import org.apache.james.queue.api.DelayedPriorityMailQueueContract;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.MailQueueMetricContract;
import org.apache.james.queue.api.MailQueueMetricExtension;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.api.PriorityManageableMailQueueContract;
import org.apache.james.queue.api.RawMailQueueItemDecoratorFactory;
import org.apache.james.queue.jms.BrokerExtension;
import org.apache.james.queue.jms.JMSMailQueue;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={BrokerExtension.class})
public class JMSMailQueueTest
implements DelayedManageableMailQueueContract,
PriorityManageableMailQueueContract,
DelayedPriorityMailQueueContract,
MailQueueMetricContract {
    private JMSMailQueue mailQueue;

    @BeforeEach
    void setUp(BrokerService broker, MailQueueMetricExtension.MailQueueMetricTestSystem metricTestSystem) {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost?create=false");
        RawMailQueueItemDecoratorFactory mailQueueItemDecoratorFactory = new RawMailQueueItemDecoratorFactory();
        MetricFactory metricFactory = metricTestSystem.getSpyMetricFactory();
        GaugeRegistry gaugeRegistry = metricTestSystem.getSpyGaugeRegistry();
        String queueName = BrokerExtension.generateRandomQueueName(broker);
        this.mailQueue = new JMSMailQueue((ConnectionFactory)connectionFactory, (MailQueueItemDecoratorFactory)mailQueueItemDecoratorFactory, queueName, metricFactory, gaugeRegistry);
    }

    @AfterEach
    void tearDown() {
        this.mailQueue.dispose();
    }

    public MailQueue getMailQueue() {
        return this.mailQueue;
    }

    @Test
    public ManageableMailQueue getManageableMailQueue() {
        return this.mailQueue;
    }

    @Disabled(value="JAMES-2295 Disabled as test was dead-locking")
    public void dequeueCanBeChainedBeforeAck() {
    }

    @Test
    @Disabled(value="JAMES-2295 Disabled as test was dead-locking")
    public void dequeueCouldBeInterleavingWithOutOfOrderAck() {
    }

    @Test
    @Disabled(value="JAMES-2308 Flushing JMS mail queue randomly re-order themRandom test failing around 1% of the time")
    public void flushShouldPreserveBrowseOrder() {
    }

    @Test
    @Disabled(value="JAMES-2312 JMS clear mailqueue can ommit some messagesRandom test failing around 1% of the time")
    public void clearShouldRemoveAllElements() {
    }

    @Test
    @Disabled(value="JAMES-2544 Mixing concurrent operations might lead to a missing file and errors upon dequeue")
    public void concurrentEnqueueDequeueShouldNotFail() {
    }

    @Test
    @Disabled(value="JAMES-2544 Mixing concurrent operations might lead to a missing file and errors upon dequeue")
    public void concurrentEnqueueDequeueWithAckNackShouldNotFail() {
    }
}

