/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.library;

import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.library.AbstractMailQueueFactory;
import org.apache.mailet.Mail;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractMailQueueFactoryTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMailQueueFactoryTest.class);
    private static final String QUEUE_1 = "queue1";
    private static final String QUEUE_2 = "queue2";
    private static final String QUEUE_3 = "queue3";
    private AbstractMailQueueFactory abstractMailQueueFactory;
    private MBeanServer mBeanServer;

    @Before
    public void setUp() {
        this.mBeanServer = (MBeanServer)Mockito.mock(MBeanServer.class);
        this.abstractMailQueueFactory = new AbstractMailQueueFactory(){

            protected MailQueue createMailQueue(String name) {
                return new ManageableMailQueue(){

                    public void enQueue(Mail mail, long delay, TimeUnit unit) throws MailQueue.MailQueueException {
                    }

                    public void enQueue(Mail mail) throws MailQueue.MailQueueException {
                    }

                    public MailQueue.MailQueueItem deQueue() throws MailQueue.MailQueueException {
                        return null;
                    }

                    public long getSize() throws MailQueue.MailQueueException {
                        return 0L;
                    }

                    public long flush() throws MailQueue.MailQueueException {
                        return 0L;
                    }

                    public long clear() throws MailQueue.MailQueueException {
                        return 0L;
                    }

                    public long remove(ManageableMailQueue.Type type, String value) throws MailQueue.MailQueueException {
                        return 0L;
                    }

                    public ManageableMailQueue.MailQueueIterator browse() throws MailQueue.MailQueueException {
                        return null;
                    }
                };
            }
        };
        this.abstractMailQueueFactory.setMbeanServer(this.mBeanServer);
        this.abstractMailQueueFactory.setLog(LOGGER);
    }

    @Test
    public void destroyShouldRegisterManageableQueues() throws Exception {
        this.abstractMailQueueFactory.getQueue(QUEUE_1);
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).registerMBean(Mockito.any(MailQueue.class), (ObjectName)Mockito.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=queue1")));
    }

    @Test
    public void destroyShouldUnregisterAllRegisterQueue() throws Exception {
        this.abstractMailQueueFactory.getQueue(QUEUE_1);
        this.abstractMailQueueFactory.getQueue(QUEUE_2);
        this.abstractMailQueueFactory.getQueue(QUEUE_3);
        this.abstractMailQueueFactory.destroy();
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)Mockito.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=queue1")));
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)Mockito.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=queue2")));
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)Mockito.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=queue3")));
    }

    @Test
    public void unregisterMBeanShouldWork() throws Exception {
        this.abstractMailQueueFactory.getQueue(QUEUE_1);
        this.abstractMailQueueFactory.unregisterMBean("org.apache.james:type=component,name=queue,queue=queue1");
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)Mockito.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=queue1")));
    }

    @Test
    public void destroyShouldNotBeStoppedByExceptions() throws Exception {
        this.abstractMailQueueFactory.getQueue(QUEUE_1);
        this.abstractMailQueueFactory.getQueue(QUEUE_2);
        this.abstractMailQueueFactory.getQueue(QUEUE_3);
        ((MBeanServer)Mockito.doThrow(InstanceNotFoundException.class).doNothing().when((Object)this.mBeanServer)).unregisterMBean(new ObjectName("org.apache.james:type=component,name=queue,queue=queue1"));
        this.abstractMailQueueFactory.destroy();
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)Mockito.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=queue1")));
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)Mockito.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=queue2")));
        ((MBeanServer)Mockito.verify((Object)this.mBeanServer)).unregisterMBean((ObjectName)Mockito.eq((Object)new ObjectName("org.apache.james:type=component,name=queue,queue=queue3")));
    }
}

