/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.jms;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.jms.ConnectionFactory;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.james.core.MailImpl;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.NoopMetricFactory;
import org.apache.james.protocols.smtp.MailAddressException;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.api.RawMailQueueItemDecoratorFactory;
import org.apache.james.queue.jms.JMSMailQueue;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJMSMailQueueTest {
    protected static final String QUEUE_NAME = "test";

    public abstract JMSMailQueue getQueue();

    public abstract void setQueue(JMSMailQueue var1);

    protected ActiveMQConnectionFactory createConnectionFactory() {
        return new ActiveMQConnectionFactory("vm://localhost?create=false");
    }

    protected JMSMailQueue createQueue(ConnectionFactory factory, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory, String queueName) {
        Logger log = LoggerFactory.getLogger(AbstractJMSMailQueueTest.class);
        return new JMSMailQueue(factory, mailQueueItemDecoratorFactory, queueName, (MetricFactory)new NoopMetricFactory(), log);
    }

    @Before
    public void setUp() throws Exception {
        ActiveMQConnectionFactory connectionFactory = this.createConnectionFactory();
        this.setQueue(this.createQueue((ConnectionFactory)connectionFactory, (MailQueueItemDecoratorFactory)new RawMailQueueItemDecoratorFactory(), QUEUE_NAME));
    }

    @Test
    public void testFIFO() throws MessagingException, InterruptedException, IOException, MailAddressException {
        JMSMailQueue queue = this.getQueue();
        Assert.assertEquals((long)0L, (long)queue.getSize());
        MailImpl mail = this.createMail();
        MailImpl mail2 = this.createMail();
        queue.enQueue((Mail)mail);
        queue.enQueue((Mail)mail2);
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)2L, (long)queue.getSize());
        MailQueue.MailQueueItem item = queue.deQueue();
        this.checkMail((Mail)mail, item.getMail());
        item.done(false);
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)2L, (long)queue.getSize());
        MailQueue.MailQueueItem item2 = queue.deQueue();
        this.checkMail((Mail)mail, item2.getMail());
        item2.done(true);
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)1L, (long)queue.getSize());
        MailQueue.MailQueueItem item3 = queue.deQueue();
        this.checkMail((Mail)mail2, item3.getMail());
        item3.done(true);
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)0L, (long)queue.getSize());
    }

    @Test
    public void testDelayedDeQueue() throws MessagingException, InterruptedException, IOException, MailAddressException {
        JMSMailQueue queue = this.getQueue();
        Assert.assertEquals((long)0L, (long)queue.getSize());
        MailImpl mail = this.createMail();
        MailImpl mail2 = this.createMail();
        long enqueueTime = System.currentTimeMillis();
        queue.enQueue((Mail)mail, 3L, TimeUnit.SECONDS);
        queue.enQueue((Mail)mail2);
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)2L, (long)queue.getSize());
        MailQueue.MailQueueItem item = queue.deQueue();
        this.checkMail((Mail)mail2, item.getMail());
        item.done(true);
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)1L, (long)queue.getSize());
        MailQueue.MailQueueItem item2 = queue.deQueue();
        long dequeueTime = System.currentTimeMillis() - enqueueTime;
        this.checkMail((Mail)mail, item2.getMail());
        item2.done(true);
        Assert.assertTrue((dequeueTime >= 2000L ? 1 : 0) != 0);
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)0L, (long)queue.getSize());
    }

    @Test
    public void testFlush() throws MessagingException, InterruptedException, IOException, MailAddressException {
        final JMSMailQueue queue = this.getQueue();
        Assert.assertEquals((long)0L, (long)queue.getSize());
        MailImpl mail = this.createMail();
        long enqueueTime = System.currentTimeMillis();
        queue.enQueue((Mail)mail, 30L, TimeUnit.SECONDS);
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)1L, (long)queue.getSize());
        Thread flushThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TimeUnit.MILLISECONDS.sleep(4000L);
                    Assert.assertEquals((long)1L, (long)queue.flush());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        flushThread.start();
        MailQueue.MailQueueItem item = queue.deQueue();
        this.checkMail((Mail)mail, item.getMail());
        item.done(true);
        long dequeueTime = System.currentTimeMillis() - enqueueTime;
        Assert.assertEquals((long)0L, (long)queue.getSize());
        Assert.assertTrue((dequeueTime < 30000L ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveWithRecipient() throws MessagingException, InterruptedException, MailAddressException {
        JMSMailQueue queue = this.getQueue();
        Assert.assertEquals((long)0L, (long)queue.getSize());
        MailImpl mail = this.createMail();
        mail.setRecipients(Arrays.asList(new MailAddress("remove@me1")));
        MailImpl mail2 = this.createMail();
        mail2.setRecipients(Arrays.asList(new MailAddress("remove@me2")));
        queue.enQueue((Mail)mail);
        queue.enQueue((Mail)mail2);
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)2L, (long)queue.getSize());
        Assert.assertEquals((long)1L, (long)queue.remove(ManageableMailQueue.Type.Recipient, "remove@me1"));
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)1L, (long)queue.getSize());
        Assert.assertEquals((long)1L, (long)queue.remove(ManageableMailQueue.Type.Recipient, "remove@me2"));
        Assert.assertEquals((long)0L, (long)queue.getSize());
    }

    @Test
    public void testRemoveWithSender() throws MessagingException, InterruptedException, MailAddressException {
        JMSMailQueue queue = this.getQueue();
        Assert.assertEquals((long)0L, (long)queue.getSize());
        MailImpl mail = this.createMail();
        mail.setSender(new MailAddress("remove@me1"));
        MailImpl mail2 = this.createMail();
        mail2.setSender(new MailAddress("remove@me2"));
        queue.enQueue((Mail)mail);
        queue.enQueue((Mail)mail2);
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)2L, (long)queue.getSize());
        Assert.assertEquals((long)1L, (long)queue.remove(ManageableMailQueue.Type.Sender, "remove@me1"));
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)1L, (long)queue.getSize());
        Assert.assertEquals((long)1L, (long)queue.remove(ManageableMailQueue.Type.Sender, "remove@me2"));
        Assert.assertEquals((long)0L, (long)queue.getSize());
    }

    @Test
    public void testRemoveWithName() throws MessagingException, InterruptedException, MailAddressException {
        JMSMailQueue queue = this.getQueue();
        Assert.assertEquals((long)0L, (long)queue.getSize());
        MailImpl mail = this.createMail();
        mail.setName("remove@me1");
        MailImpl mail2 = this.createMail();
        mail2.setName("remove@me2");
        queue.enQueue((Mail)mail);
        queue.enQueue((Mail)mail2);
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)2L, (long)queue.getSize());
        Assert.assertEquals((long)1L, (long)queue.remove(ManageableMailQueue.Type.Name, "remove@me1"));
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)1L, (long)queue.getSize());
        Assert.assertEquals((long)1L, (long)queue.remove(ManageableMailQueue.Type.Name, "remove@me2"));
        Assert.assertEquals((long)0L, (long)queue.getSize());
    }

    protected MailImpl createMail() throws MessagingException {
        MailImpl mail = new MailImpl();
        mail.setName("" + System.currentTimeMillis());
        mail.setAttribute("test1", (Serializable)Long.valueOf(System.currentTimeMillis()));
        mail.setErrorMessage(UUID.randomUUID().toString());
        mail.setLastUpdated(new Date());
        mail.setRecipients(Arrays.asList(new MailAddress("test@test"), new MailAddress("test@test2")));
        mail.setSender(new MailAddress("sender@senderdomain"));
        MimeMessage message = new MimeMessage(Session.getInstance((Properties)new Properties()));
        message.setText(QUEUE_NAME);
        message.setHeader("testheader", "testvalie");
        message.saveChanges();
        mail.setMessage(message);
        return mail;
    }

    protected void checkMail(Mail enqueuedMail, Mail dequeuedMail) throws MessagingException, IOException {
        Assert.assertEquals((Object)enqueuedMail.getErrorMessage(), (Object)dequeuedMail.getErrorMessage());
        Assert.assertEquals((long)enqueuedMail.getMessageSize(), (long)dequeuedMail.getMessageSize());
        Assert.assertEquals((Object)enqueuedMail.getName(), (Object)dequeuedMail.getName());
        Assert.assertEquals((Object)enqueuedMail.getRemoteAddr(), (Object)dequeuedMail.getRemoteAddr());
        Assert.assertEquals((Object)enqueuedMail.getState(), (Object)dequeuedMail.getState());
        Assert.assertEquals((Object)enqueuedMail.getLastUpdated(), (Object)dequeuedMail.getLastUpdated());
        Assert.assertEquals((Object)enqueuedMail.getRemoteHost(), (Object)dequeuedMail.getRemoteHost());
        Assert.assertEquals((Object)enqueuedMail.getSender(), (Object)dequeuedMail.getSender());
        Assert.assertEquals((long)enqueuedMail.getRecipients().size(), (long)dequeuedMail.getRecipients().size());
        Iterator attributes = enqueuedMail.getAttributeNames();
        while (attributes.hasNext()) {
            String name = (String)attributes.next();
            Assert.assertNotNull((Object)dequeuedMail.getAttribute(name));
        }
        MimeMessage enqueuedMsg = enqueuedMail.getMessage();
        MimeMessage dequeuedMsg = dequeuedMail.getMessage();
        Enumeration enQueuedHeaders = enqueuedMsg.getAllHeaderLines();
        Enumeration deQueuedHeaders = dequeuedMsg.getAllHeaderLines();
        while (enQueuedHeaders.hasMoreElements()) {
            Assert.assertEquals(enQueuedHeaders.nextElement(), deQueuedHeaders.nextElement());
        }
        Assert.assertFalse((boolean)deQueuedHeaders.hasMoreElements());
        Assert.assertEquals((Object)enqueuedMsg.getContent(), (Object)dequeuedMsg.getContent());
    }

    @Test
    public void testPrioritySupport() throws InterruptedException, MessagingException, IOException, MailAddressException {
        JMSMailQueue queue = this.getQueue();
        Assert.assertEquals((long)0L, (long)queue.getSize());
        MailImpl mail = this.createMail();
        MailImpl mail2 = this.createMail();
        mail2.setAttribute("MAIL_PRIORITY", (Serializable)Integer.valueOf(9));
        queue.enQueue((Mail)mail);
        queue.enQueue((Mail)mail2);
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)2L, (long)queue.getSize());
        Assert.assertEquals((long)2L, (long)queue.getSize());
        MailQueue.MailQueueItem item2 = queue.deQueue();
        this.checkMail((Mail)mail2, item2.getMail());
        item2.done(true);
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)1L, (long)queue.getSize());
        MailQueue.MailQueueItem item3 = queue.deQueue();
        this.checkMail((Mail)mail, item3.getMail());
        item3.done(true);
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)0L, (long)queue.getSize());
    }

    @Test
    public void testBrowse() throws MessagingException, InterruptedException, IOException, MailAddressException {
        JMSMailQueue queue = this.getQueue();
        Assert.assertEquals((long)0L, (long)queue.getSize());
        MailImpl mail = this.createMail();
        MailImpl mail2 = this.createMail();
        queue.enQueue((Mail)mail);
        queue.enQueue((Mail)mail2);
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)2L, (long)queue.getSize());
        ManageableMailQueue.MailQueueIterator it = queue.browse();
        this.checkMail((Mail)mail, ((ManageableMailQueue.MailQueueItemView)it.next()).getMail());
        this.checkMail((Mail)mail2, ((ManageableMailQueue.MailQueueItemView)it.next()).getMail());
        Assert.assertFalse((boolean)it.hasNext());
        it.close();
        Assert.assertEquals((long)2L, (long)queue.getSize());
        MailQueue.MailQueueItem item2 = queue.deQueue();
        this.checkMail((Mail)mail, item2.getMail());
        item2.done(true);
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertEquals((long)1L, (long)queue.getSize());
        it = queue.browse();
        this.checkMail((Mail)mail2, ((ManageableMailQueue.MailQueueItemView)it.next()).getMail());
        Assert.assertFalse((boolean)it.hasNext());
        it.close();
    }
}

