/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.jms;

import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.jms.JMSMailQueue;
import org.apache.james.queue.library.AbstractMailQueueFactory;

public class JMSMailQueueFactory
extends AbstractMailQueueFactory {
    protected final ConnectionFactory connectionFactory;
    protected final MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory;
    protected final MetricFactory metricFactory;

    @Inject
    public JMSMailQueueFactory(ConnectionFactory connectionFactory, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory, MetricFactory metricFactory) {
        this.connectionFactory = connectionFactory;
        this.mailQueueItemDecoratorFactory = mailQueueItemDecoratorFactory;
        this.metricFactory = metricFactory;
    }

    @Override
    protected MailQueue createMailQueue(String name) {
        return new JMSMailQueue(this.connectionFactory, this.mailQueueItemDecoratorFactory, name, this.metricFactory, this.log);
    }
}

