/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.jms;

import com.google.common.base.Throwables;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailImpl;
import org.apache.james.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.core.MimeMessageSource;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.queue.api.MailPrioritySupport;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.jms.JMSMailQueueItem;
import org.apache.james.queue.jms.JMSSupport;
import org.apache.james.queue.jms.MimeMessageObjectMessageSource;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.slf4j.Logger;

public class JMSMailQueue
implements ManageableMailQueue,
JMSSupport,
MailPrioritySupport,
Disposable {
    protected final String queueName;
    protected final Connection connection;
    protected final MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory;
    protected final Metric enqueuedMailsMetric;
    protected final Metric mailQueueSize;
    protected final MetricFactory metricFactory;
    protected final Logger logger;
    public static final String FORCE_DELIVERY = "FORCE_DELIVERY";

    public JMSMailQueue(ConnectionFactory connectionFactory, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory, String queueName, MetricFactory metricFactory, Logger logger) {
        try {
            this.connection = connectionFactory.createConnection();
            this.connection.start();
        }
        catch (JMSException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.mailQueueItemDecoratorFactory = mailQueueItemDecoratorFactory;
        this.queueName = queueName;
        this.metricFactory = metricFactory;
        this.enqueuedMailsMetric = metricFactory.generate("enqueuedMail:" + queueName);
        this.mailQueueSize = metricFactory.generate("mailQueueSize:" + queueName);
        this.logger = logger;
    }

    public MailQueue.MailQueueItem deQueue() throws MailQueue.MailQueueException {
        Session session = null;
        MessageConsumer consumer = null;
        while (true) {
            TimeMetric timeMetric = this.metricFactory.timer("dequeueTime:" + this.queueName);
            try {
                session = this.connection.createSession(true, 0);
                Queue queue = session.createQueue(this.queueName);
                consumer = session.createConsumer((Destination)queue, this.getMessageSelector());
                Message message = consumer.receive(10000L);
                if (message != null) {
                    this.mailQueueSize.decrement();
                    MailQueue.MailQueueItem mailQueueItem = this.createMailQueueItem(this.connection, session, consumer, message);
                    return mailQueueItem;
                }
                session.commit();
                if (consumer != null) {
                    try {
                        consumer.close();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
                try {
                    if (session == null) continue;
                    session.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                continue;
            }
            catch (Exception e) {
                if (session != null) {
                    try {
                        session.rollback();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
                if (consumer != null) {
                    try {
                        consumer.close();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
                try {
                    if (session != null) {
                        session.close();
                    }
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                throw new MailQueue.MailQueueException("Unable to dequeue next message", e);
            }
            finally {
                timeMetric.stopAndPublish();
                continue;
            }
            break;
        }
    }

    public void enQueue(Mail mail, long delay, TimeUnit unit) throws MailQueue.MailQueueException {
        TimeMetric timeMetric = this.metricFactory.timer("enqueueMailTime:" + this.queueName);
        Session session = null;
        long mydelay = 0L;
        if (delay > 0L) {
            mydelay = TimeUnit.MILLISECONDS.convert(delay, unit);
        }
        try {
            session = this.connection.createSession(false, 1);
            int msgPrio = 5;
            Serializable prio = mail.getAttribute("MAIL_PRIORITY");
            if (prio instanceof Integer) {
                msgPrio = (Integer)prio;
            }
            Map<String, Object> props = this.getJMSProperties(mail, mydelay);
            this.produceMail(session, props, msgPrio, mail);
            this.enqueuedMailsMetric.increment();
            this.mailQueueSize.increment();
        }
        catch (Exception e) {
            if (session != null) {
                try {
                    session.rollback();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            throw new MailQueue.MailQueueException("Unable to enqueue mail " + mail, e);
        }
        finally {
            timeMetric.stopAndPublish();
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (JMSException jMSException) {}
        }
    }

    public void enQueue(Mail mail) throws MailQueue.MailQueueException {
        this.enQueue(mail, -1L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void produceMail(Session session, Map<String, Object> props, int msgPrio, Mail mail) throws JMSException, MessagingException, IOException {
        MessageProducer producer = null;
        try {
            Queue queue = session.createQueue(this.queueName);
            producer = session.createProducer((Destination)queue);
            ObjectMessage message = session.createObjectMessage();
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                message.setObjectProperty(entry.getKey(), entry.getValue());
            }
            long size = mail.getMessageSize();
            ByteArrayOutputStream out = size > -1L ? new ByteArrayOutputStream((int)size) : new ByteArrayOutputStream();
            mail.getMessage().writeTo((OutputStream)out);
            message.setObject((Serializable)out.toByteArray());
            producer.send((Message)message, 2, msgPrio, 0L);
        }
        finally {
            try {
                if (producer != null) {
                    producer.close();
                }
            }
            catch (JMSException jMSException) {}
        }
    }

    protected Map<String, Object> getJMSProperties(Mail mail, long delayInMillis) throws MessagingException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        long nextDelivery = -1L;
        if (delayInMillis > 0L) {
            nextDelivery = System.currentTimeMillis() + delayInMillis;
        }
        props.put("JAMES_NEXT_DELIVERY", nextDelivery);
        props.put("JAMES_MAIL_ERROR_MESSAGE", mail.getErrorMessage());
        props.put("JAMES_MAIL_LAST_UPDATED", mail.getLastUpdated().getTime());
        props.put("JAMES_MAIL_MESSAGE_SIZE", mail.getMessageSize());
        props.put("JAMES_MAIL_NAME", mail.getName());
        StringBuilder recipientsBuilder = new StringBuilder();
        Iterator recipients = mail.getRecipients().iterator();
        while (recipients.hasNext()) {
            String recipient = ((MailAddress)recipients.next()).toString();
            recipientsBuilder.append(recipient.trim());
            if (!recipients.hasNext()) continue;
            recipientsBuilder.append(";");
        }
        props.put("JAMES_MAIL_RECIPIENTS", recipientsBuilder.toString());
        props.put("JAMES_MAIL_REMOTEADDR", mail.getRemoteAddr());
        props.put("JAMES_MAIL_REMOTEHOST", mail.getRemoteHost());
        MailAddress s = mail.getSender();
        String sender = s == null ? "" : mail.getSender().toString();
        StringBuilder attrsBuilder = new StringBuilder();
        Iterator attrs = mail.getAttributeNames();
        while (attrs.hasNext()) {
            String attrName = (String)attrs.next();
            attrsBuilder.append(attrName);
            Object value = this.convertAttributeValue(mail.getAttribute(attrName));
            props.put(attrName, value);
            if (!attrs.hasNext()) continue;
            attrsBuilder.append(";");
        }
        props.put("JAMES_MAIL_ATTRIBUTE_NAMES", attrsBuilder.toString());
        props.put("JAMES_MAIL_SENDER", sender);
        props.put("JAMES_MAIL_STATE", mail.getState());
        return props;
    }

    protected final Mail createMail(Message message) throws MessagingException, JMSException {
        MailImpl mail = new MailImpl();
        this.populateMail(message, mail);
        this.populateMailMimeMessage(message, (Mail)mail);
        return mail;
    }

    protected void populateMailMimeMessage(Message message, Mail mail) throws MessagingException, JMSException {
        if (!(message instanceof ObjectMessage)) {
            throw new MailQueue.MailQueueException("Not supported JMS Message received " + message);
        }
        mail.setMessage((MimeMessage)new MimeMessageCopyOnWriteProxy((MimeMessageSource)new MimeMessageObjectMessageSource((ObjectMessage)message)));
    }

    protected void populateMail(Message message, MailImpl mail) throws JMSException {
        mail.setErrorMessage(message.getStringProperty("JAMES_MAIL_ERROR_MESSAGE"));
        mail.setLastUpdated(new Date(message.getLongProperty("JAMES_MAIL_LAST_UPDATED")));
        mail.setName(message.getStringProperty("JAMES_MAIL_NAME"));
        ArrayList<MailAddress> rcpts = new ArrayList<MailAddress>();
        String recipients = message.getStringProperty("JAMES_MAIL_RECIPIENTS");
        StringTokenizer recipientTokenizer = new StringTokenizer(recipients, ";");
        while (recipientTokenizer.hasMoreTokens()) {
            String token = recipientTokenizer.nextToken();
            try {
                MailAddress rcpt = new MailAddress(token);
                rcpts.add(rcpt);
            }
            catch (AddressException e) {
                this.logger.error("Unable to parse the recipient address " + token + " for mail " + mail.getName() + ", so we ignore it", (Throwable)e);
            }
        }
        mail.setRecipients(rcpts);
        mail.setRemoteAddr(message.getStringProperty("JAMES_MAIL_REMOTEADDR"));
        mail.setRemoteHost(message.getStringProperty("JAMES_MAIL_REMOTEHOST"));
        String attributeNames = message.getStringProperty("JAMES_MAIL_ATTRIBUTE_NAMES");
        StringTokenizer namesTokenizer = new StringTokenizer(attributeNames, ";");
        while (namesTokenizer.hasMoreTokens()) {
            String name = namesTokenizer.nextToken();
            Object attrValue = message.getObjectProperty(name);
            if (attrValue == null) continue;
            if (attrValue instanceof Serializable) {
                mail.setAttribute(name, (Serializable)attrValue);
                continue;
            }
            this.logger.error("Not supported mail attribute " + name + " of type " + attrValue + " for mail " + mail.getName());
        }
        String sender = message.getStringProperty("JAMES_MAIL_SENDER");
        if (sender == null || sender.trim().length() <= 0) {
            mail.setSender(null);
        } else {
            try {
                mail.setSender(new MailAddress(sender));
            }
            catch (AddressException e) {
                this.logger.error("Unable to parse the sender address " + sender + " for mail " + mail.getName() + ", so we fallback to a null sender", (Throwable)e);
                mail.setSender(null);
            }
        }
        mail.setState(message.getStringProperty("JAMES_MAIL_STATE"));
    }

    protected Object convertAttributeValue(Object value) {
        if (value == null || value instanceof String || value instanceof Byte || value instanceof Long || value instanceof Double || value instanceof Boolean || value instanceof Integer || value instanceof Short || value instanceof Float) {
            return value;
        }
        return value.toString();
    }

    public String toString() {
        return "MailQueue:" + this.queueName;
    }

    protected MailQueue.MailQueueItem createMailQueueItem(Connection connection, Session session, MessageConsumer consumer, Message message) throws JMSException, MessagingException {
        Mail mail = this.createMail(message);
        JMSMailQueueItem jmsMailQueueItem = new JMSMailQueueItem(mail, connection, session, consumer);
        return this.mailQueueItemDecoratorFactory.decorate((MailQueue.MailQueueItem)jmsMailQueueItem);
    }

    protected String getMessageSelector() {
        return "JAMES_NEXT_DELIVERY <= " + System.currentTimeMillis() + " OR " + FORCE_DELIVERY + " = true";
    }

    public long getSize() throws MailQueue.MailQueueException {
        Session session = null;
        QueueBrowser browser = null;
        int size = 0;
        try {
            session = this.connection.createSession(false, 1);
            Queue queue = session.createQueue(this.queueName);
            browser = session.createBrowser(queue);
            Enumeration messages = browser.getEnumeration();
            while (messages.hasMoreElements()) {
                messages.nextElement();
                ++size;
            }
            long l = size;
            return l;
        }
        catch (Exception e) {
            this.logger.error("Unable to get size of queue " + this.queueName, (Throwable)e);
            throw new MailQueue.MailQueueException("Unable to get size of queue " + this.queueName, e);
        }
        finally {
            try {
                if (browser != null) {
                    browser.close();
                }
            }
            catch (JMSException jMSException) {}
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (JMSException jMSException) {}
        }
    }

    public long flush() throws MailQueue.MailQueueException {
        Session session = null;
        Message message = null;
        MessageConsumer consumer = null;
        MessageProducer producer = null;
        boolean first = true;
        long count = 0L;
        try {
            session = this.connection.createSession(true, 0);
            Queue queue = session.createQueue(this.queueName);
            consumer = session.createConsumer((Destination)queue);
            producer = session.createProducer((Destination)queue);
            while (first || message != null) {
                message = first ? consumer.receive(2000L) : consumer.receiveNoWait();
                first = false;
                if (message == null) continue;
                Message m = this.copy(session, message);
                m.setBooleanProperty(FORCE_DELIVERY, true);
                producer.send(m, message.getJMSDeliveryMode(), message.getJMSPriority(), message.getJMSExpiration());
                ++count;
            }
            session.commit();
            long l = count;
            return l;
        }
        catch (Exception e) {
            this.logger.error("Unable to flush mail", (Throwable)e);
            try {
                session.rollback();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            throw new MailQueue.MailQueueException("Unable to get size of queue " + this.queueName, e);
        }
        finally {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException jMSException) {}
            }
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException jMSException) {}
            }
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (JMSException jMSException) {}
        }
    }

    public long clear() throws MailQueue.MailQueueException {
        return this.count(this.removeWithSelector(null));
    }

    protected long count(List<Message> msgs) {
        if (msgs == null) {
            return -1L;
        }
        return msgs.size();
    }

    public List<Message> removeWithSelector(String selector) throws MailQueue.MailQueueException {
        Session session = null;
        Message message = null;
        MessageConsumer consumer = null;
        boolean first = true;
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            session = this.connection.createSession(true, 0);
            Queue queue = session.createQueue(this.queueName);
            consumer = session.createConsumer((Destination)queue, selector);
            while (first || message != null) {
                message = first ? consumer.receive(2000L) : consumer.receiveNoWait();
                first = false;
                if (message == null) continue;
                messages.add(message);
            }
            session.commit();
            ArrayList<Message> arrayList = messages;
            return arrayList;
        }
        catch (Exception e) {
            try {
                session.rollback();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            throw new MailQueue.MailQueueException("Unable to remove mails", e);
        }
        finally {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException jMSException) {}
            }
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (JMSException jMSException) {}
        }
    }

    protected Message copy(Session session, Message m) throws JMSException {
        ObjectMessage message = (ObjectMessage)m;
        ObjectMessage copy = session.createObjectMessage(message.getObject());
        Enumeration properties = message.getPropertyNames();
        while (properties.hasMoreElements()) {
            String name = (String)properties.nextElement();
            copy.setObjectProperty(name, message.getObjectProperty(name));
        }
        return copy;
    }

    public long remove(ManageableMailQueue.Type type, String value) throws MailQueue.MailQueueException {
        switch (type) {
            case Name: {
                return this.count(this.removeWithSelector("JAMES_MAIL_NAME = '" + value + "'"));
            }
            case Sender: {
                return this.count(this.removeWithSelector("JAMES_MAIL_SENDER = '" + value + "'"));
            }
            case Recipient: {
                return this.count(this.removeWithSelector("JAMES_MAIL_RECIPIENTS = '" + value + "' or " + "JAMES_MAIL_RECIPIENTS" + " = '%," + value + "' or " + "JAMES_MAIL_RECIPIENTS" + " = '%," + value + "%'"));
            }
        }
        return -1L;
    }

    public ManageableMailQueue.MailQueueIterator browse() throws MailQueue.MailQueueException {
        Session session = null;
        QueueBrowser browser = null;
        try {
            session = this.connection.createSession(false, 1);
            Queue queue = session.createQueue(this.queueName);
            browser = session.createBrowser(queue);
            final Enumeration messages = browser.getEnumeration();
            final Session mySession = session;
            final QueueBrowser myBrowser = browser;
            return new ManageableMailQueue.MailQueueIterator(){

                public void remove() {
                    throw new UnsupportedOperationException("Read-only");
                }

                public ManageableMailQueue.MailQueueItemView next() {
                    while (this.hasNext()) {
                        try {
                            Message m = (Message)messages.nextElement();
                            final Mail mail = JMSMailQueue.this.createMail(m);
                            final long nextDelivery = m.getLongProperty("JAMES_NEXT_DELIVERY");
                            return new ManageableMailQueue.MailQueueItemView(){

                                public long getNextDelivery() {
                                    return nextDelivery;
                                }

                                public Mail getMail() {
                                    return mail;
                                }
                            };
                        }
                        catch (MessagingException e) {
                            JMSMailQueue.this.logger.error("Unable to browse queue", (Throwable)e);
                        }
                        catch (JMSException e) {
                            JMSMailQueue.this.logger.error("Unable to browse queue", (Throwable)e);
                        }
                    }
                    throw new NoSuchElementException();
                }

                public boolean hasNext() {
                    return messages.hasMoreElements();
                }

                public void close() {
                    try {
                        if (myBrowser != null) {
                            myBrowser.close();
                        }
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                    try {
                        if (mySession != null) {
                            mySession.close();
                        }
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
            };
        }
        catch (Exception e) {
            try {
                if (browser != null) {
                    browser.close();
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.logger.error("Unable to browse queue " + this.queueName, (Throwable)e);
            throw new MailQueue.MailQueueException("Unable to browse queue " + this.queueName, e);
        }
    }

    public void dispose() {
        try {
            this.connection.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

