/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.file;

import org.apache.james.queue.api.DelayedManageableMailQueueContract;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.api.RawMailQueueItemDecoratorFactory;
import org.apache.james.queue.file.FileMailQueue;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.rules.TemporaryFolder;

public class FileMailQueueTest
implements DelayedManageableMailQueueContract {
    private static final boolean SYNC = true;
    private TemporaryFolder temporaryFolder = new TemporaryFolder();
    private FileMailQueue mailQueue;

    @BeforeEach
    public void setUp() throws Exception {
        this.temporaryFolder.create();
        this.mailQueue = new FileMailQueue((MailQueueItemDecoratorFactory)new RawMailQueueItemDecoratorFactory(), this.temporaryFolder.newFolder(), "test", true);
    }

    @AfterEach
    void teardown() {
        this.temporaryFolder.delete();
    }

    public MailQueue getMailQueue() {
        return this.mailQueue;
    }

    public ManageableMailQueue getManageableMailQueue() {
        return this.mailQueue;
    }

    @Test
    @Disabled(value="JAMES-2299 No snapshot isolation")
    public void concurrentClearShouldNotAlterBrowsingWhenDequeueWhileIterating() {
    }

    @Test
    @Disabled(value="JAMES-2299 No snapshot isolation")
    public void concurrentClearShouldNotAlterBrowsingWhenDequeue() {
    }

    @Test
    @Disabled(value="JAMES-2299 No snapshot isolation")
    public void concurrentDequeueShouldNotAlterBrowsing() {
    }

    @Test
    @Disabled(value="JAMES-2299 No snapshot isolation")
    public void concurrentDequeueShouldNotAlterBrowsingWhenDequeueWhileIterating() {
    }

    @Test
    @Disabled(value="JAMES-2299 No snapshot isolation")
    public void concurrentEnqueueShouldNotAlterBrowsingWhenDequeueWhileIterating() {
    }

    @Test
    @Disabled(value="JAMES-2299 No snapshot isolation")
    public void concurrentRemoveShouldNotAlterBrowsingWhenDequeueWhileIterating() {
    }

    @Test
    @Disabled(value="JAMES-2299 No snapshot isolation")
    public void concurrentFlushShouldNotAlterBrowsingWhenDequeueWhileIterating() {
    }

    @Test
    @Disabled(value="JAMES-2299 No snapshot isolation")
    public void concurrentFlushShouldNotAlterBrowsing() {
    }

    @Test
    @Disabled(value="JAMES-2299 No snapshot isolation")
    public void concurrentRemoveShouldNotAlterBrowsingWhenDequeue() {
    }

    @Test
    @Disabled(value="JAMES-2298 Not supported yet")
    public void removeBySenderShouldRemoveSpecificEmail() {
    }

    @Test
    @Disabled(value="JAMES-2298 Not supported yet")
    public void removeByNameShouldRemoveSpecificEmail() {
    }

    @Test
    @Disabled(value="JAMES-2298 Not supported yet")
    public void removeByRecipientShouldRemoveSpecificEmail() {
    }

    @Test
    @Disabled(value="JAMES-2298 Not supported yet")
    public void removeByRecipientShouldNotFailWhenQueueIsEmpty() {
    }

    @Test
    @Disabled(value="JAMES-2298 Not supported yet")
    public void removeBySenderShouldNotFailWhenQueueIsEmpty() {
    }

    @Test
    @Disabled(value="JAMES-2298 Not supported yet")
    public void removeByRecipientShouldRemoveSpecificEmailWhenMultipleRecipients() {
    }
}

