/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.api.mock;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.mail.MessagingException;
import org.apache.james.core.MailImpl;
import org.apache.james.queue.api.MailQueue;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockMailQueue
implements MailQueue {
    private static final Logger log = LoggerFactory.getLogger((String)MockMailQueue.class.getName());
    private final LinkedBlockingQueue<Mail> queue = new LinkedBlockingQueue();
    private boolean throwException;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public void throwExceptionOnNextOperation() {
        this.throwException = true;
    }

    public MailQueue.MailQueueItem deQueue() throws MailQueue.MailQueueException {
        if (this.throwException) {
            this.throwException = false;
            throw new MailQueue.MailQueueException("Mock");
        }
        try {
            final Mail mail = this.queue.take();
            return new MailQueue.MailQueueItem(){

                public Mail getMail() {
                    return mail;
                }

                public void done(boolean success) throws MailQueue.MailQueueException {
                }
            };
        }
        catch (InterruptedException e) {
            log.error("", (Throwable)e);
            throw new MailQueue.MailQueueException("Mock", (Exception)e);
        }
    }

    private Mail cloneMail(Mail mail) {
        ByteArrayOutputStream baos = null;
        ByteArrayInputStream bais = null;
        try {
            baos = new ByteArrayOutputStream();
            ((MailImpl)mail).writeMessageTo((OutputStream)baos);
            log.trace("mimemessage stream: >>>" + new String(baos.toByteArray()) + "<<<");
            bais = new ByteArrayInputStream(baos.toByteArray());
            MailImpl mailImpl = new MailImpl("MockMailCopy" + new Random().nextLong(), mail.getSender(), mail.getRecipients(), (InputStream)bais);
            return mailImpl;
        }
        catch (MessagingException ex) {
            log.error("", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            log.error("", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (bais != null) {
                    bais.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void enQueue(final Mail mail, long delay, TimeUnit unit) throws MailQueue.MailQueueException {
        if (this.throwException) {
            this.throwException = false;
            throw new MailQueue.MailQueueException("Mock");
        }
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    MockMailQueue.this.queue.put(MockMailQueue.this.cloneMail(mail));
                }
                catch (InterruptedException e) {
                    log.error("", (Throwable)e);
                    throw new RuntimeException("Mock", e);
                }
            }
        }, delay, unit);
    }

    public void enQueue(Mail mail) throws MailQueue.MailQueueException {
        if (this.throwException) {
            this.throwException = false;
            throw new MailQueue.MailQueueException("Mock");
        }
        try {
            this.queue.put(this.cloneMail(mail));
        }
        catch (InterruptedException e) {
            log.error("", (Throwable)e);
            throw new MailQueue.MailQueueException("Mock", (Exception)e);
        }
    }

    public Mail getLastMail() {
        Iterator<Mail> it = this.queue.iterator();
        Mail mail = null;
        while (it.hasNext()) {
            mail = it.next();
        }
        return mail;
    }

    public void clear() {
        this.queue.clear();
    }
}

