/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.queue.activemq.ActiveMQHealthCheck;
import org.apache.james.queue.jms.BrokerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@ExtendWith(value={BrokerExtension.class})
class ActiveMQHealthCheckTest {
    private ActiveMQHealthCheck testee;
    private BrokerService broker;

    ActiveMQHealthCheckTest() {
    }

    @BeforeEach
    void setup(BrokerService broker) {
        this.broker = broker;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost?create=false");
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setQueuePrefetch(0);
        connectionFactory.setPrefetchPolicy(prefetchPolicy);
        this.testee = new ActiveMQHealthCheck((ConnectionFactory)connectionFactory);
    }

    @Test
    void componentNameShouldReturnTheRightValue() {
        Assertions.assertThat((String)this.testee.componentName().getName()).isEqualTo(ActiveMQHealthCheck.COMPONENT_NAME.getName());
    }

    @Test
    void checkShouldReturnHealthyWhenActiveMQHealthy() {
        Assertions.assertThat((Object)((Result)Mono.from((Publisher)this.testee.check()).block())).isEqualTo((Object)Result.healthy((ComponentName)ActiveMQHealthCheck.COMPONENT_NAME));
    }

    @Test
    void checkShouldReturnUnHealthyWhenActiveMQDown() throws Exception {
        this.broker.stop();
        Assertions.assertThat((boolean)((Result)Mono.from((Publisher)this.testee.check()).block()).isUnHealthy()).isTrue();
    }
}

