/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.BlobMessage;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.activemq.ActiveMQMailQueueItem;
import org.apache.james.queue.activemq.ActiveMQSupport;
import org.apache.james.queue.activemq.MimeMessageBlobMessageSource;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.jms.JMSCacheableMailQueue;
import org.apache.james.server.core.MailImpl;
import org.apache.james.server.core.MimeMessageInputStream;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.james.server.core.MimeMessageWrapper;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQCacheableMailQueue
extends JMSCacheableMailQueue
implements ActiveMQSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveMQCacheableMailQueue.class);
    private final boolean useBlob;

    public ActiveMQCacheableMailQueue(ConnectionFactory connectionFactory, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory, MailQueueName queuename, MetricFactory metricFactory, GaugeRegistry gaugeRegistry) {
        this(connectionFactory, mailQueueItemDecoratorFactory, queuename, true, metricFactory, gaugeRegistry);
    }

    public ActiveMQCacheableMailQueue(ConnectionFactory connectionFactory, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory, MailQueueName queuename, boolean useBlob, MetricFactory metricFactory, GaugeRegistry gaugeRegistry) {
        super(connectionFactory, mailQueueItemDecoratorFactory, queuename, metricFactory, gaugeRegistry);
        this.useBlob = useBlob;
    }

    protected MailImpl.Builder populateMail(Message message) throws JMSException {
        MailImpl.Builder builder = super.populateMail(message);
        if (message instanceof BlobMessage) {
            BlobMessage blobMessage = (BlobMessage)message;
            try {
                builder.addAttribute(new Attribute(JAMES_BLOB_URL, AttributeValue.of((URL)blobMessage.getURL())));
                builder.addAttribute(new Attribute(JAMES_QUEUE_NAME, AttributeValue.of((String)this.queueName.asString())));
            }
            catch (MalformedURLException e) {
                LOGGER.debug("Unable to get url from blobmessage for mail");
            }
        }
        return builder;
    }

    protected MimeMessage mimeMessage(Message message) throws MessagingException, JMSException {
        if (message instanceof BlobMessage) {
            try {
                BlobMessage blobMessage = (BlobMessage)message;
                MimeMessageBlobMessageSource source = new MimeMessageBlobMessageSource(blobMessage);
                return new MimeMessageWrapper((MimeMessageSource)source);
            }
            catch (JMSException e) {
                throw new MailQueue.MailQueueException("Unable to populate MimeMessage for mail", (Exception)((Object)e));
            }
        }
        return super.mimeMessage(message);
    }

    protected void produceMail(Map<String, Object> props, int msgPrio, Mail mail) throws JMSException, MessagingException, IOException {
        BlobMessage blobMessage = null;
        boolean reuse = false;
        try {
            if (this.useBlob) {
                ActiveMQSession amqSession = this.getAMQSession(this.session);
                if (blobMessage == null) {
                    blobMessage = amqSession.createBlobMessage((InputStream)new MimeMessageInputStream(mail.getMessage()));
                }
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    blobMessage.setObjectProperty(entry.getKey(), entry.getValue());
                }
                this.producer.send((Message)blobMessage, 2, msgPrio, 0L);
            } else {
                super.produceMail(props, msgPrio, mail);
            }
        }
        catch (JMSException e) {
            if (!reuse && blobMessage instanceof ActiveMQBlobMessage) {
                ((ActiveMQBlobMessage)blobMessage).deleteFile();
            }
            throw e;
        }
    }

    protected ActiveMQSession getAMQSession(Session session) {
        return (ActiveMQSession)session;
    }

    protected MailQueue.MailQueueItem createMailQueueItem(Session session, MessageConsumer consumer, Message message) throws JMSException, MessagingException {
        Mail mail = this.createMail(message);
        ActiveMQMailQueueItem activeMQMailQueueItem = new ActiveMQMailQueueItem(mail, session, consumer, message);
        return this.mailQueueItemDecoratorFactory.decorate((MailQueue.MailQueueItem)activeMQMailQueueItem, this.queueName);
    }

    public List<Message> removeWithSelector(String selector) throws MailQueue.MailQueueException {
        List mList = super.removeWithSelector(selector);
        for (Message m : mList) {
            if (!(m instanceof ActiveMQBlobMessage)) continue;
            try {
                ((ActiveMQBlobMessage)m).deleteFile();
            }
            catch (Exception e) {
                LOGGER.error("Unable to delete blob file for message {}", (Object)m, (Object)e);
            }
        }
        return mList;
    }

    protected Message copy(Session session, Message m) throws JMSException {
        if (m instanceof ActiveMQBlobMessage) {
            ActiveMQBlobMessage b = (ActiveMQBlobMessage)m;
            ActiveMQBlobMessage copy = (ActiveMQBlobMessage)this.getAMQSession(session).createBlobMessage(b.getURL());
            try {
                copy.setProperties(b.getProperties());
            }
            catch (IOException e) {
                throw JMSExceptionSupport.create((String)("Unable to copy message " + m), (Exception)e);
            }
            return copy;
        }
        return super.copy(session, m);
    }

    /*
     * Exception decompiling
     */
    public long getSize() throws MailQueue.MailQueueException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

