/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.queue.activemq.ActiveMQCacheableMailQueue;
import org.apache.james.queue.api.DelayedManageableMailQueueContract;
import org.apache.james.queue.api.DelayedPriorityMailQueueContract;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.MailQueueMetricContract;
import org.apache.james.queue.api.MailQueueMetricExtension;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.api.PriorityManageableMailQueueContract;
import org.apache.james.queue.api.RawMailQueueItemDecoratorFactory;
import org.apache.james.queue.jms.BrokerExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={BrokerExtension.class})
@Tag(value="Statistics")
public class ActiveMQMailQueueTest
implements DelayedManageableMailQueueContract,
DelayedPriorityMailQueueContract,
PriorityManageableMailQueueContract,
MailQueueMetricContract {
    static final boolean USE_BLOB = true;
    ActiveMQCacheableMailQueue mailQueue;

    @BeforeEach
    public void setUp(BrokerService broker, MailQueueMetricExtension.MailQueueMetricTestSystem metricTestSystem) {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost?create=false");
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setQueuePrefetch(0);
        connectionFactory.setPrefetchPolicy(prefetchPolicy);
        RawMailQueueItemDecoratorFactory mailQueueItemDecoratorFactory = new RawMailQueueItemDecoratorFactory();
        RecordingMetricFactory metricFactory = metricTestSystem.getMetricFactory();
        GaugeRegistry gaugeRegistry = metricTestSystem.getSpyGaugeRegistry();
        MailQueueName queueName = BrokerExtension.generateRandomQueueName((BrokerService)broker);
        this.mailQueue = new ActiveMQCacheableMailQueue((ConnectionFactory)connectionFactory, (MailQueueItemDecoratorFactory)mailQueueItemDecoratorFactory, queueName, false, (MetricFactory)metricFactory, gaugeRegistry);
    }

    @AfterEach
    public void tearDown() {
        this.mailQueue.dispose();
    }

    public MailQueue getMailQueue() {
        return this.mailQueue;
    }

    public ManageableMailQueue getManageableMailQueue() {
        return this.mailQueue;
    }

    @Test
    @Disabled(value="JAMES-2295 Disabled as test was dead-locking")
    public void dequeueCanBeChainedBeforeAck() {
    }

    @Test
    @Disabled(value="JAMES-2295 Disabled as test was dead-locking")
    public void dequeueCouldBeInterleavingWithOutOfOrderAck() {
    }

    @Test
    @Disabled(value="JAMES-2301 Per recipients headers are not attached to the message.")
    public void queueShouldPreservePerRecipientHeaders() {
    }

    @Test
    @Disabled(value="JAMES-2296 Not handled by JMS mailqueue. Only single recipient per-recipient removal works")
    public void removeByRecipientShouldRemoveSpecificEmailWhenMultipleRecipients() {
    }

    @Test
    @Disabled(value="JAMES-2308 Flushing JMS mail queue randomly re-order themRandom test failing around 1% of the time")
    public void flushShouldPreserveBrowseOrder() {
    }

    @Test
    @Disabled(value="JAMES-2309 Long overflow in JMS delays")
    public void enqueueWithVeryLongDelayShouldDelayMail() {
    }

    @Test
    @Disabled(value="JAMES-2312 JMS clear mailqueue can ommit some messagesRandom test failing around 1% of the time")
    public void clearShouldRemoveAllElements() {
    }

    @Test
    @Disabled(value="JAMES-2794 This test never finishes")
    public void enQueueShouldAcceptMailWithDuplicatedNames() {
    }

    @Test
    @Disabled(value="JAMES-2544 Mixing concurrent ack/nack might lead to a deadlock")
    public void concurrentEnqueueDequeueWithAckNackShouldNotFail() {
    }
}

