/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.temporal.ChronoUnit;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.blob.BlobTransferPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.commons.io.FileUtils;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.queue.activemq.ActiveMQCacheableMailQueue;
import org.apache.james.queue.activemq.FileSystemBlobTransferPolicy;
import org.apache.james.queue.api.DelayedManageableMailQueueContract;
import org.apache.james.queue.api.DelayedPriorityMailQueueContract;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.MailQueueMetricContract;
import org.apache.james.queue.api.MailQueueMetricExtension;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.api.PriorityManageableMailQueueContract;
import org.apache.james.queue.api.RawMailQueueItemDecoratorFactory;
import org.apache.james.queue.jms.BrokerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={BrokerExtension.class})
@Tag(value="Statistics")
public class ActiveMQMailQueueBlobTest
implements DelayedManageableMailQueueContract,
DelayedPriorityMailQueueContract,
PriorityManageableMailQueueContract,
MailQueueMetricContract {
    static final String BASE_DIR = "file://target/james-test";
    static final boolean USE_BLOB = true;
    ActiveMQCacheableMailQueue mailQueue;
    MyFileSystem fileSystem;

    @BeforeEach
    public void setUp(BrokerService broker, MailQueueMetricExtension.MailQueueMetricTestSystem metricTestSystem) {
        this.fileSystem = new MyFileSystem();
        ActiveMQConnectionFactory connectionFactory = this.createConnectionFactory();
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setQueuePrefetch(0);
        connectionFactory.setPrefetchPolicy(prefetchPolicy);
        FileSystemBlobTransferPolicy policy = new FileSystemBlobTransferPolicy();
        policy.setFileSystem((FileSystem)this.fileSystem);
        policy.setDefaultUploadUrl(BASE_DIR);
        connectionFactory.setBlobTransferPolicy((BlobTransferPolicy)policy);
        RawMailQueueItemDecoratorFactory mailQueueItemDecoratorFactory = new RawMailQueueItemDecoratorFactory();
        RecordingMetricFactory metricFactory = metricTestSystem.getMetricFactory();
        GaugeRegistry gaugeRegistry = metricTestSystem.getSpyGaugeRegistry();
        MailQueueName queueName = BrokerExtension.generateRandomQueueName((BrokerService)broker);
        this.mailQueue = new ActiveMQCacheableMailQueue((ConnectionFactory)connectionFactory, (MailQueueItemDecoratorFactory)mailQueueItemDecoratorFactory, queueName, true, (MetricFactory)metricFactory, gaugeRegistry);
    }

    @AfterEach
    public void tearDown() {
        this.mailQueue.dispose();
        this.fileSystem.destroy();
    }

    public MailQueue getMailQueue() {
        return this.mailQueue;
    }

    public ManageableMailQueue getManageableMailQueue() {
        return this.mailQueue;
    }

    @Test
    @Disabled(value="JAMES-2295 Disabled as test was dead-locking")
    public void dequeueCanBeChainedBeforeAck() {
    }

    @Test
    @Disabled(value="JAMES-2295 Disabled as test was dead-locking")
    public void dequeueCouldBeInterleavingWithOutOfOrderAck() {
    }

    @Test
    @Disabled(value="JAMES-2308 Flushing JMS mail queue randomly re-order themRandom test failing around 1% of the time")
    public void flushShouldPreserveBrowseOrder() {
    }

    @Test
    @Disabled(value="JAMES-2312 JMS clear mailqueue can ommit some messagesRandom test failing around 1% of the time")
    public void clearShouldRemoveAllElements() {
    }

    @Test
    @Disabled(value="JAMES-2544 Mixing concurrent ack/nack might lead to a deadlock")
    public void concurrentEnqueueDequeueWithAckNackShouldNotFail() {
    }

    @Test
    @Disabled(value="JAMES-2794 This test never finishes")
    public void enQueueShouldAcceptMailWithDuplicatedNames() {
    }

    @Test
    void computeNextDeliveryTimestampShouldReturnLongMaxWhenOverflow() {
        long deliveryTimestamp = this.mailQueue.computeNextDeliveryTimestamp(ChronoUnit.FOREVER.getDuration());
        Assertions.assertThat((long)deliveryTimestamp).isEqualTo(Long.MAX_VALUE);
    }

    protected ActiveMQConnectionFactory createConnectionFactory() {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?create=false");
        FileSystemBlobTransferPolicy policy = new FileSystemBlobTransferPolicy();
        policy.setFileSystem((FileSystem)new MyFileSystem());
        policy.setDefaultUploadUrl(BASE_DIR);
        factory.setBlobTransferPolicy((BlobTransferPolicy)policy);
        return factory;
    }

    public static final class MyFileSystem
    implements FileSystem {
        private static final Logger LOGGER = LoggerFactory.getLogger(MyFileSystem.class);

        public InputStream getResource(String url) {
            return null;
        }

        public File getFile(String fileURL) throws FileNotFoundException {
            if (fileURL.startsWith("file://")) {
                return new File(fileURL.substring("file://".length()));
            }
            if (fileURL.startsWith("file:/")) {
                return new File(fileURL.substring("file:".length()));
            }
            throw new FileNotFoundException();
        }

        public File getBasedir() throws FileNotFoundException {
            throw new FileNotFoundException();
        }

        public void destroy() {
            try {
                FileUtils.forceDelete((File)this.getFile(ActiveMQMailQueueBlobTest.BASE_DIR));
            }
            catch (FileNotFoundException e) {
                LOGGER.info("No file specified");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

