/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.BlobMessage;
import org.apache.activemq.pool.PooledSession;
import org.apache.commons.logging.Log;
import org.apache.james.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.core.MimeMessageInputStream;
import org.apache.james.core.MimeMessageInputStreamSource;
import org.apache.james.core.MimeMessageSource;
import org.apache.james.queue.activemq.ActiveMQMailQueueItem;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.jms.JMSMailQueue;
import org.apache.mailet.Mail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveMQMailQueue
extends JMSMailQueue {
    private long messageTreshold = -1L;
    private static final String JAMES_BLOB_URL = "JAMES_BLOB_URL";
    public static final int NO_DELAY = -1;
    public static final int DISABLE_TRESHOLD = -1;
    public static final int BLOBMESSAGE_ONLY = 0;

    public ActiveMQMailQueue(ConnectionFactory connectionFactory, String queuename, long messageTreshold, Log logger) {
        super(connectionFactory, queuename, logger);
        this.messageTreshold = messageTreshold;
    }

    public ActiveMQMailQueue(ConnectionFactory connectionFactory, String queuename, Log logger) {
        this(connectionFactory, queuename, -1L, logger);
    }

    protected void populateMailMimeMessage(Message message, Mail mail) throws MessagingException {
        if (message instanceof BlobMessage) {
            try {
                BlobMessage blobMessage = (BlobMessage)message;
                try {
                    mail.setAttribute(JAMES_BLOB_URL, (Serializable)blobMessage.getURL());
                }
                catch (MalformedURLException e) {
                    this.logger.debug((Object)("Unable to get url from blobmessage for mail " + mail.getName()));
                }
                mail.setMessage((MimeMessage)new MimeMessageCopyOnWriteProxy((MimeMessageSource)new MimeMessageInputStreamSource(mail.getName(), blobMessage.getInputStream())));
            }
            catch (IOException e) {
                throw new MailQueue.MailQueueException("Unable to populate MimeMessage for mail " + mail.getName(), (Exception)e);
            }
            catch (JMSException e) {
                throw new MailQueue.MailQueueException("Unable to populate MimeMessage for mail " + mail.getName(), (Exception)((Object)e));
            }
        }
        super.populateMailMimeMessage(message, mail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void produceMail(Session session, Map<String, Object> props, int msgPrio, Mail mail) throws JMSException, MessagingException, IOException {
        boolean useBlob = false;
        if (this.messageTreshold != -1L) {
            try {
                if (this.messageTreshold == 0L || mail.getMessageSize() > this.messageTreshold) {
                    useBlob = true;
                }
            }
            catch (MessagingException e) {
                this.logger.info((Object)("Unable to calculate message size for mail " + mail.getName() + ". Use BytesMessage for JMS"));
                useBlob = false;
            }
        }
        if (useBlob) {
            MessageProducer producer = null;
            try {
                ActiveMQSession amqSession = session instanceof PooledSession ? ((PooledSession)session).getInternalSession() : (ActiveMQSession)session;
                BlobMessage message = amqSession.createBlobMessage((InputStream)new MimeMessageInputStream(mail.getMessage()));
                Queue queue = session.createQueue(this.queuename);
                producer = session.createProducer((Destination)queue);
                for (String key : props.keySet()) {
                    message.setObjectProperty(key, props.get(key));
                }
                producer.send((Message)message, 2, msgPrio, 0L);
            }
            finally {
                try {
                    if (producer != null) {
                        producer.close();
                    }
                }
                catch (JMSException e) {}
            }
        }
        super.produceMail(session, props, msgPrio, mail);
    }

    protected MailQueue.MailQueueItem createMailQueueItem(Connection connection, Session session, MessageConsumer consumer, Message message) throws JMSException, MessagingException {
        Mail mail = this.createMail(message);
        return new ActiveMQMailQueueItem(mail, connection, session, consumer, message, this.logger);
    }
}

