/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/
package org.apache.james.queue.activemq;

import javax.jms.BytesMessage;
import javax.jms.Message;

import org.apache.activemq.BlobMessage;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.jms.JMSMailQueueFactory;


/**
 * {@link MailQueueFactory} implementations which return {@link ActiveMQMailQueue} instances
 * 
 * 
 * 
 *
 */
public class ActiveMQMailQueueFactory extends JMSMailQueueFactory{

    private long sizeTreshold = ActiveMQMailQueue.DISABLE_TRESHOLD;
  
    /**
     * The size treshold which will be used for setting if a {@link BlobMessage} or {@link BytesMessage} will be used
     * as {@link Message} type. See {@link ActiveMQMailQueue} for more details
     * 
     * @param sizeTreshold
     */
    public void setSizeTreshold(long sizeTreshold) {
        this.sizeTreshold  = sizeTreshold;
    }
    
    
    

    @Override
	protected MailQueue createMailQueue(String name) {
        return new ActiveMQMailQueue(connectionFactory, name, sizeTreshold, log);
	}

}
