/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server;

import com.google.inject.name.Names;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.net.pop3.POP3Client;
import org.apache.commons.net.pop3.POP3MessageInfo;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.mock.MockFileSystem;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.manager.InMemoryIntegrationResources;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.pop3server.POP3TestConfiguration;
import org.apache.james.pop3server.netty.POP3Server;
import org.apache.james.protocols.api.ProtocolServer;
import org.apache.james.protocols.api.utils.ProtocolServerUtils;
import org.apache.james.protocols.lib.POP3BeforeSMTPHelper;
import org.apache.james.protocols.lib.handler.ProtocolHandlerLoader;
import org.apache.james.protocols.lib.mock.MockProtocolHandlerLoader;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.jboss.netty.util.HashedWheelTimer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class POP3ServerTest {
    private static final DomainList NO_DOMAIN_LIST = null;
    private POP3TestConfiguration pop3Configuration;
    private final MemoryUsersRepository usersRepository = MemoryUsersRepository.withoutVirtualHosting((DomainList)NO_DOMAIN_LIST);
    private POP3Client pop3Client = null;
    protected MockFileSystem fileSystem;
    protected MockProtocolHandlerLoader protocolHandlerChain;
    private StoreMailboxManager mailboxManager;
    private final byte[] content = "Return-path: return@test.com\r\nContent-Transfer-Encoding: plain\r\nSubject: test\r\n\r\nBody Text POP3ServerTest.setupTestMails\r\n".getBytes();
    private POP3Server pop3Server;
    private HashedWheelTimer hashedWheelTimer;

    POP3ServerTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.hashedWheelTimer = new HashedWheelTimer();
        this.setUpServiceManager();
        this.setUpPOP3Server();
        this.pop3Configuration = new POP3TestConfiguration();
    }

    @AfterEach
    void tearDown() throws Exception {
        try {
            if (this.pop3Client != null && this.pop3Client.isConnected()) {
                this.pop3Client.sendCommand("quit");
                this.pop3Client.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.protocolHandlerChain.dispose();
        this.pop3Server.destroy();
        this.hashedWheelTimer.stop();
    }

    @Test
    void testAuthenticationFail() throws Exception {
        this.finishSetUp(this.pop3Configuration);
        this.pop3Client = new POP3Client();
        InetSocketAddress bindedAddress = new ProtocolServerUtils((ProtocolServer)this.pop3Server).retrieveBindedAddress();
        this.pop3Client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        this.usersRepository.addUser(Username.of((String)"known"), "test2");
        this.pop3Client.login("known", "test");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(0);
        Assertions.assertThat((boolean)this.pop3Client.getReplyString().startsWith("-ERR")).isTrue();
    }

    @Test
    void testUnknownUser() throws Exception {
        this.finishSetUp(this.pop3Configuration);
        this.pop3Client = new POP3Client();
        InetSocketAddress bindedAddress = new ProtocolServerUtils((ProtocolServer)this.pop3Server).retrieveBindedAddress();
        this.pop3Client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        this.pop3Client.login("unknown", "test");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(0);
        Assertions.assertThat((boolean)this.pop3Client.getReplyString().startsWith("-ERR")).isTrue();
    }

    @Test
    void testKnownUserEmptyInbox() throws Exception {
        this.finishSetUp(this.pop3Configuration);
        this.pop3Client = new POP3Client();
        InetSocketAddress bindedAddress = new ProtocolServerUtils((ProtocolServer)this.pop3Server).retrieveBindedAddress();
        this.pop3Client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        this.usersRepository.addUser(Username.of((String)"foo"), "bar");
        Object[] entries = this.pop3Client.listMessages();
        Assertions.assertThat((Object[])entries).isNull();
        this.pop3Client.login("foo", "bar");
        System.err.println(this.pop3Client.getState());
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        entries = this.pop3Client.listMessages();
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        Assertions.assertThat((Object[])entries).isNotNull();
        Assertions.assertThat((int)0).isEqualTo(entries.length);
        POP3MessageInfo p3i = this.pop3Client.listMessage(1);
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        Assertions.assertThat((Object)p3i).isNull();
    }

    @Test
    void testUnknownCommand() throws Exception {
        this.finishSetUp(this.pop3Configuration);
        this.pop3Client = new POP3Client();
        InetSocketAddress bindedAddress = new ProtocolServerUtils((ProtocolServer)this.pop3Server).retrieveBindedAddress();
        this.pop3Client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        this.pop3Client.sendCommand("unkn");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(0);
        ((AbstractStringAssert)Assertions.assertThat((String)"-ERR").describedAs("Expected -ERR as result for an unknown command", new Object[0])).isEqualTo(this.pop3Client.getReplyString().substring(0, 4));
    }

    @Test
    void testUidlCommand() throws Exception {
        this.finishSetUp(this.pop3Configuration);
        Username username = Username.of((String)"foo");
        this.usersRepository.addUser(username, "bar");
        this.pop3Client = new POP3Client();
        InetSocketAddress bindedAddress = new ProtocolServerUtils((ProtocolServer)this.pop3Server).retrieveBindedAddress();
        this.pop3Client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        this.pop3Client.sendCommand("uidl");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(0);
        this.pop3Client.login("foo", "bar");
        POP3MessageInfo[] list = this.pop3Client.listUniqueIdentifiers();
        ((AbstractIntegerAssert)Assertions.assertThat((int)list.length).describedAs("Found unexpected messages", new Object[0])).isEqualTo(0);
        this.pop3Client.disconnect();
        MailboxPath mailboxPath = MailboxPath.inbox((Username)username);
        MailboxSession session = this.mailboxManager.login(username, "bar");
        if (!((Boolean)this.mailboxManager.mailboxExists(mailboxPath, session).block()).booleanValue()) {
            this.mailboxManager.createMailbox(mailboxPath, session);
        }
        this.setupTestMails(session, this.mailboxManager.getMailbox(mailboxPath, session));
        this.pop3Client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        this.pop3Client.login("foo", "bar");
        list = this.pop3Client.listUniqueIdentifiers();
        ((AbstractIntegerAssert)Assertions.assertThat((int)list.length).describedAs("Expected 2 messages, found: " + list.length, new Object[0])).isEqualTo(2);
        POP3MessageInfo p3i = this.pop3Client.listUniqueIdentifier(1);
        Assertions.assertThat((Object)p3i).isNotNull();
        this.mailboxManager.deleteMailbox(mailboxPath, session);
    }

    @Test
    void testMiscCommandsWithWithoutAuth() throws Exception {
        this.finishSetUp(this.pop3Configuration);
        this.usersRepository.addUser(Username.of((String)"foo"), "bar");
        this.pop3Client = new POP3Client();
        InetSocketAddress bindedAddress = new ProtocolServerUtils((ProtocolServer)this.pop3Server).retrieveBindedAddress();
        this.pop3Client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        this.pop3Client.sendCommand("noop");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(0);
        Assertions.assertThat((String)this.pop3Client.getReplyString().substring(0, 4)).isEqualTo("-ERR");
        this.pop3Client.sendCommand("stat");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(0);
        Assertions.assertThat((String)this.pop3Client.getReplyString().substring(0, 4)).isEqualTo("-ERR");
        this.pop3Client.sendCommand("pass");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(0);
        Assertions.assertThat((String)this.pop3Client.getReplyString().substring(0, 4)).isEqualTo("-ERR");
        this.pop3Client.sendCommand("auth");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(0);
        Assertions.assertThat((String)this.pop3Client.getReplyString().substring(0, 4)).isEqualTo("-ERR");
        this.pop3Client.sendCommand("rset");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(0);
        Assertions.assertThat((String)this.pop3Client.getReplyString().substring(0, 4)).isEqualTo("-ERR");
        this.pop3Client.login("foo", "bar");
        POP3MessageInfo[] list = this.pop3Client.listUniqueIdentifiers();
        ((AbstractIntegerAssert)Assertions.assertThat((int)list.length).describedAs("Found unexpected messages", new Object[0])).isEqualTo(0);
        this.pop3Client.sendCommand("noop");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        this.pop3Client.sendCommand("pass");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        Assertions.assertThat((String)this.pop3Client.getReplyString().substring(0, 4)).isEqualTo("-ERR");
        this.pop3Client.sendCommand("auth");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        Assertions.assertThat((String)this.pop3Client.getReplyString().substring(0, 4)).isEqualTo("-ERR");
        this.pop3Client.sendCommand("user");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        Assertions.assertThat((String)this.pop3Client.getReplyString().substring(0, 4)).isEqualTo("-ERR");
        this.pop3Client.sendCommand("rset");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
    }

    @Test
    void testKnownUserInboxWithMessages() throws Exception {
        this.finishSetUp(this.pop3Configuration);
        this.pop3Client = new POP3Client();
        InetSocketAddress bindedAddress = new ProtocolServerUtils((ProtocolServer)this.pop3Server).retrieveBindedAddress();
        this.pop3Client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        Username username = Username.of((String)"foo2");
        this.usersRepository.addUser(username, "bar2");
        MailboxPath mailboxPath = MailboxPath.inbox((Username)username);
        MailboxSession session = this.mailboxManager.login(username, "bar2");
        if (!((Boolean)this.mailboxManager.mailboxExists(mailboxPath, session).block()).booleanValue()) {
            this.mailboxManager.createMailbox(mailboxPath, session);
        }
        this.setupTestMails(session, this.mailboxManager.getMailbox(mailboxPath, session));
        this.pop3Client.sendCommand("retr", "1");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(0);
        Assertions.assertThat((String)this.pop3Client.getReplyString().substring(0, 4)).isEqualTo("-ERR");
        this.pop3Client.login("foo2", "bar2");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        Object[] entries = this.pop3Client.listMessages();
        Assertions.assertThat((Object[])entries).isNotNull();
        Assertions.assertThat((int)entries.length).isEqualTo(2);
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        Reader r = this.pop3Client.retrieveMessageTop(((POP3MessageInfo)entries[0]).number, 0);
        Assertions.assertThat((Object)r).isNotNull();
        r.close();
        Reader r2 = this.pop3Client.retrieveMessage(((POP3MessageInfo)entries[0]).number);
        Assertions.assertThat((Object)r2).isNotNull();
        r2.close();
        boolean deleted = this.pop3Client.deleteMessage(((POP3MessageInfo)entries[0]).number);
        Assertions.assertThat((boolean)deleted).isTrue();
        deleted = this.pop3Client.deleteMessage(((POP3MessageInfo)entries[0]).number);
        Assertions.assertThat((boolean)deleted).isFalse();
        deleted = this.pop3Client.deleteMessage(10);
        Assertions.assertThat((boolean)deleted).isFalse();
        this.pop3Client.logout();
        this.pop3Client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        this.pop3Client.login("foo2", "bar2");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        entries = null;
        POP3MessageInfo stats = this.pop3Client.status();
        Assertions.assertThat((int)stats.number).isEqualTo(1);
        Assertions.assertThat((int)stats.size).isEqualTo(5);
        entries = this.pop3Client.listMessages();
        Assertions.assertThat((Object[])entries).isNotNull();
        Assertions.assertThat((int)entries.length).isEqualTo(1);
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        this.pop3Client.sendCommand("top");
        Assertions.assertThat((String)this.pop3Client.getReplyString().substring(0, 4)).isEqualTo("-ERR");
        Reader r3 = this.pop3Client.retrieveMessageTop(((POP3MessageInfo)entries[0]).number, 0);
        Assertions.assertThat((Object)r3).isNotNull();
        r3.close();
        this.mailboxManager.deleteMailbox(mailboxPath, session);
    }

    @Test
    void testStatUidlList() throws Exception {
        this.finishSetUp(this.pop3Configuration);
        this.pop3Client = new POP3Client();
        InetSocketAddress bindedAddress = new ProtocolServerUtils((ProtocolServer)this.pop3Server).retrieveBindedAddress();
        this.pop3Client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        Username username = Username.of((String)"foo2");
        this.usersRepository.addUser(username, "bar2");
        MailboxPath mailboxPath = MailboxPath.inbox((Username)username);
        MailboxSession session = this.mailboxManager.login(username, "bar2");
        if (!((Boolean)this.mailboxManager.mailboxExists(mailboxPath, session).block()).booleanValue()) {
            this.mailboxManager.createMailbox(mailboxPath, session);
        }
        int msgCount = 100;
        for (int i = 0; i < msgCount; ++i) {
            this.mailboxManager.getMailbox(mailboxPath, session).appendMessage(MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("test").setBody(String.valueOf(i), StandardCharsets.UTF_8)), session);
        }
        this.pop3Client.login("foo2", "bar2");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        POP3MessageInfo[] listEntries = this.pop3Client.listMessages();
        POP3MessageInfo[] uidlEntries = this.pop3Client.listUniqueIdentifiers();
        POP3MessageInfo statInfo = this.pop3Client.status();
        Assertions.assertThat((int)listEntries.length).isEqualTo(msgCount);
        Assertions.assertThat((int)uidlEntries.length).isEqualTo(msgCount);
        Assertions.assertThat((int)statInfo.number).isEqualTo(msgCount);
        this.pop3Client.sendCommand("quit");
        this.pop3Client.disconnect();
        this.pop3Client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        this.pop3Client.login("foo2", "bar2");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        this.mailboxManager.deleteMailbox(mailboxPath, session);
    }

    @Test
    @Disabled(value="Test for JAMES-1202 - This was failing before as the more then one connection to the same mailbox was not handled the right way")
    void testStatUidlListTwoConnections() throws Exception {
        this.finishSetUp(this.pop3Configuration);
        this.pop3Client = new POP3Client();
        InetSocketAddress bindedAddress = new ProtocolServerUtils((ProtocolServer)this.pop3Server).retrieveBindedAddress();
        this.pop3Client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        Username username = Username.of((String)"foo2");
        this.usersRepository.addUser(username, "bar2");
        MailboxPath mailboxPath = MailboxPath.inbox((Username)username);
        MailboxSession session = this.mailboxManager.login(username, "bar2");
        if (!((Boolean)this.mailboxManager.mailboxExists(mailboxPath, session).block()).booleanValue()) {
            this.mailboxManager.createMailbox(mailboxPath, session);
        }
        int msgCount = 100;
        for (int i = 0; i < msgCount; ++i) {
            this.mailboxManager.getMailbox(mailboxPath, session).appendMessage(MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("test").setBody(String.valueOf(i), StandardCharsets.UTF_8)), session);
        }
        this.pop3Client.login("foo2", "bar2");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        POP3MessageInfo[] listEntries = this.pop3Client.listMessages();
        POP3MessageInfo[] uidlEntries = this.pop3Client.listUniqueIdentifiers();
        POP3MessageInfo statInfo = this.pop3Client.status();
        Assertions.assertThat((int)listEntries.length).isEqualTo(msgCount);
        Assertions.assertThat((int)uidlEntries.length).isEqualTo(msgCount);
        Assertions.assertThat((int)statInfo.number).isEqualTo(msgCount);
        POP3Client pop3Protocol2 = new POP3Client();
        pop3Protocol2.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        pop3Protocol2.login("foo2", "bar2");
        Assertions.assertThat((int)pop3Protocol2.getState()).isEqualTo(1);
        POP3MessageInfo[] listEntries2 = pop3Protocol2.listMessages();
        POP3MessageInfo[] uidlEntries2 = pop3Protocol2.listUniqueIdentifiers();
        POP3MessageInfo statInfo2 = pop3Protocol2.status();
        Assertions.assertThat((int)listEntries2.length).isEqualTo(msgCount);
        Assertions.assertThat((int)uidlEntries2.length).isEqualTo(msgCount);
        Assertions.assertThat((int)statInfo2.number).isEqualTo(msgCount);
        this.pop3Client.deleteMessage(1);
        listEntries = this.pop3Client.listMessages();
        uidlEntries = this.pop3Client.listUniqueIdentifiers();
        statInfo = this.pop3Client.status();
        Assertions.assertThat((int)listEntries.length).isEqualTo(msgCount - 1);
        Assertions.assertThat((int)uidlEntries.length).isEqualTo(msgCount - 1);
        Assertions.assertThat((int)statInfo.number).isEqualTo(msgCount - 1);
        listEntries2 = pop3Protocol2.listMessages();
        uidlEntries2 = pop3Protocol2.listUniqueIdentifiers();
        statInfo2 = pop3Protocol2.status();
        Assertions.assertThat((int)listEntries2.length).isEqualTo(msgCount);
        Assertions.assertThat((int)uidlEntries2.length).isEqualTo(msgCount);
        Assertions.assertThat((int)statInfo2.number).isEqualTo(msgCount);
        Assertions.assertThat((boolean)this.pop3Client.logout()).isTrue();
        this.pop3Client.disconnect();
        listEntries2 = pop3Protocol2.listMessages();
        uidlEntries2 = pop3Protocol2.listUniqueIdentifiers();
        statInfo2 = pop3Protocol2.status();
        Assertions.assertThat((int)listEntries2.length).isEqualTo(msgCount);
        Assertions.assertThat((int)uidlEntries2.length).isEqualTo(msgCount);
        Assertions.assertThat((int)statInfo2.number).isEqualTo(msgCount);
        Assertions.assertThat((Object)pop3Protocol2.retrieveMessageTop(1, 100)).isNull();
        Assertions.assertThat((Object)pop3Protocol2.retrieveMessage(1)).isNull();
        pop3Protocol2.sendCommand("quit");
        pop3Protocol2.disconnect();
        this.mailboxManager.deleteMailbox(mailboxPath, session);
    }

    @Test
    void testIpStored() throws Exception {
        this.finishSetUp(this.pop3Configuration);
        this.pop3Client = new POP3Client();
        InetSocketAddress bindedAddress = new ProtocolServerUtils((ProtocolServer)this.pop3Server).retrieveBindedAddress();
        this.pop3Client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        String pass = "password";
        this.usersRepository.addUser(Username.of((String)"foo"), pass);
        this.pop3Client.login("foo", pass);
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        Assertions.assertThat((boolean)POP3BeforeSMTPHelper.isAuthorized((String)"127.0.0.1")).isTrue();
    }

    @Test
    void testCapa() throws Exception {
        this.finishSetUp(this.pop3Configuration);
        this.pop3Client = new POP3Client();
        InetSocketAddress bindedAddress = new ProtocolServerUtils((ProtocolServer)this.pop3Server).retrieveBindedAddress();
        this.pop3Client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        String pass = "password";
        this.usersRepository.addUser(Username.of((String)"foo"), pass);
        Assertions.assertThat((int)this.pop3Client.sendCommand("CAPA")).isEqualTo(0);
        this.pop3Client.getAdditionalReply();
        this.pop3Client.getReplyString();
        List<String> replies = Arrays.asList(this.pop3Client.getReplyStrings());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)replies.contains("USER")).describedAs("contains USER", new Object[0])).isTrue();
        this.pop3Client.login("foo", pass);
        Assertions.assertThat((int)this.pop3Client.sendCommand("CAPA")).isEqualTo(0);
        this.pop3Client.getAdditionalReply();
        this.pop3Client.getReplyString();
        replies = Arrays.asList(this.pop3Client.getReplyStrings());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)replies.contains("USER")).describedAs("contains USER", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)replies.contains("UIDL")).describedAs("contains UIDL", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)replies.contains("TOP")).describedAs("contains TOP", new Object[0])).isTrue();
    }

    @Test
    void testDeadlockOnRetr() throws Exception {
        this.finishSetUp(this.pop3Configuration);
        this.pop3Client = new POP3Client();
        InetSocketAddress bindedAddress = new ProtocolServerUtils((ProtocolServer)this.pop3Server).retrieveBindedAddress();
        this.pop3Client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        Username username = Username.of((String)"foo6");
        this.usersRepository.addUser(username, "bar6");
        MailboxSession session = this.mailboxManager.login(username, "bar6");
        MailboxPath mailboxPath = MailboxPath.inbox((Username)username);
        this.mailboxManager.startProcessingRequest(session);
        if (!((Boolean)this.mailboxManager.mailboxExists(mailboxPath, session).block()).booleanValue()) {
            this.mailboxManager.createMailbox(mailboxPath, session);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(this.content);
        byte[] bigMail = new byte[0xA00000];
        int c = 0;
        for (int i = 0; i < bigMail.length; ++i) {
            bigMail[i] = 88;
            if (++c != 1000 && i + 3 != bigMail.length) continue;
            c = 0;
            bigMail[++i] = 13;
            bigMail[++i] = 10;
        }
        out.write(bigMail);
        bigMail = null;
        this.mailboxManager.getMailbox(mailboxPath, session).appendMessage(MessageManager.AppendCommand.builder().build(out.toByteArray()), session);
        this.mailboxManager.startProcessingRequest(session);
        this.pop3Client.login("foo6", "bar6");
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        Object[] entries = this.pop3Client.listMessages();
        Assertions.assertThat((Object[])entries).isNotNull();
        Assertions.assertThat((int)entries.length).isEqualTo(1);
        Assertions.assertThat((int)this.pop3Client.getState()).isEqualTo(1);
        Reader r = this.pop3Client.retrieveMessage(((POP3MessageInfo)entries[0]).number);
        Assertions.assertThat((Object)r).isNotNull();
        r.close();
        this.mailboxManager.deleteMailbox(mailboxPath, session);
    }

    protected POP3Server createPOP3Server() {
        return new POP3Server();
    }

    protected void initPOP3Server(POP3TestConfiguration testConfiguration) throws Exception {
        this.pop3Server.configure((HierarchicalConfiguration)testConfiguration);
        this.pop3Server.init();
    }

    protected void setUpPOP3Server() {
        this.pop3Server = this.createPOP3Server();
        this.pop3Server.setFileSystem((FileSystem)this.fileSystem);
        this.pop3Server.setHashWheelTimer(this.hashedWheelTimer);
        this.pop3Server.setProtocolHandlerLoader((ProtocolHandlerLoader)this.protocolHandlerChain);
    }

    protected void finishSetUp(POP3TestConfiguration testConfiguration) throws Exception {
        testConfiguration.init();
        this.initPOP3Server(testConfiguration);
    }

    protected void setUpServiceManager() throws Exception {
        this.mailboxManager = InMemoryIntegrationResources.builder().authenticator((userid, passwd) -> {
            try {
                return this.usersRepository.test(userid, passwd.toString());
            }
            catch (UsersRepositoryException e) {
                e.printStackTrace();
                return false;
            }
        }).fakeAuthorizator().inVmEventBus().defaultAnnotationLimits().defaultMessageParser().scanningSearchIndex().noPreDeletionHooks().storeQuotaManager().build().getMailboxManager();
        this.fileSystem = new MockFileSystem();
        this.protocolHandlerChain = MockProtocolHandlerLoader.builder().put(binder -> binder.bind(UsersRepository.class).toInstance((Object)this.usersRepository)).put(binder -> binder.bind(MailboxManager.class).annotatedWith((Annotation)Names.named((String)"mailboxmanager")).toInstance((Object)this.mailboxManager)).put(binder -> binder.bind(FileSystem.class).toInstance((Object)this.fileSystem)).put(binder -> binder.bind(MetricFactory.class).toInstance((Object)new RecordingMetricFactory())).build();
    }

    private void setupTestMails(MailboxSession session, MessageManager mailbox) throws MailboxException {
        mailbox.appendMessage(MessageManager.AppendCommand.builder().build(this.content), session);
        byte[] content2 = "EMPTY".getBytes();
        mailbox.appendMessage(MessageManager.AppendCommand.builder().build(content2), session);
    }
}

