/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import com.google.common.collect.ImmutableMap;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imapserver.netty.ImapRequestFrameDecoder;
import org.assertj.core.api.Assertions;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ImapRequestFrameDecoderTest {
    ImapRequestFrameDecoder testee;

    ImapRequestFrameDecoderTest() {
    }

    @BeforeEach
    void setUp() {
        this.testee = new ImapRequestFrameDecoder((ImapDecoder)Mockito.mock(ImapDecoder.class), 12, 18);
    }

    @Test
    void newCumulationBufferShouldNotThrowWhenNoAttachments() {
        ChannelHandlerContext channelHandler = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Channel channel = (Channel)Mockito.mock(Channel.class);
        ChannelConfig channelConfig = (ChannelConfig)Mockito.mock(ChannelConfig.class);
        Mockito.when((Object)channelConfig.getBufferFactory()).thenReturn((Object)((ChannelBufferFactory)Mockito.mock(ChannelBufferFactory.class)));
        Mockito.when((Object)channelHandler.getChannel()).thenReturn((Object)channel);
        Mockito.when((Object)channel.getConfig()).thenReturn((Object)channelConfig);
        Mockito.when((Object)channelHandler.getAttachment()).thenReturn((Object)ImmutableMap.of());
        Assertions.assertThatCode(() -> this.testee.newCumulationBuffer(channelHandler, 36)).doesNotThrowAnyException();
    }

    @Test
    void newCumulationBufferShouldNotThrowOnNegativeSize() {
        ChannelHandlerContext channelHandler = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Channel channel = (Channel)Mockito.mock(Channel.class);
        ChannelConfig channelConfig = (ChannelConfig)Mockito.mock(ChannelConfig.class);
        Mockito.when((Object)channelConfig.getBufferFactory()).thenReturn((Object)((ChannelBufferFactory)Mockito.mock(ChannelBufferFactory.class)));
        Mockito.when((Object)channelHandler.getChannel()).thenReturn((Object)channel);
        Mockito.when((Object)channel.getConfig()).thenReturn((Object)channelConfig);
        Mockito.when((Object)channelHandler.getAttachment()).thenReturn((Object)ImmutableMap.of((Object)"NEEDED_DATA", (Object)-1));
        Assertions.assertThatCode(() -> this.testee.newCumulationBuffer(channelHandler, 36)).doesNotThrowAnyException();
    }
}

