/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.read.ListAppender;
import com.sun.mail.imap.IMAPFolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelOption;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import nl.altindag.ssl.exception.GenericKeyStoreException;
import nl.altindag.ssl.exception.PrivateKeyParseException;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.net.imap.AuthenticatingIMAPClient;
import org.apache.commons.net.imap.IMAPSClient;
import org.apache.james.core.Username;
import org.apache.james.events.EventBus;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.imap.encode.main.DefaultImapEncoderFactory;
import org.apache.james.imap.main.DefaultImapDecoderFactory;
import org.apache.james.imap.processor.base.AbstractChainedProcessor;
import org.apache.james.imap.processor.main.DefaultImapProcessorFactory;
import org.apache.james.imapserver.netty.IMAPServer;
import org.apache.james.imapserver.netty.ImapMetrics;
import org.apache.james.mailbox.Authenticator;
import org.apache.james.mailbox.Authorizator;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.inmemory.InMemoryMailboxManager;
import org.apache.james.mailbox.inmemory.manager.InMemoryIntegrationResources;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.FakeAuthenticator;
import org.apache.james.mailbox.store.FakeAuthorizator;
import org.apache.james.mailbox.store.StoreSubscriptionManager;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.protocols.api.OIDCSASLHelper;
import org.apache.james.protocols.api.utils.BogusSslContextFactory;
import org.apache.james.protocols.api.utils.BogusTrustManagerFactory;
import org.apache.james.protocols.lib.mock.ConfigLoader;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.server.core.filesystem.FileSystemImpl;
import org.apache.james.util.ClassLoaderUtils;
import org.apache.james.utils.TestIMAPClient;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RequestDefinition;
import org.reactivestreams.Publisher;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.netty.Connection;
import reactor.netty.tcp.TcpClient;

class IMAPServerTest {
    private static final String _129K_MESSAGE = "header: value\r\n" + "012345678\r\n".repeat(13107);
    private static final String _65K_MESSAGE = "header: value\r\n" + "012345678\r\n".repeat(6553);
    private static final Username USER = Username.of((String)"user@domain.org");
    private static final Username USER2 = Username.of((String)"bobo@domain.org");
    private static final String USER_PASS = "pass";
    public static final String SMALL_MESSAGE = "header: value\r\n\r\nBODY";
    private InMemoryIntegrationResources memoryIntegrationResources;
    @RegisterExtension
    public TestIMAPClient testIMAPClient = new TestIMAPClient();

    IMAPServerTest() {
    }

    public static ListAppender<ILoggingEvent> getListAppenderForClass(Class clazz) {
        Logger logger = (Logger)LoggerFactory.getLogger((Class)clazz);
        ListAppender loggingEventListAppender = new ListAppender();
        loggingEventListAppender.start();
        logger.addAppender((Appender)loggingEventListAppender);
        return loggingEventListAppender;
    }

    private IMAPServer createImapServer(HierarchicalConfiguration<ImmutableNode> config) throws Exception {
        FakeAuthenticator authenticator = new FakeAuthenticator();
        authenticator.addUser(USER, USER_PASS);
        authenticator.addUser(USER2, USER_PASS);
        this.memoryIntegrationResources = InMemoryIntegrationResources.builder().authenticator((Authenticator)authenticator).authorizator((Authorizator)FakeAuthorizator.defaultReject()).inVmEventBus().defaultAnnotationLimits().defaultMessageParser().scanningSearchIndex().noPreDeletionHooks().storeQuotaManager().build();
        RecordingMetricFactory metricFactory = new RecordingMetricFactory();
        IMAPServer imapServer = new IMAPServer(DefaultImapDecoderFactory.createDecoder(), new DefaultImapEncoderFactory().buildImapEncoder(), DefaultImapProcessorFactory.createXListSupportingProcessor((MailboxManager)this.memoryIntegrationResources.getMailboxManager(), (EventBus)this.memoryIntegrationResources.getEventBus(), (SubscriptionManager)new StoreSubscriptionManager((SubscriptionMapperFactory)this.memoryIntegrationResources.getMailboxManager().getMapperFactory()), null, (QuotaManager)this.memoryIntegrationResources.getQuotaManager(), (QuotaRootResolver)this.memoryIntegrationResources.getQuotaRootResolver(), (MetricFactory)metricFactory), new ImapMetrics((MetricFactory)metricFactory));
        Configuration.Basic configuration = Configuration.builder().workingDirectory("../").configurationFromClasspath().build();
        FileSystemImpl fileSystem = new FileSystemImpl(configuration.directories());
        imapServer.setFileSystem((FileSystem)fileSystem);
        imapServer.configure(config);
        imapServer.init();
        return imapServer;
    }

    private IMAPServer createImapServer(String configurationFile) throws Exception {
        return this.createImapServer((HierarchicalConfiguration<ImmutableNode>)ConfigLoader.getConfig((InputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)configurationFile)));
    }

    private AuthenticatingIMAPClient imapsClient(int port) throws Exception {
        AuthenticatingIMAPClient client = new AuthenticatingIMAPClient(false, BogusSslContextFactory.getClientContext());
        client.setTrustManager(BogusTrustManagerFactory.getTrustManagers()[0]);
        client.connect("127.0.0.1", port);
        client.execTLS();
        return client;
    }

    @Nested
    class Search {
        IMAPServer imapServer;
        private int port;

        Search() {
        }

        @BeforeEach
        void beforeEach() throws Exception {
            this.imapServer = IMAPServerTest.this.createImapServer("imapServer.xml");
            this.port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
        }

        @AfterEach
        void tearDown() {
            this.imapServer.destroy();
        }

        @Disabled(value="JAMES-1489 IMAP Search do not support continuation")
        @Test
        void searchingShouldSupportMultipleUTF8Criteria() throws Exception {
            String host = "127.0.0.1";
            Properties props = new Properties();
            props.put("mail.debug", "true");
            Session session = Session.getDefaultInstance((Properties)props, null);
            Store store = session.getStore("imap");
            store.connect(host, this.port, USER.asString(), IMAPServerTest.USER_PASS);
            Folder folder = store.getFolder("INBOX");
            folder.open(1);
            SubjectTerm subjectTerm = new SubjectTerm("java\u57f9\u8bad");
            FromStringTerm fromTerm = new FromStringTerm("\u91c7\u8d2d");
            RecipientStringTerm recipientTerm = new RecipientStringTerm(Message.RecipientType.TO, "\u5f20\u4e09");
            RecipientStringTerm ccRecipientTerm = new RecipientStringTerm(Message.RecipientType.CC, "\u674e\u56db");
            RecipientStringTerm bccRecipientTerm = new RecipientStringTerm(Message.RecipientType.BCC, "\u738b\u4e94");
            BodyTerm bodyTerm = new BodyTerm("\u5929\u5929\u5411\u4e0a");
            SearchTerm[] searchTerms = new SearchTerm[]{subjectTerm, bodyTerm, fromTerm, recipientTerm, ccRecipientTerm, bccRecipientTerm};
            AndTerm andTerm = new AndTerm(searchTerms);
            Assertions.assertThatCode(() -> Search.lambda$searchingShouldSupportMultipleUTF8Criteria$0(folder, (SearchTerm)andTerm)).doesNotThrowAnyException();
            folder.close(false);
            store.close();
        }

        @Test
        void searchingASingleUTF8CriterionShouldComplete() throws Exception {
            MailboxSession mailboxSession = IMAPServerTest.this.memoryIntegrationResources.getMailboxManager().createSystemSession(USER);
            IMAPServerTest.this.memoryIntegrationResources.getMailboxManager().createMailbox(MailboxPath.inbox((Username)USER), mailboxSession);
            IMAPServerTest.this.memoryIntegrationResources.getMailboxManager().getMailbox(MailboxPath.inbox((Username)USER), mailboxSession).appendMessage(MessageManager.AppendCommand.builder().build("MIME-Version: 1.0\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Transfer-Encoding: quoted-printable\r\nFrom: =?ISO-8859-1?Q?Beno=EEt_TELLIER?= <b@linagora.com>\r\nSender: =?ISO-8859-1?Q?Beno=EEt_TELLIER?= <b@linagora.com>\r\nReply-To: b@linagora.com\r\nTo: =?ISO-8859-1?Q?Beno=EEt_TELLIER?= <b@linagora.com>\r\nSubject: Test utf-8 charset\r\nMessage-ID: <Mime4j.5f1.9a40f68264d6f2fa.17876fb5605@linagora.com>\r\nDate: Sun, 28 Mar 2021 03:58:06 +0000\r\n\r\n<p>=E5=A4=A9=E5=A4=A9=E5=90=91=E4=B8=8A<br></p>\r\n"), mailboxSession);
            String host = "127.0.0.1";
            Properties props = new Properties();
            props.put("mail.debug", "true");
            Session session = Session.getDefaultInstance((Properties)props, null);
            Store store = session.getStore("imap");
            store.connect(host, this.port, USER.asString(), IMAPServerTest.USER_PASS);
            Folder folder = store.getFolder("INBOX");
            folder.open(1);
            BodyTerm bodyTerm = new BodyTerm("\u5929\u5929\u5411\u4e0a");
            Assertions.assertThat((Object[])folder.search((SearchTerm)bodyTerm)).hasSize(1);
            folder.close(false);
            store.close();
        }

        private static /* synthetic */ void lambda$searchingShouldSupportMultipleUTF8Criteria$0(Folder folder, SearchTerm andTerm) throws Throwable {
            folder.search(andTerm);
        }
    }

    @Nested
    class Oidc {
        String JWKS_URI_PATH = "/jwks";
        ClientAndServer authServer;
        IMAPServer imapServer;
        int port;

        Oidc() {
        }

        @BeforeEach
        void authSetup() throws Exception {
            this.authServer = ClientAndServer.startClientAndServer((Integer[])new Integer[]{0});
            this.authServer.when((RequestDefinition)HttpRequest.request().withPath(this.JWKS_URI_PATH)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withHeader("Content-Type", new String[]{"application/json"}).withBody("{    \"keys\": [        {            \"kid\": \"w80Ps5Iasn-aGWmw2TrxDiNcahpH2sXz5pqdhAl9HXc\",            \"kty\": \"RSA\",            \"alg\": \"RS256\",            \"use\": \"sig\",            \"n\": \"q6EiBITWGo18woLJ_sXrYI6mHP0mooWhwiI1q2tsTG5MpeNgSE0ZowRRm1MU4TBIOWL2gVwtV0Hom2rlu4CZwWbPEueCuRTMo4FFzim4x6j0cRO-r1GiGJAGaHrnwJ16LHw3_11GU0yhNsscmSYXX4FP0UhKTdfY6F37JCEFpiF5TCpCBvZRqo-3iHMqJnZRx7mMW_aMKlPpTyZS1ATvDA56IDjgF5gt8qEsHj51yy_ujS4C6e4kIK9sUefH_c30yWPQomLhDQUD0mRyGyN_zo_SQbk9S4hQghyNDb_ZJjpfoZySjNeBrVFPtpbUHy8DK9HWWOqEsv1kACyfE7rQnQ\",            \"e\": \"AQAB\",            \"x5c\": [                \"MIICmzCCAYMCBgF91kYdyzANBgkqhkiG9w0BAQsFADARMQ8wDQYDVQQDDAZyZWFsbTEwHhcNMjExMjIwMDUxNTU5WhcNMzExMjIwMDUxNzM5WjARMQ8wDQYDVQQDDAZyZWFsbTEwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCroSIEhNYajXzCgsn+xetgjqYc/SaihaHCIjWra2xMbkyl42BITRmjBFGbUxThMEg5YvaBXC1XQeibauW7gJnBZs8S54K5FMyjgUXOKbjHqPRxE76vUaIYkAZoeufAnXosfDf/XUZTTKE2yxyZJhdfgU/RSEpN19joXfskIQWmIXlMKkIG9lGqj7eIcyomdlHHuYxb9owqU+lPJlLUBO8MDnogOOAXmC3yoSwePnXLL+6NLgLp7iQgr2xR58f9zfTJY9CiYuENBQPSZHIbI3/Oj9JBuT1LiFCCHI0Nv9kmOl+hnJKM14GtUU+2ltQfLwMr0dZY6oSy/WQALJ8TutCdAgMBAAEwDQYJKoZIhvcNAQELBQADggEBADbwilJj3iLRyuypfYakEv42L5RDrwgImjmXvaX77Bjacr9IjaEyRAVZI7UGu62qN0lV3DxOFwdhsCoyXtufiz1nuvsuZ1M/M/RSe9iJOitQQVkS+OcDayN/GSeHZD7p8V+eY6rtvdNrxINVcuAxPYL+QLbXD5yctaOxs+HfDK9bDYyedpEbtjGnyTzioKHimM7W3PBYGpFfdAhiAcckyd+lfjBfEkjDlJBqzPgdkvTa+tZrR2kA1/QGVBuOpScHI7OlXQnuTXCJqwp8l6lI4umsosjlWw28EShDJQ6SDiNUqtpcbpAVc818PTqO1pdH269i9nqujHkPmdPOddV4nWI=\"            ],            \"x5t\": \"_LzkYFjU_do-qUGGVHGwwFNKaDQ\",            \"x5t#S256\": \"uK879e7BK9sCySdxp16FIW0M7y1-pIvbISgJo6elcHk\"        }    ]}", StandardCharsets.UTF_8));
            XMLConfiguration config = ConfigLoader.getConfig((InputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"oauth.xml"));
            config.addProperty("auth.oidc.jwksURL", (Object)String.format("http://127.0.0.1:%s%s", this.authServer.getLocalPort(), this.JWKS_URI_PATH));
            config.addProperty("auth.oidc.claim", (Object)"email_address");
            config.addProperty("auth.oidc.oidcConfigurationURL", (Object)"https://example.com/jwks");
            config.addProperty("auth.oidc.scope", (Object)"email");
            this.imapServer = IMAPServerTest.this.createImapServer((HierarchicalConfiguration<ImmutableNode>)config);
            this.port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
        }

        @AfterEach
        void tearDown() {
            if (this.imapServer != null) {
                this.imapServer.destroy();
            }
            this.authServer.stop();
        }

        @Test
        void oauthShouldSuccessWhenValidToken() throws Exception {
            String oauthBearer = OIDCSASLHelper.generateOauthBearer((String)USER.asString(), (String)"eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCIsImtpZCI6Inc4MFBzNUlhc24tYUdXbXcyVHJ4RGlOY2FocEgyc1h6NXBxZGhBbDlIWGMifQ.eyJleHAiOjM5Mzk1MDYxNjcsImlhdCI6MTYzOTUwNTg2NywiYXV0aF90aW1lIjozNjM5NTA1ODQxLCJqdGkiOiJjMjQ5ZTBkNi1jY2JiLTRmZDAtODI5Yi04OTM1MjczN2YzZGIiLCJpc3MiOiJodHRwOi8vbG9jYWxob3N0OjgwODAvYXV0aC9yZWFsbXMvcmVhbG0xIiwiYXVkIjoiYWNjb3VudCIsInN1YiI6IjIwNDUyNzFiLWMxYmItNDJiOC1hMTkwLThlYWI1MmYzYmEwOSIsInR5cCI6IkJlYXJlciIsImF6cCI6ImFjY291bnQtY29uc29sZSIsIm5vbmNlIjoiNWUyOGJjNTAtODE5NS00NjM3LThmMWEtYWUzNWFlYTk0NTc1Iiwic2Vzc2lvbl9zdGF0ZSI6ImMxYzI3MmYwLWMwMjAtNGZmMC1hMzYwLTQ3MGJlYWVlNWUwMCIsImFjciI6IjAiLCJyZXNvdXJjZV9hY2Nlc3MiOnsiYWNjb3VudCI6eyJyb2xlcyI6WyJtYW5hZ2UtYWNjb3VudCIsIm1hbmFnZS1hY2NvdW50LWxpbmtzIl19fSwic2NvcGUiOiJvcGVuaWQgZW1haWwgcHJvZmlsZSIsInNpZCI6ImMxYzI3MmYwLWMwMjAtNGZmMC1hMzYwLTQ3MGJlYWVlNWUwMCIsImVtYWlsX3ZlcmlmaWVkIjpmYWxzZSwicHJlZmVycmVkX3VzZXJuYW1lIjoiamFtZXMiLCJlbWFpbF9hZGRyZXNzIjoidXNlckBkb21haW4ub3JnIn0.bqHsX3yngXwXyVW7LenKzHbdqZy1AmCjE3QWrp7Y1sd_zcQEu5WABwLIOAzrXiNFeGwyww8taGJBdYa0KTBCY6MYkAHAEa1vyyO1LfJgr3cIfQT6WCf3g2BJqHRjUsqNgT_Sit9druMRke01m1V0EmzqIdLLHp8Vl-u4R3JSDx1bsQ1w3WCRlcgr_k3EJ7jNiuNnklCH8_o59y4c7Rzdpl-Y8tcA07nGjeJ_7qPgNZX6lgwvr0EhpQpbVDHXwQlp2NDzkWwBLJR0-V50Q0a-L0QD69wqeEaqi1xaRAfx2Gwn2FgCgMUWzKeW_qkEBP0tnN-pzl7j31EOnmKhshlOtw");
            AuthenticatingIMAPClient client = IMAPServerTest.this.imapsClient(this.port);
            client.sendCommand("AUTHENTICATE OAUTHBEARER " + oauthBearer);
            Assertions.assertThat((String)client.getReplyString()).contains(new CharSequence[]{"OK AUTHENTICATE completed."});
        }

        @Test
        void oauthShouldFailWhenInValidToken() throws Exception {
            AuthenticatingIMAPClient client = IMAPServerTest.this.imapsClient(this.port);
            client.sendCommand("AUTHENTICATE OAUTHBEARER invalidtoken");
            Assertions.assertThat((String)client.getReplyString()).contains(new CharSequence[]{"NO AUTHENTICATE failed."});
        }

        @Test
        void oauthShouldFailWhenConfigIsNotProvided() throws Exception {
            this.imapServer.destroy();
            XMLConfiguration config = ConfigLoader.getConfig((InputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"imapServerRequireSSLIsTrueAndStartSSLIsTrue.xml"));
            this.imapServer = IMAPServerTest.this.createImapServer((HierarchicalConfiguration<ImmutableNode>)config);
            int port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
            AuthenticatingIMAPClient client = IMAPServerTest.this.imapsClient(port);
            client.sendCommand("AUTHENTICATE OAUTHBEARER eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCIsImtpZCI6Inc4MFBzNUlhc24tYUdXbXcyVHJ4RGlOY2FocEgyc1h6NXBxZGhBbDlIWGMifQ.eyJleHAiOjM5Mzk1MDYxNjcsImlhdCI6MTYzOTUwNTg2NywiYXV0aF90aW1lIjozNjM5NTA1ODQxLCJqdGkiOiJjMjQ5ZTBkNi1jY2JiLTRmZDAtODI5Yi04OTM1MjczN2YzZGIiLCJpc3MiOiJodHRwOi8vbG9jYWxob3N0OjgwODAvYXV0aC9yZWFsbXMvcmVhbG0xIiwiYXVkIjoiYWNjb3VudCIsInN1YiI6IjIwNDUyNzFiLWMxYmItNDJiOC1hMTkwLThlYWI1MmYzYmEwOSIsInR5cCI6IkJlYXJlciIsImF6cCI6ImFjY291bnQtY29uc29sZSIsIm5vbmNlIjoiNWUyOGJjNTAtODE5NS00NjM3LThmMWEtYWUzNWFlYTk0NTc1Iiwic2Vzc2lvbl9zdGF0ZSI6ImMxYzI3MmYwLWMwMjAtNGZmMC1hMzYwLTQ3MGJlYWVlNWUwMCIsImFjciI6IjAiLCJyZXNvdXJjZV9hY2Nlc3MiOnsiYWNjb3VudCI6eyJyb2xlcyI6WyJtYW5hZ2UtYWNjb3VudCIsIm1hbmFnZS1hY2NvdW50LWxpbmtzIl19fSwic2NvcGUiOiJvcGVuaWQgZW1haWwgcHJvZmlsZSIsInNpZCI6ImMxYzI3MmYwLWMwMjAtNGZmMC1hMzYwLTQ3MGJlYWVlNWUwMCIsImVtYWlsX3ZlcmlmaWVkIjpmYWxzZSwicHJlZmVycmVkX3VzZXJuYW1lIjoiamFtZXMiLCJlbWFpbF9hZGRyZXNzIjoidXNlckBkb21haW4ub3JnIn0.bqHsX3yngXwXyVW7LenKzHbdqZy1AmCjE3QWrp7Y1sd_zcQEu5WABwLIOAzrXiNFeGwyww8taGJBdYa0KTBCY6MYkAHAEa1vyyO1LfJgr3cIfQT6WCf3g2BJqHRjUsqNgT_Sit9druMRke01m1V0EmzqIdLLHp8Vl-u4R3JSDx1bsQ1w3WCRlcgr_k3EJ7jNiuNnklCH8_o59y4c7Rzdpl-Y8tcA07nGjeJ_7qPgNZX6lgwvr0EhpQpbVDHXwQlp2NDzkWwBLJR0-V50Q0a-L0QD69wqeEaqi1xaRAfx2Gwn2FgCgMUWzKeW_qkEBP0tnN-pzl7j31EOnmKhshlOtw");
            Assertions.assertThat((String)client.getReplyString()).contains(new CharSequence[]{"NO AUTHENTICATE failed. Authentication mechanism is unsupported."});
        }

        @Test
        void capabilityShouldAdvertiseOAUTHBEARERWhenConfigIsProvided() throws Exception {
            AuthenticatingIMAPClient client = IMAPServerTest.this.imapsClient(this.port);
            client.capability();
            Assertions.assertThat((String)client.getReplyString()).contains(new CharSequence[]{"AUTH=OAUTHBEARER"});
        }

        @Test
        void capabilityShouldAdvertiseXOAUTH2WhenConfigIsProvided() throws Exception {
            AuthenticatingIMAPClient client = IMAPServerTest.this.imapsClient(this.port);
            client.capability();
            Assertions.assertThat((String)client.getReplyString()).contains(new CharSequence[]{"AUTH=XOAUTH2"});
        }

        @Test
        void oauthShouldSupportOAUTH2Type() throws Exception {
            String oauthBearer = OIDCSASLHelper.generateOauthBearer((String)USER.asString(), (String)"eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCIsImtpZCI6Inc4MFBzNUlhc24tYUdXbXcyVHJ4RGlOY2FocEgyc1h6NXBxZGhBbDlIWGMifQ.eyJleHAiOjM5Mzk1MDYxNjcsImlhdCI6MTYzOTUwNTg2NywiYXV0aF90aW1lIjozNjM5NTA1ODQxLCJqdGkiOiJjMjQ5ZTBkNi1jY2JiLTRmZDAtODI5Yi04OTM1MjczN2YzZGIiLCJpc3MiOiJodHRwOi8vbG9jYWxob3N0OjgwODAvYXV0aC9yZWFsbXMvcmVhbG0xIiwiYXVkIjoiYWNjb3VudCIsInN1YiI6IjIwNDUyNzFiLWMxYmItNDJiOC1hMTkwLThlYWI1MmYzYmEwOSIsInR5cCI6IkJlYXJlciIsImF6cCI6ImFjY291bnQtY29uc29sZSIsIm5vbmNlIjoiNWUyOGJjNTAtODE5NS00NjM3LThmMWEtYWUzNWFlYTk0NTc1Iiwic2Vzc2lvbl9zdGF0ZSI6ImMxYzI3MmYwLWMwMjAtNGZmMC1hMzYwLTQ3MGJlYWVlNWUwMCIsImFjciI6IjAiLCJyZXNvdXJjZV9hY2Nlc3MiOnsiYWNjb3VudCI6eyJyb2xlcyI6WyJtYW5hZ2UtYWNjb3VudCIsIm1hbmFnZS1hY2NvdW50LWxpbmtzIl19fSwic2NvcGUiOiJvcGVuaWQgZW1haWwgcHJvZmlsZSIsInNpZCI6ImMxYzI3MmYwLWMwMjAtNGZmMC1hMzYwLTQ3MGJlYWVlNWUwMCIsImVtYWlsX3ZlcmlmaWVkIjpmYWxzZSwicHJlZmVycmVkX3VzZXJuYW1lIjoiamFtZXMiLCJlbWFpbF9hZGRyZXNzIjoidXNlckBkb21haW4ub3JnIn0.bqHsX3yngXwXyVW7LenKzHbdqZy1AmCjE3QWrp7Y1sd_zcQEu5WABwLIOAzrXiNFeGwyww8taGJBdYa0KTBCY6MYkAHAEa1vyyO1LfJgr3cIfQT6WCf3g2BJqHRjUsqNgT_Sit9druMRke01m1V0EmzqIdLLHp8Vl-u4R3JSDx1bsQ1w3WCRlcgr_k3EJ7jNiuNnklCH8_o59y4c7Rzdpl-Y8tcA07nGjeJ_7qPgNZX6lgwvr0EhpQpbVDHXwQlp2NDzkWwBLJR0-V50Q0a-L0QD69wqeEaqi1xaRAfx2Gwn2FgCgMUWzKeW_qkEBP0tnN-pzl7j31EOnmKhshlOtw");
            AuthenticatingIMAPClient client = IMAPServerTest.this.imapsClient(this.port);
            client.sendCommand("AUTHENTICATE XOAUTH2 " + oauthBearer);
            Assertions.assertThat((String)client.getReplyString()).contains(new CharSequence[]{"OK AUTHENTICATE completed."});
        }

        @Test
        void capabilityShouldNotAdvertiseOAUTHBEARERWhenConfigIsNotProvided() throws Exception {
            this.imapServer.destroy();
            XMLConfiguration config = ConfigLoader.getConfig((InputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"imapServerRequireSSLIsTrueAndStartSSLIsTrue.xml"));
            this.imapServer = IMAPServerTest.this.createImapServer((HierarchicalConfiguration<ImmutableNode>)config);
            int port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
            AuthenticatingIMAPClient client = IMAPServerTest.this.imapsClient(port);
            client.capability();
            Assertions.assertThat((String)client.getReplyString()).doesNotContain(new CharSequence[]{"AUTH=OAUTHBEARER"});
            Assertions.assertThat((String)client.getReplyString()).doesNotContain(new CharSequence[]{"AUTH=XOAUTH2"});
        }

        @Test
        void shouldNotOauthWhenAuthIsReady() throws Exception {
            String oauthBearer = OIDCSASLHelper.generateOauthBearer((String)USER.asString(), (String)"eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCIsImtpZCI6Inc4MFBzNUlhc24tYUdXbXcyVHJ4RGlOY2FocEgyc1h6NXBxZGhBbDlIWGMifQ.eyJleHAiOjM5Mzk1MDYxNjcsImlhdCI6MTYzOTUwNTg2NywiYXV0aF90aW1lIjozNjM5NTA1ODQxLCJqdGkiOiJjMjQ5ZTBkNi1jY2JiLTRmZDAtODI5Yi04OTM1MjczN2YzZGIiLCJpc3MiOiJodHRwOi8vbG9jYWxob3N0OjgwODAvYXV0aC9yZWFsbXMvcmVhbG0xIiwiYXVkIjoiYWNjb3VudCIsInN1YiI6IjIwNDUyNzFiLWMxYmItNDJiOC1hMTkwLThlYWI1MmYzYmEwOSIsInR5cCI6IkJlYXJlciIsImF6cCI6ImFjY291bnQtY29uc29sZSIsIm5vbmNlIjoiNWUyOGJjNTAtODE5NS00NjM3LThmMWEtYWUzNWFlYTk0NTc1Iiwic2Vzc2lvbl9zdGF0ZSI6ImMxYzI3MmYwLWMwMjAtNGZmMC1hMzYwLTQ3MGJlYWVlNWUwMCIsImFjciI6IjAiLCJyZXNvdXJjZV9hY2Nlc3MiOnsiYWNjb3VudCI6eyJyb2xlcyI6WyJtYW5hZ2UtYWNjb3VudCIsIm1hbmFnZS1hY2NvdW50LWxpbmtzIl19fSwic2NvcGUiOiJvcGVuaWQgZW1haWwgcHJvZmlsZSIsInNpZCI6ImMxYzI3MmYwLWMwMjAtNGZmMC1hMzYwLTQ3MGJlYWVlNWUwMCIsImVtYWlsX3ZlcmlmaWVkIjpmYWxzZSwicHJlZmVycmVkX3VzZXJuYW1lIjoiamFtZXMiLCJlbWFpbF9hZGRyZXNzIjoidXNlckBkb21haW4ub3JnIn0.bqHsX3yngXwXyVW7LenKzHbdqZy1AmCjE3QWrp7Y1sd_zcQEu5WABwLIOAzrXiNFeGwyww8taGJBdYa0KTBCY6MYkAHAEa1vyyO1LfJgr3cIfQT6WCf3g2BJqHRjUsqNgT_Sit9druMRke01m1V0EmzqIdLLHp8Vl-u4R3JSDx1bsQ1w3WCRlcgr_k3EJ7jNiuNnklCH8_o59y4c7Rzdpl-Y8tcA07nGjeJ_7qPgNZX6lgwvr0EhpQpbVDHXwQlp2NDzkWwBLJR0-V50Q0a-L0QD69wqeEaqi1xaRAfx2Gwn2FgCgMUWzKeW_qkEBP0tnN-pzl7j31EOnmKhshlOtw");
            AuthenticatingIMAPClient client = IMAPServerTest.this.imapsClient(this.port);
            client.sendCommand("AUTHENTICATE OAUTHBEARER " + oauthBearer);
            client.sendCommand("AUTHENTICATE OAUTHBEARER " + oauthBearer);
            Assertions.assertThat((String)client.getReplyString()).contains(new CharSequence[]{"NO AUTHENTICATE failed. Command not valid in this state."});
        }

        @Test
        void appendShouldSuccessWhenAuthenticated() throws Exception {
            String oauthBearer = OIDCSASLHelper.generateOauthBearer((String)USER.asString(), (String)"eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCIsImtpZCI6Inc4MFBzNUlhc24tYUdXbXcyVHJ4RGlOY2FocEgyc1h6NXBxZGhBbDlIWGMifQ.eyJleHAiOjM5Mzk1MDYxNjcsImlhdCI6MTYzOTUwNTg2NywiYXV0aF90aW1lIjozNjM5NTA1ODQxLCJqdGkiOiJjMjQ5ZTBkNi1jY2JiLTRmZDAtODI5Yi04OTM1MjczN2YzZGIiLCJpc3MiOiJodHRwOi8vbG9jYWxob3N0OjgwODAvYXV0aC9yZWFsbXMvcmVhbG0xIiwiYXVkIjoiYWNjb3VudCIsInN1YiI6IjIwNDUyNzFiLWMxYmItNDJiOC1hMTkwLThlYWI1MmYzYmEwOSIsInR5cCI6IkJlYXJlciIsImF6cCI6ImFjY291bnQtY29uc29sZSIsIm5vbmNlIjoiNWUyOGJjNTAtODE5NS00NjM3LThmMWEtYWUzNWFlYTk0NTc1Iiwic2Vzc2lvbl9zdGF0ZSI6ImMxYzI3MmYwLWMwMjAtNGZmMC1hMzYwLTQ3MGJlYWVlNWUwMCIsImFjciI6IjAiLCJyZXNvdXJjZV9hY2Nlc3MiOnsiYWNjb3VudCI6eyJyb2xlcyI6WyJtYW5hZ2UtYWNjb3VudCIsIm1hbmFnZS1hY2NvdW50LWxpbmtzIl19fSwic2NvcGUiOiJvcGVuaWQgZW1haWwgcHJvZmlsZSIsInNpZCI6ImMxYzI3MmYwLWMwMjAtNGZmMC1hMzYwLTQ3MGJlYWVlNWUwMCIsImVtYWlsX3ZlcmlmaWVkIjpmYWxzZSwicHJlZmVycmVkX3VzZXJuYW1lIjoiamFtZXMiLCJlbWFpbF9hZGRyZXNzIjoidXNlckBkb21haW4ub3JnIn0.bqHsX3yngXwXyVW7LenKzHbdqZy1AmCjE3QWrp7Y1sd_zcQEu5WABwLIOAzrXiNFeGwyww8taGJBdYa0KTBCY6MYkAHAEa1vyyO1LfJgr3cIfQT6WCf3g2BJqHRjUsqNgT_Sit9druMRke01m1V0EmzqIdLLHp8Vl-u4R3JSDx1bsQ1w3WCRlcgr_k3EJ7jNiuNnklCH8_o59y4c7Rzdpl-Y8tcA07nGjeJ_7qPgNZX6lgwvr0EhpQpbVDHXwQlp2NDzkWwBLJR0-V50Q0a-L0QD69wqeEaqi1xaRAfx2Gwn2FgCgMUWzKeW_qkEBP0tnN-pzl7j31EOnmKhshlOtw");
            AuthenticatingIMAPClient imapsClient = IMAPServerTest.this.imapsClient(this.port);
            imapsClient.sendCommand("AUTHENTICATE OAUTHBEARER " + oauthBearer);
            imapsClient.create("INBOX");
            imapsClient.append("INBOX", null, null, IMAPServerTest.SMALL_MESSAGE);
            Assertions.assertThat((String)imapsClient.getReplyString()).contains(new CharSequence[]{"APPEND completed."});
        }

        @Test
        void appendShouldFailWhenNotAuthenticated() throws Exception {
            AuthenticatingIMAPClient imapsClient = IMAPServerTest.this.imapsClient(this.port);
            imapsClient.create("INBOX");
            Assertions.assertThat((String)imapsClient.getReplyString()).contains(new CharSequence[]{"Command not valid in this state."});
        }
    }

    @Nested
    class AuthenticationRequireSSL {
        IMAPServer imapServer;

        AuthenticationRequireSSL() {
        }

        @AfterEach
        void tearDown() {
            if (this.imapServer != null) {
                this.imapServer.destroy();
            }
        }

        @Test
        void loginShouldFailWhenRequireSSLAndUnEncryptedChannel() throws Exception {
            this.imapServer = IMAPServerTest.this.createImapServer("imapServerRequireSSLIsTrueAndStartSSLIsFalse.xml");
            int port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
            Assertions.assertThatThrownBy(() -> IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", port).login(USER.asString(), IMAPServerTest.USER_PASS)).hasMessage("Login failed");
        }

        @Test
        void loginShouldSuccessWhenRequireSSLAndEncryptedChannel() throws Exception {
            this.imapServer = IMAPServerTest.this.createImapServer("imapServerRequireSSLIsTrueAndStartSSLIsTrue.xml");
            int port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
            IMAPSClient client = new IMAPSClient(false, BogusSslContextFactory.getClientContext());
            client.setTrustManager(BogusTrustManagerFactory.getTrustManagers()[0]);
            client.connect("127.0.0.1", port);
            client.execTLS();
            client.login(USER.asString(), IMAPServerTest.USER_PASS);
            Assertions.assertThat((String)client.getReplyString()).contains(new CharSequence[]{"OK LOGIN completed."});
        }

        @Test
        void loginShouldSuccessWhenNOTRequireSSLAndUnEncryptedChannel() throws Exception {
            this.imapServer = IMAPServerTest.this.createImapServer("imapServerRequireSSLIsFalseAndStartSSLIsFalse.xml");
            int port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
            Assertions.assertThatCode(() -> IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", port).login(USER.asString(), IMAPServerTest.USER_PASS).append("INBOX", IMAPServerTest.SMALL_MESSAGE)).doesNotThrowAnyException();
        }

        @Test
        void loginShouldSuccessWhenNOTRequireSSLAndEncryptedChannel() throws Exception {
            this.imapServer = IMAPServerTest.this.createImapServer("imapServerRequireSSLIsFalseAndStartSSLIsTrue.xml");
            int port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
            IMAPSClient client = new IMAPSClient(false, BogusSslContextFactory.getClientContext());
            client.setTrustManager(BogusTrustManagerFactory.getTrustManagers()[0]);
            client.connect("127.0.0.1", port);
            client.execTLS();
            client.login(USER.asString(), IMAPServerTest.USER_PASS);
            Assertions.assertThat((String)client.getReplyString()).contains(new CharSequence[]{"OK LOGIN completed."});
        }
    }

    @Nested
    class PlainAuthDisallowedSSL {
        IMAPServer imapServer;
        private int port;

        PlainAuthDisallowedSSL() {
        }

        @BeforeEach
        void beforeEach() throws Exception {
            this.imapServer = IMAPServerTest.this.createImapServer("imapServerPlainAuthAllowed.xml");
            this.port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
        }

        @AfterEach
        void tearDown() {
            this.imapServer.destroy();
        }

        @Test
        void loginShouldSucceedOnUnEncryptedChannel() {
            Assertions.assertThatCode(() -> IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).login(USER.asString(), IMAPServerTest.USER_PASS)).doesNotThrowAnyException();
        }

        @Test
        void capabilityShouldAdvertiseLoginOnUnEncryptedChannel() throws Exception {
            IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port);
            ((AbstractStringAssert)Assertions.assertThat((String)IMAPServerTest.this.testIMAPClient.capability()).doesNotContain(new CharSequence[]{"LOGINDISABLED"})).contains(new CharSequence[]{"AUTH=PLAIN"});
        }
    }

    @Nested
    class PlainAuthDisallowed {
        IMAPServer imapServer;
        private int port;

        PlainAuthDisallowed() {
        }

        @BeforeEach
        void beforeEach() throws Exception {
            this.imapServer = IMAPServerTest.this.createImapServer("imapServerPlainAuthDisallowed.xml");
            this.port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
        }

        @AfterEach
        void tearDown() {
            this.imapServer.destroy();
        }

        @Test
        void loginShouldFailOnUnEncryptedChannel() {
            Assertions.assertThatThrownBy(() -> IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).login(USER.asString(), IMAPServerTest.USER_PASS)).hasMessage("Login failed");
        }

        @Test
        void capabilityShouldNotAdvertiseLoginOnUnEncryptedChannel() throws Exception {
            IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port);
            ((AbstractStringAssert)Assertions.assertThat((String)IMAPServerTest.this.testIMAPClient.capability()).contains(new CharSequence[]{"LOGINDISABLED"})).doesNotContain(new CharSequence[]{"AUTH=PLAIN"});
        }
    }

    @Nested
    class PlainAuthEnabledWithoutRequireSSL {
        IMAPServer imapServer;
        private int port;

        PlainAuthEnabledWithoutRequireSSL() {
        }

        @BeforeEach
        void beforeEach() throws Exception {
            this.imapServer = IMAPServerTest.this.createImapServer("imapServerPlainAuthEnabledWithoutRequireSSL.xml");
            this.port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
        }

        @AfterEach
        void tearDown() {
            this.imapServer.destroy();
        }

        @Test
        void loginShouldSucceed() {
            Assertions.assertThatCode(() -> IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).login(USER.asString(), IMAPServerTest.USER_PASS)).doesNotThrowAnyException();
        }

        @Test
        void authenticatePlainShouldSucceed() {
            Assertions.assertThatCode(() -> IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).authenticatePlain(USER.asString(), IMAPServerTest.USER_PASS)).doesNotThrowAnyException();
        }

        @Test
        void capabilityShouldAdvertiseLoginAndAuthenticationPlain() throws Exception {
            IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port);
            ((AbstractStringAssert)Assertions.assertThat((String)IMAPServerTest.this.testIMAPClient.capability()).doesNotContain(new CharSequence[]{"LOGINDISABLED"})).contains(new CharSequence[]{"AUTH=PLAIN"});
        }
    }

    @Nested
    class PlainAuthDisabled {
        IMAPServer imapServer;
        private int port;

        PlainAuthDisabled() {
        }

        @BeforeEach
        void beforeEach() throws Exception {
            this.imapServer = IMAPServerTest.this.createImapServer("imapServerPlainAuthDisabled.xml");
            this.port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
        }

        @AfterEach
        void tearDown() {
            this.imapServer.destroy();
        }

        @Test
        void loginShouldFail() {
            Assertions.assertThatThrownBy(() -> IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).login(USER.asString(), IMAPServerTest.USER_PASS)).hasMessage("Login failed");
        }

        @Test
        void authenticatePlainShouldFail() {
            Assertions.assertThatThrownBy(() -> IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).authenticatePlain(USER.asString(), IMAPServerTest.USER_PASS)).hasMessage("Login failed");
        }

        @Test
        void capabilityShouldNotAdvertiseLoginAndAuthenticationPlain() throws Exception {
            IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port);
            ((AbstractStringAssert)Assertions.assertThat((String)IMAPServerTest.this.testIMAPClient.capability()).contains(new CharSequence[]{"LOGINDISABLED"})).doesNotContain(new CharSequence[]{"AUTH=PLAIN"});
        }
    }

    @Nested
    class Limit {
        IMAPServer imapServer;
        private int port;

        Limit() {
        }

        @BeforeEach
        void beforeEach() throws Exception {
            this.imapServer = IMAPServerTest.this.createImapServer("imapServer.xml");
            this.port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
        }

        @AfterEach
        void tearDown() {
            this.imapServer.destroy();
        }

        @Test
        void smallAppendsShouldWork() throws Exception {
            Assertions.assertThatCode(() -> IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).login(USER.asString(), IMAPServerTest.USER_PASS).append("INBOX", IMAPServerTest.SMALL_MESSAGE)).doesNotThrowAnyException();
            Assertions.assertThat((String)IMAPServerTest.this.testIMAPClient.select("INBOX").readFirstMessage()).contains(new CharSequence[]{"\r\nheader: value\r\n\r\nBODY)\r\n"});
        }

        @Test
        void mediumAppendsShouldWork() throws Exception {
            Assertions.assertThatCode(() -> IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).login(USER.asString(), IMAPServerTest.USER_PASS).append("INBOX", _65K_MESSAGE)).doesNotThrowAnyException();
            Assertions.assertThat((String)IMAPServerTest.this.testIMAPClient.select("INBOX").readFirstMessage()).contains(new CharSequence[]{"\r\n" + _65K_MESSAGE + ")\r\n"});
        }

        @Test
        void largeAppendsShouldBeRejected() {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).login(USER.asString(), IMAPServerTest.USER_PASS).append("INBOX", _129K_MESSAGE)).isInstanceOf(RuntimeException.class)).hasMessageContaining("BAD APPEND failed.");
        }
    }

    @Nested
    class Ssl {
        IMAPServer imapServer;

        Ssl() {
        }

        @AfterEach
        void tearDown() {
            if (this.imapServer != null) {
                this.imapServer.destroy();
            }
        }

        @Test
        void initShouldAcceptJKSFormat() {
            Assertions.assertThatCode(() -> {
                this.imapServer = IMAPServerTest.this.createImapServer("imapServerSslJKS.xml");
            }).doesNotThrowAnyException();
        }

        @Test
        void initShouldAcceptPKCS12Format() {
            Assertions.assertThatCode(() -> {
                this.imapServer = IMAPServerTest.this.createImapServer("imapServerSslPKCS12.xml");
            }).doesNotThrowAnyException();
        }

        @Test
        void initShouldAcceptPEMKeysWithPassword() {
            Assertions.assertThatCode(() -> {
                this.imapServer = IMAPServerTest.this.createImapServer("imapServerSslPEM.xml");
            }).doesNotThrowAnyException();
        }

        @Test
        void initShouldAcceptPEMKeysWithoutPassword() {
            Assertions.assertThatCode(() -> {
                this.imapServer = IMAPServerTest.this.createImapServer("imapServerSslPEMNoPass.xml");
            }).doesNotThrowAnyException();
        }

        @Test
        void initShouldAcceptJKSByDefault() {
            Assertions.assertThatCode(() -> {
                this.imapServer = IMAPServerTest.this.createImapServer("imapServerSslDefaultJKS.xml");
            }).doesNotThrowAnyException();
        }

        @Test
        void initShouldThrowWhenSslEnabledWithoutKeys() {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IMAPServerTest.this.createImapServer("imapServerSslNoKeys.xml")).isInstanceOf(ConfigurationException.class)).hasMessageContaining("keystore or (privateKey and certificates) needs to get configured");
        }

        @Test
        void initShouldThrowWhenJKSWithBadPassword() {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IMAPServerTest.this.createImapServer("imapServerSslJKSBadPassword.xml")).isInstanceOf(GenericKeyStoreException.class)).hasMessageContaining("keystore password was incorrect");
        }

        @Test
        void initShouldThrowWhenPEMWithBadPassword() {
            Assertions.assertThatThrownBy(() -> IMAPServerTest.this.createImapServer("imapServerSslPEMBadPass.xml")).isInstanceOf(PrivateKeyParseException.class);
        }

        @Test
        void initShouldThrowWhenPEMWithMissingPassword() {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IMAPServerTest.this.createImapServer("imapServerSslPEMMissingPass.xml")).isInstanceOf(IllegalArgumentException.class)).hasMessage("A password is mandatory with an encrypted key");
        }

        @Test
        void initShouldNotThrowWhenPEMWithExtraPassword() {
            Assertions.assertThatCode(() -> {
                this.imapServer = IMAPServerTest.this.createImapServer("imapServerSslPEMExtraPass.xml");
            }).doesNotThrowAnyException();
        }

        @Test
        void initShouldThrowWhenJKSWenNotFound() {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IMAPServerTest.this.createImapServer("imapServerSslJKSNotFound.xml")).isInstanceOf(FileNotFoundException.class)).hasMessage("class path resource [keystore.notfound.jks] cannot be resolved to URL because it does not exist");
        }

        @Test
        void initShouldThrowWhenPKCS12WithBadPassword() {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IMAPServerTest.this.createImapServer("imapServerSslPKCS12WrongPassword.xml")).isInstanceOf(GenericKeyStoreException.class)).hasMessageContaining("keystore password was incorrect");
        }

        @Test
        void initShouldThrowWhenPKCS12WithMissingPassword() {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IMAPServerTest.this.createImapServer("imapServerSslPKCS12MissingPassword.xml")).isInstanceOf(GenericKeyStoreException.class)).hasMessageContaining("keystore password was incorrect");
        }
    }

    @Nested
    class StartTLS {
        IMAPServer imapServer;
        private int port;
        private Connection connection;
        private ConcurrentLinkedDeque<String> responses;

        StartTLS() {
        }

        @BeforeEach
        void beforeEach() throws Exception {
            this.imapServer = IMAPServerTest.this.createImapServer("imapServerStartTLS.xml");
            this.port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
            this.connection = TcpClient.create().noSSL().remoteAddress(() -> new InetSocketAddress("127.0.0.1", this.port)).option(ChannelOption.TCP_NODELAY, (Object)true).connectNow();
            this.responses = new ConcurrentLinkedDeque();
            this.connection.inbound().receive().asString().doOnNext(s -> System.out.println("A: " + s)).doOnNext(this.responses::addLast).subscribeOn(Schedulers.elastic()).subscribe();
        }

        @AfterEach
        void tearDown() {
            this.imapServer.destroy();
        }

        @Test
        void extraLinesBatchedWithStartTLSShouldBeSanitized() throws Exception {
            IMAPSClient imapClient = new IMAPSClient();
            imapClient.connect("127.0.0.1", this.port);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> imapClient.sendCommand("STARTTLS\r\nA1 NOOP\r\n")).isInstanceOf(EOFException.class)).hasMessage("Connection closed without indication.");
        }

        @Test
        void extraLFLinesBatchedWithStartTLSShouldBeSanitized() throws Exception {
            IMAPSClient imapClient = new IMAPSClient();
            imapClient.connect("127.0.0.1", this.port);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> imapClient.sendCommand("STARTTLS\nA1 NOOP\r\n")).isInstanceOf(EOFException.class)).hasMessage("Connection closed without indication.");
        }

        @Test
        void tagsShouldBeWellSanitized() throws Exception {
            IMAPSClient imapClient = new IMAPSClient();
            imapClient.connect("127.0.0.1", this.port);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> imapClient.sendCommand("NOOP\r\n A1 STARTTLS\r\nA2 NOOP")).isInstanceOf(EOFException.class)).hasMessage("Connection closed without indication.");
        }

        @Test
        void lineFollowingStartTLSShouldBeSanitized() throws Exception {
            IMAPSClient imapClient = new IMAPSClient();
            imapClient.connect("127.0.0.1", this.port);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> imapClient.sendCommand("STARTTLS A1 NOOP\r\n")).isInstanceOf(EOFException.class)).hasMessage("Connection closed without indication.");
        }

        @Test
        void startTLSShouldFailWhenAuthenticated() throws Exception {
            IMAPSClient imapClient = new IMAPSClient();
            imapClient.connect("127.0.0.1", this.port);
            imapClient.login(USER.asString(), IMAPServerTest.USER_PASS);
            int imapCode = imapClient.sendCommand("STARTTLS\r\n");
            Assertions.assertThat((int)imapCode).isEqualTo(1);
        }

        private void send(String format) {
            this.connection.outbound().send((Publisher)Mono.just((Object)Unpooled.wrappedBuffer((byte[])format.getBytes(StandardCharsets.UTF_8)))).then().subscribe();
        }

        @RepeatedTest(value=10)
        void concurrencyShouldNotLeadToCommandInjection() throws Exception {
            ListAppender<ILoggingEvent> listAppender = IMAPServerTest.getListAppenderForClass(AbstractChainedProcessor.class);
            this.send("a0 STARTTLS\r\n");
            this.send("a1 NOOP\r\n");
            Thread.sleep(50L);
            ((ListAssert)Assertions.assertThat((List)listAppender.list).filteredOn(event -> event.getFormattedMessage().contains("Processing org.apache.james.imap.message.request.NoopRequest"))).isEmpty();
        }
    }

    @Nested
    class Compress {
        IMAPServer imapServer;
        private int port;

        Compress() {
        }

        @BeforeEach
        void beforeEach() throws Exception {
            this.imapServer = IMAPServerTest.this.createImapServer("imapServerCompress.xml");
            this.port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
        }

        @AfterEach
        void tearDown() {
            this.imapServer.destroy();
        }

        @Test
        void shouldNotThrowWhenCompressionEnabled() throws Exception {
            InMemoryMailboxManager mailboxManager = IMAPServerTest.this.memoryIntegrationResources.getMailboxManager();
            MailboxSession mailboxSession = mailboxManager.createSystemSession(USER);
            mailboxManager.createMailbox(MailboxPath.inbox((Username)USER), mailboxSession);
            mailboxManager.getMailbox(MailboxPath.inbox((Username)USER), mailboxSession).appendMessage(MessageManager.AppendCommand.builder().build("header: value\r\n\r\nbody"), mailboxSession);
            Properties props = new Properties();
            props.put("mail.imap.user", USER.asString());
            props.put("mail.imap.host", "127.0.0.1");
            props.put("mail.imap.auth.mechanisms", "LOGIN");
            props.put("mail.imap.compress.enable", (Object)true);
            Session session = Session.getInstance((Properties)props);
            Store store = session.getStore("imap");
            store.connect("127.0.0.1", this.port, USER.asString(), IMAPServerTest.USER_PASS);
            FetchProfile fetchProfile = new FetchProfile();
            fetchProfile.add(FetchProfile.Item.ENVELOPE);
            IMAPFolder inbox = (IMAPFolder)store.getFolder("INBOX");
            inbox.open(2);
            inbox.getMessageByUID(1L);
        }
    }

    @Nested
    class NoLimit {
        IMAPServer imapServer;
        private int port;

        NoLimit() {
        }

        @BeforeEach
        void beforeEach() throws Exception {
            this.imapServer = IMAPServerTest.this.createImapServer("imapServerNoLimits.xml");
            this.port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
        }

        @AfterEach
        void tearDown() {
            this.imapServer.destroy();
        }

        @Test
        void smallAppendsShouldWork() throws Exception {
            Assertions.assertThatCode(() -> IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).login(USER.asString(), IMAPServerTest.USER_PASS).append("INBOX", IMAPServerTest.SMALL_MESSAGE)).doesNotThrowAnyException();
            Assertions.assertThat((String)IMAPServerTest.this.testIMAPClient.select("INBOX").readFirstMessage()).contains(new CharSequence[]{"\r\nheader: value\r\n\r\nBODY)\r\n"});
        }

        @Test
        void mediumAppendsShouldWork() throws Exception {
            Assertions.assertThatCode(() -> IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).login(USER.asString(), IMAPServerTest.USER_PASS).append("INBOX", _65K_MESSAGE)).doesNotThrowAnyException();
            Assertions.assertThat((String)IMAPServerTest.this.testIMAPClient.select("INBOX").readFirstMessage()).contains(new CharSequence[]{"\r\n" + _65K_MESSAGE + ")\r\n"});
        }

        @Test
        void loginFixationShouldBeRejected() throws Exception {
            InMemoryMailboxManager mailboxManager = IMAPServerTest.this.memoryIntegrationResources.getMailboxManager();
            mailboxManager.createMailbox(MailboxPath.forUser((Username)USER, (String)"pwnd"), mailboxManager.createSystemSession(USER));
            mailboxManager.createMailbox(MailboxPath.forUser((Username)USER2, (String)"notvuln"), mailboxManager.createSystemSession(USER2));
            IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).rawLogin(USER.asString(), IMAPServerTest.USER_PASS);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IMAPServerTest.this.testIMAPClient.rawLogin(USER2.asString(), IMAPServerTest.USER_PASS)).isInstanceOf(IOException.class)).hasMessage("Login failed");
        }

        @RepeatedTest(value=200)
        void largeAppendsShouldWork() throws Exception {
            Assertions.assertThatCode(() -> IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).login(USER.asString(), IMAPServerTest.USER_PASS).append("INBOX", _129K_MESSAGE)).doesNotThrowAnyException();
            Assertions.assertThat((String)IMAPServerTest.this.testIMAPClient.select("INBOX").readFirstMessage()).contains(new CharSequence[]{"\r\n" + _129K_MESSAGE + ")\r\n"});
        }
    }

    @Nested
    class PartialFetch {
        IMAPServer imapServer;
        private int port;

        PartialFetch() {
        }

        @BeforeEach
        void beforeEach() throws Exception {
            this.imapServer = IMAPServerTest.this.createImapServer("imapServer.xml");
            this.port = ((InetSocketAddress)this.imapServer.getListenAddresses().get(0)).getPort();
        }

        @AfterEach
        void tearDown() {
            this.imapServer.destroy();
        }

        @Test
        void fetchShouldRetrieveMessage() throws Exception {
            IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).login(USER.asString(), IMAPServerTest.USER_PASS).append("INBOX", IMAPServerTest.SMALL_MESSAGE);
            Assertions.assertThat((String)IMAPServerTest.this.testIMAPClient.select("INBOX").readFirstMessage()).contains(new CharSequence[]{"* 1 FETCH (FLAGS (\\Recent \\Seen) BODY[] {21}\r\nheader: value\r\n\r\nBODY)\r\n"});
        }

        @Test
        void fetchShouldRetrieveMessageWhenOffsetAndLimitExceedingMessageSize() throws Exception {
            IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).login(USER.asString(), IMAPServerTest.USER_PASS).append("INBOX", IMAPServerTest.SMALL_MESSAGE);
            Assertions.assertThat((String)IMAPServerTest.this.testIMAPClient.select("INBOX").readFirstMessageInMailbox("BODY[]<8.20>")).contains(new CharSequence[]{"* 1 FETCH (FLAGS (\\Recent \\Seen) BODY[]<8> {13}\r\nvalue\r\n\r\nBODY)\r\n"});
        }

        @Test
        void fetchShouldRetrieveMessageWhenOffsetAndLimitEqualMessageSize() throws Exception {
            IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).login(USER.asString(), IMAPServerTest.USER_PASS).append("INBOX", IMAPServerTest.SMALL_MESSAGE);
            Assertions.assertThat((String)IMAPServerTest.this.testIMAPClient.select("INBOX").readFirstMessageInMailbox("BODY[]<8.13>")).contains(new CharSequence[]{"* 1 FETCH (FLAGS (\\Recent \\Seen) BODY[]<8> {13}\r\nvalue\r\n\r\nBODY)\r\n"});
        }

        @Test
        void fetchShouldRetrieveMessageWhenOffsetAndLimitBelowMessageSize() throws Exception {
            IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).login(USER.asString(), IMAPServerTest.USER_PASS).append("INBOX", IMAPServerTest.SMALL_MESSAGE);
            Assertions.assertThat((String)IMAPServerTest.this.testIMAPClient.select("INBOX").readFirstMessageInMailbox("BODY[]<8.12>")).contains(new CharSequence[]{"* 1 FETCH (FLAGS (\\Recent \\Seen) BODY[]<8> {12}\r\nvalue\r\n\r\nBOD)\r\n"});
        }

        @Test
        void fetchShouldRetrieveMessageWhenOffsetAndNoLimitSpecified() throws Exception {
            IMAPServerTest.this.testIMAPClient.connect("127.0.0.1", this.port).login(USER.asString(), IMAPServerTest.USER_PASS).append("INBOX", IMAPServerTest.SMALL_MESSAGE);
            Assertions.assertThat((String)IMAPServerTest.this.testIMAPClient.select("INBOX").readFirstMessageInMailbox("BODY[]<8>")).contains(new CharSequence[]{"* 1 FETCH (FLAGS (\\Recent \\Seen) BODY[]<8> {13}\r\nvalue\r\n\r\nBODY)\r\n"});
        }
    }
}

